/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;
import video.api.client.api.models.DeepObject;

public class UploadToken
implements Serializable,
DeepObject {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_TTL = "ttl";
    @SerializedName(value="ttl")
    private Integer ttl;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
    @SerializedName(value="expiresAt")
    private OffsetDateTime expiresAt;

    public UploadToken token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="to1tcmSFHeYY5KzyhOqVKMKb", value="The unique identifier for the token you will use to authenticate an upload.")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public UploadToken ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time-to-live - how long the upload token is valid for.")
    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public UploadToken createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-12-16T08:25:51Z", value="When the token was created, displayed in ISO-8601 format.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public UploadToken expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-12-16T09:25:51Z", value="When the token expires, displayed in ISO-8601 format.")
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadToken uploadToken = (UploadToken)o;
        return Objects.equals(this.token, uploadToken.token) && Objects.equals(this.ttl, uploadToken.ttl) && Objects.equals(this.createdAt, uploadToken.createdAt) && Objects.equals(this.expiresAt, uploadToken.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.ttl, this.createdAt, this.expiresAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UploadToken {\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    ttl: ").append(this.toIndentedString(this.ttl)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

