/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.BytesRange;
import video.api.client.api.models.VideoStatusIngestReceivedParts;

@ApiModel(description="Details about the capturing, transferring, and storing of your video for use immediately or in the future.")
public class VideoStatusIngest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_FILESIZE = "filesize";
    @SerializedName(value="filesize")
    private Integer filesize;
    public static final String SERIALIZED_NAME_RECEIVED_BYTES = "receivedBytes";
    @SerializedName(value="receivedBytes")
    private List<BytesRange> receivedBytes = null;
    public static final String SERIALIZED_NAME_RECEIVED_PARTS = "receivedParts";
    @SerializedName(value="receivedParts")
    private VideoStatusIngestReceivedParts receivedParts;

    public VideoStatusIngest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="uploaded", value="There are three possible ingest statuses. missing - you are missing information required to ingest the video. uploading - the video is in the process of being uploaded. uploaded - the video is ready for use.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public VideoStatusIngest filesize(Integer filesize) {
        this.filesize = filesize;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="200000", value="The size of your file in bytes.")
    public Integer getFilesize() {
        return this.filesize;
    }

    public void setFilesize(Integer filesize) {
        this.filesize = filesize;
    }

    public VideoStatusIngest receivedBytes(List<BytesRange> receivedBytes) {
        this.receivedBytes = receivedBytes;
        return this;
    }

    public VideoStatusIngest addReceivedBytesItem(BytesRange receivedBytesItem) {
        if (this.receivedBytes == null) {
            this.receivedBytes = new ArrayList<BytesRange>();
        }
        this.receivedBytes.add(receivedBytesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of bytes received, listed for each chunk of the upload.")
    public List<BytesRange> getReceivedBytes() {
        return this.receivedBytes;
    }

    public void setReceivedBytes(List<BytesRange> receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    public VideoStatusIngest receivedParts(VideoStatusIngestReceivedParts receivedParts) {
        this.receivedParts = receivedParts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoStatusIngestReceivedParts getReceivedParts() {
        return this.receivedParts;
    }

    public void setReceivedParts(VideoStatusIngestReceivedParts receivedParts) {
        this.receivedParts = receivedParts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoStatusIngest videoStatusIngest = (VideoStatusIngest)o;
        return Objects.equals((Object)this.status, (Object)videoStatusIngest.status) && Objects.equals(this.filesize, videoStatusIngest.filesize) && Objects.equals(this.receivedBytes, videoStatusIngest.receivedBytes) && Objects.equals(this.receivedParts, videoStatusIngest.receivedParts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.filesize, this.receivedBytes, this.receivedParts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoStatusIngest {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    filesize: ").append(this.toIndentedString(this.filesize)).append("\n");
        sb.append("    receivedBytes: ").append(this.toIndentedString(this.receivedBytes)).append("\n");
        sb.append("    receivedParts: ").append(this.toIndentedString(this.receivedParts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        MISSING("missing"),
        UPLOADING("uploading"),
        UPLOADED("uploaded");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

