/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

public class LiveStreamSessionReferrer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_MEDIUM = "medium";
    @SerializedName(value="medium")
    private String medium;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private String source;
    public static final String SERIALIZED_NAME_SEARCH_TERM = "searchTerm";
    @SerializedName(value="searchTerm")
    private String searchTerm;

    public LiveStreamSessionReferrer url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://api.video", value="The website the viewer of the live stream was referred to in order to view the live stream.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public LiveStreamSessionReferrer medium(String medium) {
        this.medium = medium;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="organic", value="The type of search that brought the viewer to the live stream. Organic would be they found it on their own, paid would be they found it via an advertisement.")
    public String getMedium() {
        return this.medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public LiveStreamSessionReferrer source(String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://google.com", value="Where the viewer came from to see the live stream (usually where they searched from).")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public LiveStreamSessionReferrer searchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="video stream", value="What term they searched for that led them to the live stream.")
    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveStreamSessionReferrer liveStreamSessionReferrer = (LiveStreamSessionReferrer)o;
        return Objects.equals(this.url, liveStreamSessionReferrer.url) && Objects.equals(this.medium, liveStreamSessionReferrer.medium) && Objects.equals(this.source, liveStreamSessionReferrer.source) && Objects.equals(this.searchTerm, liveStreamSessionReferrer.searchTerm);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.medium, this.source, this.searchTerm);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LiveStreamSessionReferrer {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    medium: ").append(this.toIndentedString(this.medium)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    searchTerm: ").append(this.toIndentedString(this.searchTerm)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

