/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.Page;
import video.api.client.api.models.Video;
import video.api.client.api.models.VideoCreationPayload;
import video.api.client.api.models.VideoStatus;
import video.api.client.api.models.VideoThumbnailPickPayload;
import video.api.client.api.models.VideoUpdatePayload;
import video.api.client.api.models.VideosListResponse;
import video.api.client.api.upload.UploadChunkRequestBody;
import video.api.client.api.upload.UploadPartProgressListener;
import video.api.client.api.upload.UploadProgressListener;

public class VideosApi {
    private ApiClient localVarApiClient;

    public VideosApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call deleteCall(String videoId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/videos/{videoId}".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteValidateBeforeCall(String videoId, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling delete");
        }
        Call localVarCall = this.deleteCall(videoId, _callback);
        return localVarCall;
    }

    public void delete(String videoId) throws ApiException {
        this.deleteWithHttpInfo(videoId);
    }

    public ApiResponse<Void> deleteWithHttpInfo(String videoId) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(videoId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call getCall(String videoId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/videos/{videoId}".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getValidateBeforeCall(String videoId, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling get");
        }
        Call localVarCall = this.getCall(videoId, _callback);
        return localVarCall;
    }

    public Video get(String videoId) throws ApiException {
        ApiResponse<Video> localVarResp = this.getWithHttpInfo(videoId);
        return localVarResp.getData();
    }

    public ApiResponse<Video> getWithHttpInfo(String videoId) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(videoId, null);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getStatusCall(String videoId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/videos/{videoId}/status".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStatusValidateBeforeCall(String videoId, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling getStatus");
        }
        Call localVarCall = this.getStatusCall(videoId, _callback);
        return localVarCall;
    }

    public VideoStatus getStatus(String videoId) throws ApiException {
        ApiResponse<VideoStatus> localVarResp = this.getStatusWithHttpInfo(videoId);
        return localVarResp.getData();
    }

    public ApiResponse<VideoStatus> getStatusWithHttpInfo(String videoId) throws ApiException {
        Call localVarCall = this.getStatusValidateBeforeCall(videoId, null);
        Type localVarReturnType = new TypeToken<VideoStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCall(String title, List<String> tags, Map<String, String> metadata, String description, String liveStreamId, String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/videos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (title != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("title", title));
        }
        if (tags != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "tags", tags));
        }
        if (metadata != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("metadata", metadata));
        }
        if (description != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("description", description));
        }
        if (liveStreamId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("liveStreamId", liveStreamId));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listValidateBeforeCall(String title, List<String> tags, Map<String, String> metadata, String description, String liveStreamId, String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCall(title, tags, metadata, description, liveStreamId, sortBy, sortOrder, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<VideosListResponse> listWithHttpInfo(String title, List<String> tags, Map<String, String> metadata, String description, String liveStreamId, String sortBy, String sortOrder, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(title, tags, metadata, description, liveStreamId, sortBy, sortOrder, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<VideosListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public APIlistRequest list() {
        return new APIlistRequest();
    }

    private Call updateCall(String videoId, VideoUpdatePayload videoUpdatePayload, ApiCallback _callback) throws ApiException {
        VideoUpdatePayload localVarPostBody = videoUpdatePayload;
        String localVarPath = "/videos/{videoId}".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateValidateBeforeCall(String videoId, VideoUpdatePayload videoUpdatePayload, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling update");
        }
        if (videoUpdatePayload == null) {
            throw new ApiException("Missing the required parameter 'videoUpdatePayload' when calling update");
        }
        Call localVarCall = this.updateCall(videoId, videoUpdatePayload, _callback);
        return localVarCall;
    }

    public Video update(String videoId, VideoUpdatePayload videoUpdatePayload) throws ApiException {
        ApiResponse<Video> localVarResp = this.updateWithHttpInfo(videoId, videoUpdatePayload);
        return localVarResp.getData();
    }

    public ApiResponse<Video> updateWithHttpInfo(String videoId, VideoUpdatePayload videoUpdatePayload) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(videoId, videoUpdatePayload, null);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call pickThumbnailCall(String videoId, VideoThumbnailPickPayload videoThumbnailPickPayload, ApiCallback _callback) throws ApiException {
        VideoThumbnailPickPayload localVarPostBody = videoThumbnailPickPayload;
        String localVarPath = "/videos/{videoId}/thumbnail".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call pickThumbnailValidateBeforeCall(String videoId, VideoThumbnailPickPayload videoThumbnailPickPayload, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling pickThumbnail");
        }
        if (videoThumbnailPickPayload == null) {
            throw new ApiException("Missing the required parameter 'videoThumbnailPickPayload' when calling pickThumbnail");
        }
        if (videoThumbnailPickPayload.getTimecode() == null) {
            throw new ApiException("Missing the required parameter 'videoThumbnailPickPayload.timecode' when calling pickThumbnail");
        }
        if (videoThumbnailPickPayload.getTimecode() == null) {
            throw new ApiException("Missing the required parameter 'videoThumbnailPickPayload.timecode' when calling pickThumbnail");
        }
        Call localVarCall = this.pickThumbnailCall(videoId, videoThumbnailPickPayload, _callback);
        return localVarCall;
    }

    public Video pickThumbnail(String videoId, VideoThumbnailPickPayload videoThumbnailPickPayload) throws ApiException {
        ApiResponse<Video> localVarResp = this.pickThumbnailWithHttpInfo(videoId, videoThumbnailPickPayload);
        return localVarResp.getData();
    }

    public ApiResponse<Video> pickThumbnailWithHttpInfo(String videoId, VideoThumbnailPickPayload videoThumbnailPickPayload) throws ApiException {
        Call localVarCall = this.pickThumbnailValidateBeforeCall(videoId, videoThumbnailPickPayload, null);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uploadWithUploadTokenCall(String token, File file, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadWithUploadTokenChunkCall(String token, File file, String videoId, long chunkStart, long chunkEnd, long totalBytes, Integer chunksCount, Integer chunkNum, UploadProgressListener progressListener, UploadPartProgressListener partProgressListener, ApiCallback _callback, boolean isProgressiveUpload) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            if (isProgressiveUpload) {
                localVarFormParams.put("file", (Object)new UploadChunkRequestBody(file, totalBytes, partProgressListener));
            } else {
                localVarFormParams.put("file", (Object)new UploadChunkRequestBody(file, chunksCount, chunkNum, totalBytes, chunkStart, chunkEnd + 1L, progressListener));
            }
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        localVarHeaderParams.put("Content-Range", "part " + chunkNum + "/" + (chunksCount != null ? chunksCount : "*"));
        if (videoId != null) {
            localVarFormParams.put("videoId", videoId);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadWithUploadTokenValidateBeforeCall(String token, File file, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling uploadWithUploadToken");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadWithUploadToken");
        }
        Call localVarCall = this.uploadWithUploadTokenCall(token, file, _callback);
        return localVarCall;
    }

    private Call uploadWithUploadTokenChunkValidateBeforeCall(String token, File file, String videoId, long chunkStart, long chunkEnd, long totalBytes, Integer chunksCount, Integer chunkNum, UploadProgressListener progressListener, UploadPartProgressListener partProgressListener, ApiCallback _callback, boolean isProgressiveUpload) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling uploadWithUploadToken(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadWithUploadToken(Async)");
        }
        Call localVarCall = this.uploadWithUploadTokenChunkCall(token, file, videoId, chunkStart, chunkEnd, totalBytes, chunksCount, chunkNum, progressListener, partProgressListener, _callback, isProgressiveUpload);
        return localVarCall;
    }

    public Video uploadWithUploadToken(String token, File file) throws ApiException {
        ApiResponse<Video> localVarResp = this.uploadWithUploadTokenWithHttpInfo(token, file);
        return localVarResp.getData();
    }

    public Video uploadWithUploadToken(String token, File file, UploadProgressListener uploadProgressListener) throws ApiException {
        ApiResponse<Video> localVarResp = this.uploadWithUploadTokenWithHttpInfo(token, file, uploadProgressListener);
        return localVarResp.getData();
    }

    public ApiResponse<Video> uploadWithUploadTokenWithHttpInfo(String token, File file) throws ApiException {
        return this.uploadWithUploadTokenWithHttpInfo(token, file, null);
    }

    public ApiResponse<Video> uploadWithUploadTokenPartWithHttpInfo(String token, File file, String videoId, Integer part, boolean isLast, UploadPartProgressListener uploadProgressListener) throws ApiException {
        long fileSize = file.length();
        Call localVarCall = this.uploadWithUploadTokenChunkValidateBeforeCall(token, file, videoId, 0L, fileSize, fileSize, isLast ? part : null, part, null, uploadProgressListener, null, true);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public UploadWithUploadTokenProgressiveSession createUploadWithUploadTokenProgressiveSession(String token) {
        return new UploadWithUploadTokenProgressiveSession(token);
    }

    public ApiResponse<Video> uploadWithUploadTokenWithHttpInfo(String token, File file, final UploadProgressListener uploadProgressListener) throws ApiException {
        long chunkSize;
        String videoId = null;
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload");
        }
        final long totalBytes = file.length();
        if (totalBytes > (chunkSize = this.getApiClient().getUploadChunkSize())) {
            int chunkNum = 0;
            ApiResponse lastRes = null;
            for (long i = 0L; i < totalBytes; i += chunkSize) {
                Call localVarCall = this.uploadWithUploadTokenChunkValidateBeforeCall(token, file, videoId, i, Math.min(i + chunkSize, totalBytes) - 1L, totalBytes, (int)Math.ceil((float)totalBytes / (float)chunkSize), chunkNum + 1, uploadProgressListener, null, null, false);
                Type localVarReturnType = new TypeToken<Video>(){}.getType();
                lastRes = this.localVarApiClient.execute(localVarCall, localVarReturnType);
                if (videoId == null) {
                    videoId = ((Video)lastRes.getData()).getVideoId();
                }
                ++chunkNum;
            }
            return lastRes;
        }
        ApiCallback apiCallback = new ApiCallback(){

            public void onFailure(ApiException e, int statusCode, Map responseHeaders) {
            }

            public void onSuccess(Object result, int statusCode, Map responseHeaders) {
            }

            @Override
            public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                if (uploadProgressListener != null) {
                    uploadProgressListener.onProgress(bytesWritten - (contentLength - totalBytes), totalBytes, 1, 1);
                }
            }

            @Override
            public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
            }
        };
        Call localVarCall = this.uploadWithUploadTokenValidateBeforeCall(token, file, apiCallback);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createCall(VideoCreationPayload videoCreationPayload, ApiCallback _callback) throws ApiException {
        VideoCreationPayload localVarPostBody = videoCreationPayload;
        String localVarPath = "/videos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createValidateBeforeCall(VideoCreationPayload videoCreationPayload, ApiCallback _callback) throws ApiException {
        if (videoCreationPayload == null) {
            throw new ApiException("Missing the required parameter 'videoCreationPayload' when calling create");
        }
        if (videoCreationPayload.getTitle() == null) {
            throw new ApiException("Missing the required parameter 'videoCreationPayload.title' when calling create");
        }
        Call localVarCall = this.createCall(videoCreationPayload, _callback);
        return localVarCall;
    }

    public Video create(VideoCreationPayload videoCreationPayload) throws ApiException {
        ApiResponse<Video> localVarResp = this.createWithHttpInfo(videoCreationPayload);
        return localVarResp.getData();
    }

    public ApiResponse<Video> createWithHttpInfo(VideoCreationPayload videoCreationPayload) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(videoCreationPayload, null);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uploadCall(String videoId, File file, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/videos/{videoId}/source".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadChunkCall(String videoId, File file, long chunkStart, long chunkEnd, long totalBytes, Integer chunksCount, Integer chunkNum, UploadProgressListener progressListener, UploadPartProgressListener partProgressListener, ApiCallback _callback, boolean isProgressiveUpload) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/videos/{videoId}/source".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            if (isProgressiveUpload) {
                localVarFormParams.put("file", (Object)new UploadChunkRequestBody(file, totalBytes, partProgressListener));
            } else {
                localVarFormParams.put("file", (Object)new UploadChunkRequestBody(file, chunksCount, chunkNum, totalBytes, chunkStart, chunkEnd + 1L, progressListener));
            }
        }
        localVarHeaderParams.put("Content-Range", "part " + chunkNum + "/" + (chunksCount != null ? chunksCount : "*"));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadValidateBeforeCall(String videoId, File file, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling upload");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload");
        }
        Call localVarCall = this.uploadCall(videoId, file, _callback);
        return localVarCall;
    }

    private Call uploadChunkValidateBeforeCall(String videoId, File file, long chunkStart, long chunkEnd, long totalBytes, Integer chunksCount, Integer chunkNum, UploadProgressListener progressListener, UploadPartProgressListener partProgressListener, ApiCallback _callback, boolean isProgressiveUpload) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling upload(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload(Async)");
        }
        Call localVarCall = this.uploadChunkCall(videoId, file, chunkStart, chunkEnd, totalBytes, chunksCount, chunkNum, progressListener, partProgressListener, _callback, isProgressiveUpload);
        return localVarCall;
    }

    public Video upload(String videoId, File file) throws ApiException {
        ApiResponse<Video> localVarResp = this.uploadWithHttpInfo(videoId, file);
        return localVarResp.getData();
    }

    public Video upload(String videoId, File file, UploadProgressListener uploadProgressListener) throws ApiException {
        ApiResponse<Video> localVarResp = this.uploadWithHttpInfo(videoId, file, uploadProgressListener);
        return localVarResp.getData();
    }

    public ApiResponse<Video> uploadWithHttpInfo(String videoId, File file) throws ApiException {
        return this.uploadWithHttpInfo(videoId, file, null);
    }

    public ApiResponse<Video> uploadPartWithHttpInfo(String videoId, File file, Integer part, boolean isLast, UploadPartProgressListener uploadProgressListener) throws ApiException {
        long fileSize = file.length();
        Call localVarCall = this.uploadChunkValidateBeforeCall(videoId, file, 0L, fileSize, fileSize, isLast ? part : null, part, null, uploadProgressListener, null, true);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public UploadProgressiveSession createUploadProgressiveSession(String videoId) {
        return new UploadProgressiveSession(videoId);
    }

    public ApiResponse<Video> uploadWithHttpInfo(String videoId, File file, final UploadProgressListener uploadProgressListener) throws ApiException {
        long chunkSize;
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload");
        }
        final long totalBytes = file.length();
        if (totalBytes > (chunkSize = this.getApiClient().getUploadChunkSize())) {
            int chunkNum = 0;
            ApiResponse lastRes = null;
            for (long i = 0L; i < totalBytes; i += chunkSize) {
                Call localVarCall = this.uploadChunkValidateBeforeCall(videoId, file, i, Math.min(i + chunkSize, totalBytes) - 1L, totalBytes, (int)Math.ceil((float)totalBytes / (float)chunkSize), chunkNum + 1, uploadProgressListener, null, null, false);
                Type localVarReturnType = new TypeToken<Video>(){}.getType();
                lastRes = this.localVarApiClient.execute(localVarCall, localVarReturnType);
                ++chunkNum;
            }
            return lastRes;
        }
        ApiCallback apiCallback = new ApiCallback(){

            public void onFailure(ApiException e, int statusCode, Map responseHeaders) {
            }

            public void onSuccess(Object result, int statusCode, Map responseHeaders) {
            }

            @Override
            public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                if (uploadProgressListener != null) {
                    uploadProgressListener.onProgress(bytesWritten - (contentLength - totalBytes), totalBytes, 1, 1);
                }
            }

            @Override
            public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
            }
        };
        Call localVarCall = this.uploadValidateBeforeCall(videoId, file, apiCallback);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uploadThumbnailCall(String videoId, File file, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/videos/{videoId}/thumbnail".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadThumbnailValidateBeforeCall(String videoId, File file, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling uploadThumbnail");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadThumbnail");
        }
        Call localVarCall = this.uploadThumbnailCall(videoId, file, _callback);
        return localVarCall;
    }

    public Video uploadThumbnail(String videoId, File file) throws ApiException {
        ApiResponse<Video> localVarResp = this.uploadThumbnailWithHttpInfo(videoId, file);
        return localVarResp.getData();
    }

    public ApiResponse<Video> uploadThumbnailWithHttpInfo(String videoId, File file) throws ApiException {
        Call localVarCall = this.uploadThumbnailValidateBeforeCall(videoId, file, null);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public class UploadProgressiveSession {
        private Integer part = 1;
        private String videoId;

        public UploadProgressiveSession(String videoId) {
            this.videoId = videoId;
        }

        public Video uploadPart(File part) throws ApiException {
            return this.uploadPart(part, false, null);
        }

        public Video uploadLastPart(File part) throws ApiException {
            return this.uploadPart(part, true, null);
        }

        public Video uploadPart(File part, UploadPartProgressListener uploadProgressListener) throws ApiException {
            return this.uploadPart(part, false, uploadProgressListener);
        }

        public Video uploadLastPart(File part, UploadPartProgressListener uploadProgressListener) throws ApiException {
            return this.uploadPart(part, true, uploadProgressListener);
        }

        public Video uploadPart(File part, boolean isLastPart, UploadPartProgressListener uploadProgressListener) throws ApiException {
            Integer lastPart = this.part;
            Integer n = this.part;
            Integer n2 = this.part = Integer.valueOf(this.part + 1);
            ApiResponse<Video> localVarResp = VideosApi.this.uploadPartWithHttpInfo(this.videoId, part, lastPart, isLastPart, uploadProgressListener);
            return localVarResp.getData();
        }
    }

    public class UploadWithUploadTokenProgressiveSession {
        private Integer part = 1;
        private String videoId;
        private String token;

        public UploadWithUploadTokenProgressiveSession(String token) {
            this.token = token;
        }

        public Video uploadPart(File part) throws ApiException {
            return this.uploadPart(part, false, null);
        }

        public Video uploadLastPart(File part) throws ApiException {
            return this.uploadPart(part, true, null);
        }

        public Video uploadPart(File part, UploadPartProgressListener uploadProgressListener) throws ApiException {
            return this.uploadPart(part, false, uploadProgressListener);
        }

        public Video uploadLastPart(File part, UploadPartProgressListener uploadProgressListener) throws ApiException {
            return this.uploadPart(part, true, uploadProgressListener);
        }

        public Video uploadPart(File part, boolean isLastPart, UploadPartProgressListener uploadProgressListener) throws ApiException {
            Integer lastPart = this.part;
            Integer n = this.part;
            Integer n2 = this.part = Integer.valueOf(this.part + 1);
            ApiResponse<Video> localVarResp = VideosApi.this.uploadWithUploadTokenPartWithHttpInfo(this.token, part, this.videoId, lastPart, isLastPart, uploadProgressListener);
            if (this.videoId == null) {
                this.videoId = localVarResp.getData().getVideoId();
            }
            return localVarResp.getData();
        }
    }

    public class APIlistRequest {
        private String title;
        private List<String> tags;
        private Map<String, String> metadata;
        private String description;
        private String liveStreamId;
        private String sortBy;
        private String sortOrder;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistRequest() {
        }

        public APIlistRequest title(String title) {
            this.title = title;
            return this;
        }

        public APIlistRequest tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public APIlistRequest metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public APIlistRequest description(String description) {
            this.description = description;
            return this;
        }

        public APIlistRequest liveStreamId(String liveStreamId) {
            this.liveStreamId = liveStreamId;
            return this;
        }

        public APIlistRequest sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public APIlistRequest sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public APIlistRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VideosApi.this.listCall(this.title, this.tags, this.metadata, this.description, this.liveStreamId, this.sortBy, this.sortOrder, this.currentPage, this.pageSize, _callback);
        }

        public Page<Video> execute() throws ApiException {
            ApiResponse localVarResp = VideosApi.this.listWithHttpInfo(this.title, this.tags, this.metadata, this.description, this.liveStreamId, this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
            return new Page<Video>(((VideosListResponse)localVarResp.getData()).getData(), ((VideosListResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistRequest copy() {
            APIlistRequest copy = new APIlistRequest();
            copy.title(this.title);
            copy.tags(this.tags);
            copy.metadata(this.metadata);
            copy.description(this.description);
            copy.liveStreamId(this.liveStreamId);
            copy.sortBy(this.sortBy);
            copy.sortOrder(this.sortOrder);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<VideosListResponse> executeWithHttpInfo() throws ApiException {
            return VideosApi.this.listWithHttpInfo(this.title, this.tags, this.metadata, this.description, this.liveStreamId, this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
        }
    }
}

