/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android.network.request;

import com.recurly.android.network.RecurlyError;
import com.recurly.android.network.request.GetRequest;
import java.util.HashMap;
import java.util.Map;

public class CouponRequest
extends GetRequest {
    private String planCode;
    private String couponCode;

    public CouponRequest(String planCode, String couponCode) {
        this.planCode = planCode;
        this.couponCode = couponCode;
    }

    public String getCouponCode() {
        return this.couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getPlanCode() {
        return this.planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    @Override
    public Map<String, String> getParams() {
        return new HashMap<String, String>();
    }

    @Override
    public boolean isListRequest() {
        return false;
    }

    @Override
    public String getEndpoint() {
        return "plans/" + this.planCode + "/coupons/" + this.couponCode;
    }

    @Override
    public RecurlyError validate() {
        if (this.planCode == null || this.planCode.isEmpty()) {
            return RecurlyError.validationError("plan code");
        }
        if (this.couponCode == null || this.couponCode.isEmpty()) {
            return RecurlyError.validationError("coupon code");
        }
        return null;
    }

    public static class Builder {
        private String mPlanCode;
        private String mCouponCode;

        public Builder setPlanCode(String planCode) {
            this.mPlanCode = planCode;
            return this;
        }

        public Builder setCouponCode(String couponCode) {
            this.mCouponCode = couponCode;
            return this;
        }

        public CouponRequest build() {
            return new CouponRequest(this.mPlanCode, this.mCouponCode);
        }
    }
}

