/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android.network.request;

import com.recurly.android.RecurlyValidator;
import com.recurly.android.network.RecurlyError;
import com.recurly.android.network.request.GetRequest;
import java.util.HashMap;
import java.util.Map;

public class CardPaymentRequest
extends GetRequest {
    private String number;
    private String firstName;
    private String lastName;
    private String cvv;
    private String country;
    private int expirationMonth;
    private int expirationYear;

    public CardPaymentRequest(String number, String firstName, String lastName, String cvv, String country, int expirationMonth, int expirationYear) {
        this.number = number;
        this.firstName = firstName;
        this.lastName = lastName;
        this.cvv = cvv;
        this.expirationMonth = expirationMonth;
        this.expirationYear = expirationYear;
        this.country = country;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCvv() {
        return this.cvv;
    }

    public void setCvv(String cvv) {
        this.cvv = cvv;
    }

    public int getExpirationMonth() {
        return this.expirationMonth;
    }

    public void setExpirationMonth(int expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    public int getExpirationYear() {
        return this.expirationYear;
    }

    public void setExpirationYear(int expirationYear) {
        this.expirationYear = expirationYear;
    }

    @Override
    public Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("first_name", this.firstName);
        params.put("last_name", this.lastName);
        params.put("number", this.number);
        params.put("month", "" + this.expirationMonth);
        params.put("year", "" + this.expirationYear);
        params.put("cvv", this.cvv);
        params.put("country", this.country);
        return params;
    }

    @Override
    public boolean isListRequest() {
        return false;
    }

    @Override
    public String getEndpoint() {
        return "token";
    }

    @Override
    public RecurlyError validate() {
        if (this.firstName == null || this.firstName.isEmpty()) {
            return RecurlyError.validationError("first name");
        }
        if (this.lastName == null || this.lastName.isEmpty()) {
            return RecurlyError.validationError("last name");
        }
        if (this.country == null || this.country.isEmpty()) {
            return RecurlyError.validationError("country");
        }
        if (!RecurlyValidator.validateCreditCard(this.number)) {
            return RecurlyError.validationError("credit card");
        }
        if (!RecurlyValidator.validateCvv(this.cvv)) {
            return RecurlyError.validationError("cvv");
        }
        if (!RecurlyValidator.validateExpirationDate(this.expirationMonth, this.expirationYear)) {
            return RecurlyError.validationError("expiration date");
        }
        return null;
    }

    public static class Builder {
        private String mNumber;
        private String mFirstName;
        private String mLastName;
        private String mCvv;
        private String mCountry;
        private int mExpirationMonth;
        private int mExpirationYear;

        public Builder setNumber(String number) {
            this.mNumber = number;
            return this;
        }

        public Builder setFirstName(String firstName) {
            this.mFirstName = firstName;
            return this;
        }

        public Builder setLastName(String lastName) {
            this.mLastName = lastName;
            return this;
        }

        public Builder setCvv(String cvv) {
            this.mCvv = cvv;
            return this;
        }

        public Builder setCountry(String country) {
            this.mCountry = country;
            return this;
        }

        public Builder setExpirationMonth(int expirationMonth) {
            this.mExpirationMonth = expirationMonth;
            return this;
        }

        public Builder setExpirationYear(int expirationYear) {
            this.mExpirationYear = expirationYear;
            return this;
        }

        public CardPaymentRequest build() {
            return new CardPaymentRequest(this.mNumber, this.mFirstName, this.mLastName, this.mCvv, this.mCountry, this.mExpirationMonth, this.mExpirationYear);
        }
    }
}

