/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android.network;

import android.content.Context;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.Volley;
import com.recurly.android.network.RecurlyRequest;
import java.util.HashMap;
import java.util.Map;

public class RecurlyNetwork {
    protected RequestQueue mRequestQueue = null;
    private static Map<String, String> sHeaders = new HashMap<String, String>();
    private int mRetryCount = 1;
    private float mBackoffMultiplier = 1.0f;
    private RetryPolicy mRetryPolicy = new DefaultRetryPolicy(2500, 1, 1.0f);

    public void init(Context context) {
        if (this.mRequestQueue == null) {
            this.mRequestQueue = Volley.newRequestQueue((Context)context);
        }
    }

    public void setRetryPolicy(int initialTimeout, int maxNumRetries, float backoffMultiplier) {
        this.mRetryCount = maxNumRetries;
        this.mBackoffMultiplier = backoffMultiplier;
        this.mRetryPolicy = new DefaultRetryPolicy(initialTimeout, maxNumRetries, backoffMultiplier);
    }

    public void setDefaultTimeout(int initialTimeout) {
        this.mRetryPolicy = new DefaultRetryPolicy(initialTimeout, this.mRetryCount, this.mBackoffMultiplier);
    }

    public static void setStaticHeader(String key, String value) {
        sHeaders.put(key, value);
    }

    public Map<String, String> getStaticHeaders() {
        return sHeaders;
    }

    public void transmitRequest(Request request) {
        request.setRetryPolicy(this.mRetryPolicy);
        if (request instanceof RecurlyRequest) {
            this.updateHeaders();
            ((RecurlyRequest)request).setHeaders(sHeaders);
        }
        this.mRequestQueue.add(request);
    }

    private void updateHeaders() {
        RecurlyNetwork.setStaticHeader("Accept", "application/xml");
    }

    public void cancelOutstandingRequests() {
        this.mRequestQueue.cancelAll(new RequestQueue.RequestFilter(){

            public boolean apply(Request<?> request) {
                return true;
            }
        });
    }
}

