/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android.model;

import com.recurly.android.model.BaseModel;
import com.recurly.android.model.Discount;

public class Coupon
extends BaseModel {
    private String code;
    private String name;
    private Discount discount;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    public DiscountType getDiscountType() {
        if (this.discount != null) {
            if (this.discount.getType().equals("percent")) {
                return DiscountType.DISCOUNT_TYPE_PERCENT;
            }
            if (this.discount.getType().equals("dollars")) {
                return DiscountType.DISCOUNT_TYPE_FIXED_AMOUNT;
            }
        }
        return DiscountType.DISCOUNT_TYPE_NONE;
    }

    public float getDiscount(float total) {
        switch (this.getDiscountType()) {
            case DISCOUNT_TYPE_NONE: {
                return 0.0f;
            }
            case DISCOUNT_TYPE_FIXED_AMOUNT: {
                return this.getDiscountAmount();
            }
            case DISCOUNT_TYPE_PERCENT: {
                return total * this.getDiscountRate();
            }
        }
        return 0.0f;
    }

    public float getDiscountRate() {
        if (this.discount != null) {
            return this.discount.getRate();
        }
        return 0.0f;
    }

    public float getDiscountAmount() {
        Float amount;
        if (this.discount != null && this.discount.getAmount() != null && (amount = this.discount.getAmount().get(sCurrency)) != null) {
            return amount.floatValue();
        }
        return 0.0f;
    }

    public String toString() {
        return "Coupon{code='" + this.code + '\'' + ", name='" + this.name + '\'' + ", discount=" + this.discount + '}';
    }

    public static enum DiscountType {
        DISCOUNT_TYPE_NONE,
        DISCOUNT_TYPE_PERCENT,
        DISCOUNT_TYPE_FIXED_AMOUNT;

    }
}

