/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android.network;

import android.content.Context;
import android.net.Uri;
import com.recurly.android.model.BaseModel;
import com.recurly.android.model.Coupon;
import com.recurly.android.model.Plan;
import com.recurly.android.model.Tax;
import com.recurly.android.network.RecurlyConfig;
import com.recurly.android.network.RecurlyListRequest;
import com.recurly.android.network.RecurlyNetwork;
import com.recurly.android.network.RecurlyRequest;
import com.recurly.android.network.ResponseHandler;
import com.recurly.android.network.request.CardPaymentRequest;
import com.recurly.android.network.request.CouponRequest;
import com.recurly.android.network.request.PlanRequest;
import com.recurly.android.network.request.TaxRequest;
import com.recurly.android.network.response.TokenResponse;
import com.recurly.android.util.RecurlyLog;
import java.util.List;
import java.util.Map;

public class RecurlyApiClient {
    private RecurlyNetwork mNetwork;
    private RecurlyConfig mRecurlyConfig;

    public void init(Context context, RecurlyConfig configuration) {
        this.mRecurlyConfig = configuration;
        BaseModel.setCurrency(configuration.getCurrency());
        this.mNetwork = new RecurlyNetwork();
        this.mNetwork.init(context);
        this.mNetwork.setDefaultTimeout(this.mRecurlyConfig.getDefaultTimeout());
    }

    public void getTaxForPostalCode(TaxRequest taxRequest, ResponseHandler<List<Tax>> responseHandler) {
        String url = this.buildRequestUrl(taxRequest.getEndpoint(), taxRequest.getParams(), true);
        RecurlyLog.d("URL is " + url);
        RecurlyListRequest<Tax> request = new RecurlyListRequest<Tax>(taxRequest, Tax.class, 0, url, responseHandler);
        this.mNetwork.transmitRequest(request);
    }

    public void getTokenForCardPayment(CardPaymentRequest paymentRequest, ResponseHandler<TokenResponse> responseHandler) {
        String url = this.buildRequestUrl(paymentRequest.getEndpoint(), paymentRequest.getParams(), true);
        RecurlyLog.d("URL is " + url);
        RecurlyRequest<TokenResponse> request = new RecurlyRequest<TokenResponse>(paymentRequest, TokenResponse.class, 0, url, responseHandler);
        this.mNetwork.transmitRequest(request);
    }

    public void getPlan(PlanRequest planRequest, ResponseHandler<Plan> responseHandler) {
        String url = this.buildRequestUrl(planRequest.getEndpoint(), planRequest.getParams(), true);
        RecurlyLog.d("URL is " + url);
        RecurlyRequest<Plan> request = new RecurlyRequest<Plan>(planRequest, Plan.class, 0, url, responseHandler);
        this.mNetwork.transmitRequest(request);
    }

    public void getCoupon(CouponRequest couponRequest, ResponseHandler<Coupon> responseHandler) {
        String url = this.buildRequestUrl(couponRequest.getEndpoint(), couponRequest.getParams(), true);
        RecurlyLog.d("URL is " + url);
        RecurlyRequest<Coupon> request = new RecurlyRequest<Coupon>(couponRequest, Coupon.class, 0, url, responseHandler);
        this.mNetwork.transmitRequest(request);
    }

    public String buildRequestUrl(String relativePath, Map<String, String> params, boolean appendKey) {
        Uri.Builder builder = Uri.parse((String)this.mRecurlyConfig.getBaseUrl()).buildUpon();
        builder.path(this.mRecurlyConfig.getApiPath() + "/" + relativePath);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        builder.appendQueryParameter("currency", this.mRecurlyConfig.getCurrency());
        if (appendKey) {
            builder.appendQueryParameter("key", this.mRecurlyConfig.getPublicKey());
            builder.appendQueryParameter("version", this.mRecurlyConfig.getApiVersion());
        }
        return builder.build().toString();
    }
}

