/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class RecurlyValidator {
    private static HashMap<CreditCardType, String> sCardRegexes;
    private static HashSet<String> sValidCountryCodes;

    public static boolean validateName(String name) {
        return name != null && !name.isEmpty();
    }

    public static CreditCardType getCreditCardType(String creditCard) {
        if (creditCard == null) {
            return CreditCardType.CREDIT_CARD_TYPE_UNKNOWN;
        }
        creditCard = RecurlyValidator.stripCardNumber(creditCard);
        for (CreditCardType type : sCardRegexes.keySet()) {
            String regex = sCardRegexes.get((Object)type);
            if (!creditCard.matches(regex)) continue;
            return type;
        }
        return CreditCardType.CREDIT_CARD_TYPE_UNKNOWN;
    }

    public static boolean validateCreditCard(String creditCard) {
        if (creditCard == null || creditCard.isEmpty()) {
            return false;
        }
        String cardNumber = RecurlyValidator.stripCardNumber(creditCard);
        return RecurlyValidator.luhnValidate(cardNumber);
    }

    private static boolean luhnValidate(String cardNumber) {
        int sum = 0;
        boolean alternate = false;
        for (int i = cardNumber.length() - 1; i >= 0; --i) {
            char c = cardNumber.charAt(i);
            int n = c - 48;
            if (n < 0 || n > 9) {
                return false;
            }
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate = !alternate;
        }
        return sum % 10 == 0;
    }

    private static String stripCardNumber(String card) {
        if (card == null) {
            return "";
        }
        return card.replaceAll(" ", "").replaceAll("-", "");
    }

    public static boolean validateCvv(String cvv) {
        if (cvv == null) {
            return false;
        }
        if ((cvv = cvv.trim()).length() < 3 || cvv.length() > 4) {
            return false;
        }
        try {
            Integer.parseInt(cvv);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean validateExpirationDate(String monthString, String yearString) {
        try {
            int month = Integer.parseInt(monthString);
            int year = Integer.parseInt(yearString);
            return RecurlyValidator.validateExpirationDate(month, year);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean validateExpirationDate(int month, int year) {
        if (month < 1 || month > 12) {
            return false;
        }
        if (year < 100) {
            year += 2000;
        }
        Date currentDate = new Date();
        SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy");
        int currentYear = Integer.parseInt(yearFormatter.format(currentDate));
        SimpleDateFormat monthFormatter = new SimpleDateFormat("MM");
        int currentMonth = Integer.parseInt(monthFormatter.format(currentDate));
        if (year < currentYear) {
            return false;
        }
        return year != currentYear || month >= currentMonth;
    }

    public static boolean validateCountryCode(String countryCode) {
        if (countryCode == null) {
            return false;
        }
        return sValidCountryCodes.contains(countryCode.toLowerCase());
    }

    static {
        String[] countries;
        sCardRegexes = new HashMap();
        sValidCountryCodes = new HashSet();
        sCardRegexes.put(CreditCardType.CREDIT_CARD_TYPE_VISA, "^4[0-9]{3}[0-9]+?");
        sCardRegexes.put(CreditCardType.CREDIT_CARD_TYPE_MASTERCARD, "^5[1-5][0-9]{2}[0-9]+");
        sCardRegexes.put(CreditCardType.CREDIT_CARD_TYPE_AMEX, "^3[47][0-9]{2}[0-9]+");
        sCardRegexes.put(CreditCardType.CREDIT_CARD_TYPE_DISCOVER, "^6(?:011|5[0-9]{2})[0-9]+");
        sCardRegexes.put(CreditCardType.CREDIT_CARD_TYPE_DINERS, "^3(?:0[0-5]|[68][0-9])[0-9][0-9]+");
        for (String country : countries = Locale.getISOCountries()) {
            sValidCountryCodes.add(country.toLowerCase());
        }
    }

    public static enum CreditCardType {
        CREDIT_CARD_TYPE_UNKNOWN,
        CREDIT_CARD_TYPE_VISA,
        CREDIT_CARD_TYPE_MASTERCARD,
        CREDIT_CARD_TYPE_AMEX,
        CREDIT_CARD_TYPE_DISCOVER,
        CREDIT_CARD_TYPE_DINERS;

    }
}

