/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;

public class SlopedPlaneGroundProfile
implements GroundProfile3D {
    private final Vector3D surfaceNormal = new Vector3D();
    private final Point3D intersectionPoint = new Point3D();
    private final BoundingBox3D boundingBox;
    private final Vector3D intersectionToQueryVector = new Vector3D();

    public SlopedPlaneGroundProfile(Vector3D surfaceNormal, Point3D intersectionPoint, double maxXY) {
        this.surfaceNormal.set(surfaceNormal);
        this.surfaceNormal.normalize();
        if (Math.abs(this.surfaceNormal.lengthSquared() - 1.0) > 1.0E-7) {
            throw new RuntimeException("Bad Surface Normal!");
        }
        this.intersectionPoint.set(intersectionPoint);
        double maxZ = intersectionPoint.getZ() + 1.0 / Math.abs(surfaceNormal.getZ()) * (Math.abs(surfaceNormal.getX()) * (maxXY + Math.abs(intersectionPoint.getX())) + Math.abs(surfaceNormal.getY()) * (maxXY + Math.abs(intersectionPoint.getY()))) + 0.01;
        this.boundingBox = new BoundingBox3D(-maxXY, -maxXY, Double.NEGATIVE_INFINITY, maxXY, maxXY, maxZ);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public boolean isClose(double x, double y, double z) {
        return this.boundingBox.isInsideInclusive(x, y, z);
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        normalToPack.set((Tuple3DReadOnly)this.surfaceNormal);
        this.intersectionToQueryVector.set(x, y, z);
        this.intersectionToQueryVector.sub((Tuple3DReadOnly)this.intersectionPoint);
        double dotProduct = this.intersectionToQueryVector.dot((Tuple3DReadOnly)this.surfaceNormal);
        intersectionToPack.set(x, y, z);
        intersectionToPack.scaleAdd(-dotProduct, (Tuple3DReadOnly)this.surfaceNormal, (Tuple3DReadOnly)intersectionToPack);
        return dotProduct <= 0.0;
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        if (this.surfaceNormal.getZ() < 1.0E-7) {
            return null;
        }
        return new HeightMapWithNormals(){

            public double heightAt(double x, double y, double z) {
                double pz = SlopedPlaneGroundProfile.this.intersectionPoint.getZ() + 1.0 / SlopedPlaneGroundProfile.this.surfaceNormal.getZ() * (SlopedPlaneGroundProfile.this.surfaceNormal.getX() * (-x + SlopedPlaneGroundProfile.this.intersectionPoint.getX()) + SlopedPlaneGroundProfile.this.surfaceNormal.getY() * (-y + SlopedPlaneGroundProfile.this.intersectionPoint.getY()));
                return pz;
            }

            public BoundingBox3D getBoundingBox() {
                return SlopedPlaneGroundProfile.this.boundingBox;
            }

            public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
                normalToPack.set((Tuple3DReadOnly)SlopedPlaneGroundProfile.this.surfaceNormal);
                return this.heightAt(x, y, z);
            }
        };
    }
}

