/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.engine.featherstone;

import java.util.ArrayList;
import java.util.Collection;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.GroundContactPointGroup;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.KinematicPoint;
import us.ihmc.simulationconstructionset.SpatialVector;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.JointPhysics;

public class FloatingJointPhysics
extends JointPhysics<FloatingJoint> {
    private double[] k_qdd_x = new double[4];
    private double[] k_qdd_y = new double[4];
    private double[] k_qdd_z = new double[4];
    private double[] k_qdd_wx = new double[4];
    private double[] k_qdd_wy = new double[4];
    private double[] k_qdd_wz = new double[4];
    private double[] k_qd_x = new double[4];
    private double[] k_qd_y = new double[4];
    private double[] k_qd_z = new double[4];
    private double[] k_qd_wx = new double[4];
    private double[] k_qd_wy = new double[4];
    private double[] k_qd_wz = new double[4];
    private double[] k_qd_qs = new double[4];
    private double[] k_qd_qx = new double[4];
    private double[] k_qd_qy = new double[4];
    private double[] k_qd_qz = new double[4];
    private Quaternion tempOrientation2 = new Quaternion();
    private Vector3D wXr1 = new Vector3D();
    private Vector3D a_hat_world_top = new Vector3D();
    private Vector3D a_hat_world_bot = new Vector3D();
    private DMatrixRMaj a_hat_matrix = new DMatrixRMaj(6, 1);
    private DMatrixRMaj Z_hat_matrix = new DMatrixRMaj(6, 1);
    private DMatrixRMaj Y_hat_matrix = new DMatrixRMaj(6, 1);
    private DMatrixRMaj I_hat_matrix = new DMatrixRMaj(6, 6);
    private Vector3D wdXr = new Vector3D();
    private Vector3D wXr = new Vector3D();
    private Vector3D wXwXr = new Vector3D();
    private Vector3D delta_qd_xyz = new Vector3D();
    private final DMatrixRMaj I_hat_inverse = new DMatrixRMaj(6, 6);
    private double q_x_n;
    private double q_y_n;
    private double q_z_n;
    private double qd_x_n;
    private double qd_y_n;
    private double qd_z_n;
    private double q_qs_n;
    private double q_qx_n;
    private double q_qy_n;
    private double q_qz_n;
    private double qd_wx_n;
    private double qd_wy_n;
    private double qd_wz_n;

    public FloatingJointPhysics(FloatingJoint owner) {
        super(owner);
    }

    @Override
    protected void jointDependentChangeVelocity(double delta_qd) {
        System.err.println("Error!!!! FloatingJoint.jointDependentChangeVelocity should never be called!!!");
    }

    @Override
    public void featherstonePassOne(Vector3DReadOnly w_h, Vector3DReadOnly v_h, RotationMatrixReadOnly Rh_0) {
        ((FloatingJoint)this.owner).update();
        this.Ri_0.set((RotationMatrixReadOnly)((FloatingJoint)this.owner).getOffsetTransform3D().getRotation());
        this.Ri_0.append((Orientation3DReadOnly)((FloatingJoint)this.owner).jointTransform3D.getRotation());
        this.Ri_0.transpose();
        this.Rh_i = null;
        this.Ri_h = null;
        this.d_i = null;
        this.u_iXd_i = null;
        this.r_i = null;
        this.jointDependentFeatherstonePassOne();
        this.R0_i.set(this.Ri_0);
        this.R0_i.transpose();
        if (this.groundContactPointGroups != null) {
            Collection groups = this.groundContactPointGroups.values();
            for (GroundContactPointGroup groundContactPointGroup : groups) {
                ArrayList<GroundContactPoint> groundContactPoints = groundContactPointGroup.getGroundContactPointsInContact();
                for (int i = 0; i < groundContactPoints.size(); ++i) {
                    GroundContactPoint point = groundContactPoints.get(i);
                    point.updatePointVelocity((RotationMatrixReadOnly)this.R0_i, (Vector3DReadOnly)((FloatingJoint)this.owner).link.comOffset, (Vector3DReadOnly)this.v_i, (Vector3DReadOnly)this.w_i);
                }
            }
        }
        if (this.kinematicPoints != null) {
            for (int i = 0; i < this.kinematicPoints.size(); ++i) {
                KinematicPoint point = (KinematicPoint)this.kinematicPoints.get(i);
                point.updatePointVelocity((RotationMatrixReadOnly)this.R0_i, (Vector3DReadOnly)((FloatingJoint)this.owner).link.comOffset, (Vector3DReadOnly)this.v_i, (Vector3DReadOnly)this.w_i);
            }
        }
        for (int i = 0; i < ((FloatingJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingJoint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassOne((Vector3DReadOnly)this.w_i, (Vector3DReadOnly)this.v_i, (RotationMatrixReadOnly)this.Ri_0);
        }
    }

    @Override
    protected void jointDependentSetAndGetRotation(RotationMatrixBasics Rh_i) {
        this.tempOrientation2.set(((FloatingJoint)this.owner).q_qx.getDoubleValue(), ((FloatingJoint)this.owner).q_qy.getDoubleValue(), ((FloatingJoint)this.owner).q_qz.getDoubleValue(), ((FloatingJoint)this.owner).q_qs.getDoubleValue());
        Rh_i.set((Orientation3DReadOnly)this.tempOrientation2);
    }

    @Override
    protected void jointDependentFeatherstonePassOne() {
        this.Q_i = 0.0;
        if (!((FloatingJoint)this.owner).isPinned()) {
            this.w_i.set(((FloatingJoint)this.owner).qd_wx.getDoubleValue(), ((FloatingJoint)this.owner).qd_wy.getDoubleValue(), ((FloatingJoint)this.owner).qd_wz.getDoubleValue());
            this.v_i.set(((FloatingJoint)this.owner).qd_x.getDoubleValue(), ((FloatingJoint)this.owner).qd_y.getDoubleValue(), ((FloatingJoint)this.owner).qd_z.getDoubleValue());
            this.Ri_0.transform((Tuple3DBasics)this.v_i);
            this.wXr1.cross((Tuple3DReadOnly)this.w_i, (Tuple3DReadOnly)((FloatingJoint)this.owner).link.comOffset);
            this.v_i.add((Tuple3DReadOnly)this.wXr1);
        } else {
            ((FloatingJoint)this.owner).qd_wx.set(0.0);
            ((FloatingJoint)this.owner).qd_wy.set(0.0);
            ((FloatingJoint)this.owner).qd_wz.set(0.0);
            ((FloatingJoint)this.owner).qd_x.set(0.0);
            ((FloatingJoint)this.owner).qd_y.set(0.0);
            ((FloatingJoint)this.owner).qd_z.set(0.0);
        }
    }

    @Override
    protected void jointDependentSet_d_i() {
        System.err.println("Error!!!! FloatingJoint.jointDependentSet_d_i should never be called!!!");
    }

    @Override
    protected void jointDependentFeatherstonePassTwo(Vector3DReadOnly w_h) {
        this.c_hat_i.top = null;
        this.c_hat_i.bottom = null;
        this.s_hat_i.top = null;
        this.s_hat_i.bottom = null;
    }

    @Override
    public void featherstonePassThree() {
        for (int i = 0; i < ((FloatingJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingJoint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassThree(this.I_hat_i, this.Z_hat_i);
        }
    }

    @Override
    public void featherstonePassFour(SpatialVector a_hat_h, int passNumber) throws UnreasonableAccelerationException {
        if (!((FloatingJoint)this.owner).isPinned()) {
            this.I_hat_i.getMatrix((DMatrix)this.I_hat_matrix);
            CommonOps_DDRM.invert((DMatrixRMaj)this.I_hat_matrix, (DMatrixRMaj)this.I_hat_inverse);
            this.Z_hat_i.getMatrix((DMatrix)this.Z_hat_matrix);
            CommonOps_DDRM.mult((DMatrix1Row)this.I_hat_inverse, (DMatrix1Row)this.Z_hat_matrix, (DMatrix1Row)this.a_hat_matrix);
            this.a_hat_i.top.set(-this.a_hat_matrix.get(0, 0), -this.a_hat_matrix.get(1, 0), -this.a_hat_matrix.get(2, 0));
            this.a_hat_i.bottom.set(-this.a_hat_matrix.get(3, 0), -this.a_hat_matrix.get(4, 0), -this.a_hat_matrix.get(5, 0));
            this.R0_i.set(this.Ri_0);
            this.R0_i.transpose();
            this.a_hat_world_top.set(this.a_hat_i.top);
            this.a_hat_world_bot.set(this.a_hat_i.bottom);
            this.wXr.cross((Tuple3DReadOnly)this.w_i, (Tuple3DReadOnly)((FloatingJoint)this.owner).link.comOffset);
            this.wXwXr.cross((Tuple3DReadOnly)this.w_i, (Tuple3DReadOnly)this.wXr);
            this.wdXr.cross((Tuple3DReadOnly)this.a_hat_world_top, (Tuple3DReadOnly)((FloatingJoint)this.owner).link.comOffset);
            this.a_hat_world_bot.sub((Tuple3DReadOnly)this.wdXr);
            this.a_hat_world_bot.sub((Tuple3DReadOnly)this.wXwXr);
            this.R0_i.transform((Tuple3DBasics)this.a_hat_world_bot);
            ((FloatingJoint)this.owner).qdd_x.set(this.a_hat_world_bot.getX());
            ((FloatingJoint)this.owner).qdd_y.set(this.a_hat_world_bot.getY());
            ((FloatingJoint)this.owner).qdd_z.set(this.a_hat_world_bot.getZ());
            ((FloatingJoint)this.owner).qdd_wx.set(this.a_hat_world_top.getX());
            ((FloatingJoint)this.owner).qdd_wy.set(this.a_hat_world_top.getY());
            ((FloatingJoint)this.owner).qdd_wz.set(this.a_hat_world_top.getZ());
        } else {
            this.a_hat_i.top.setToZero();
            this.a_hat_i.bottom.setToZero();
            ((FloatingJoint)this.owner).qdd_x.set(0.0);
            ((FloatingJoint)this.owner).qdd_y.set(0.0);
            ((FloatingJoint)this.owner).qdd_z.set(0.0);
            ((FloatingJoint)this.owner).qdd_wx.set(0.0);
            ((FloatingJoint)this.owner).qdd_wy.set(0.0);
            ((FloatingJoint)this.owner).qdd_wz.set(0.0);
        }
        this.jointDependentRecordK(passNumber);
        if (!this.jointDependentVerifyReasonableAccelerations()) {
            ArrayList<Joint> unreasonableAccelerationJoints = new ArrayList<Joint>();
            unreasonableAccelerationJoints.add(this.owner);
            throw new UnreasonableAccelerationException(unreasonableAccelerationJoints);
        }
        for (int i = 0; i < ((FloatingJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingJoint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassFour(this.a_hat_i, passNumber);
        }
    }

    @Override
    protected void jointDependentRecordK(int passNumber) {
        this.k_qdd_x[passNumber] = ((FloatingJoint)this.owner).qdd_x.getDoubleValue();
        this.k_qdd_y[passNumber] = ((FloatingJoint)this.owner).qdd_y.getDoubleValue();
        this.k_qdd_z[passNumber] = ((FloatingJoint)this.owner).qdd_z.getDoubleValue();
        this.k_qd_x[passNumber] = ((FloatingJoint)this.owner).qd_x.getDoubleValue();
        this.k_qd_y[passNumber] = ((FloatingJoint)this.owner).qd_y.getDoubleValue();
        this.k_qd_z[passNumber] = ((FloatingJoint)this.owner).qd_z.getDoubleValue();
        this.k_qdd_wx[passNumber] = ((FloatingJoint)this.owner).qdd_wx.getDoubleValue();
        this.k_qdd_wy[passNumber] = ((FloatingJoint)this.owner).qdd_wy.getDoubleValue();
        this.k_qdd_wz[passNumber] = ((FloatingJoint)this.owner).qdd_wz.getDoubleValue();
        this.k_qd_wx[passNumber] = ((FloatingJoint)this.owner).qd_wx.getDoubleValue();
        this.k_qd_wy[passNumber] = ((FloatingJoint)this.owner).qd_wy.getDoubleValue();
        this.k_qd_wz[passNumber] = ((FloatingJoint)this.owner).qd_wz.getDoubleValue();
        this.k_qd_qs[passNumber] = 0.5 * (-((FloatingJoint)this.owner).q_qx.getDoubleValue() * ((FloatingJoint)this.owner).qd_wx.getDoubleValue() - ((FloatingJoint)this.owner).q_qy.getDoubleValue() * ((FloatingJoint)this.owner).qd_wy.getDoubleValue() - ((FloatingJoint)this.owner).q_qz.getDoubleValue() * ((FloatingJoint)this.owner).qd_wz.getDoubleValue());
        this.k_qd_qx[passNumber] = 0.5 * (((FloatingJoint)this.owner).q_qs.getDoubleValue() * ((FloatingJoint)this.owner).qd_wx.getDoubleValue() - ((FloatingJoint)this.owner).q_qz.getDoubleValue() * ((FloatingJoint)this.owner).qd_wy.getDoubleValue() + ((FloatingJoint)this.owner).q_qy.getDoubleValue() * ((FloatingJoint)this.owner).qd_wz.getDoubleValue());
        this.k_qd_qy[passNumber] = 0.5 * (((FloatingJoint)this.owner).q_qz.getDoubleValue() * ((FloatingJoint)this.owner).qd_wx.getDoubleValue() + ((FloatingJoint)this.owner).q_qs.getDoubleValue() * ((FloatingJoint)this.owner).qd_wy.getDoubleValue() - ((FloatingJoint)this.owner).q_qx.getDoubleValue() * ((FloatingJoint)this.owner).qd_wz.getDoubleValue());
        this.k_qd_qz[passNumber] = 0.5 * (-((FloatingJoint)this.owner).q_qy.getDoubleValue() * ((FloatingJoint)this.owner).qd_wx.getDoubleValue() + ((FloatingJoint)this.owner).q_qx.getDoubleValue() * ((FloatingJoint)this.owner).qd_wy.getDoubleValue() + ((FloatingJoint)this.owner).q_qs.getDoubleValue() * ((FloatingJoint)this.owner).qd_wz.getDoubleValue());
    }

    @Override
    protected void jointDependentFeatherstonePassFour(double Q, int passNumber) {
    }

    @Override
    public void recursiveEulerIntegrate(double stepSize) {
        if (!((FloatingJoint)this.owner).isPinned()) {
            ((FloatingJoint)this.owner).q_x.set(this.q_x_n + ((FloatingJoint)this.owner).qd_x.getDoubleValue() * stepSize);
            ((FloatingJoint)this.owner).q_y.set(this.q_y_n + ((FloatingJoint)this.owner).qd_y.getDoubleValue() * stepSize);
            ((FloatingJoint)this.owner).q_z.set(this.q_z_n + ((FloatingJoint)this.owner).qd_z.getDoubleValue() * stepSize);
            ((FloatingJoint)this.owner).qd_x.set(this.qd_x_n + ((FloatingJoint)this.owner).qdd_x.getDoubleValue() * stepSize);
            ((FloatingJoint)this.owner).qd_y.set(this.qd_y_n + ((FloatingJoint)this.owner).qdd_y.getDoubleValue() * stepSize);
            ((FloatingJoint)this.owner).qd_z.set(this.qd_z_n + ((FloatingJoint)this.owner).qdd_z.getDoubleValue() * stepSize);
            ((FloatingJoint)this.owner).q_qs.set(this.q_qs_n + 0.5 * (-this.q_qx_n * this.qd_wx_n - this.q_qy_n * this.qd_wy_n - this.q_qz_n * this.qd_wz_n) * stepSize);
            ((FloatingJoint)this.owner).q_qx.set(this.q_qx_n + 0.5 * (this.q_qs_n * this.qd_wx_n - this.q_qz_n * this.qd_wy_n + this.q_qy_n * this.qd_wz_n) * stepSize);
            ((FloatingJoint)this.owner).q_qy.set(this.q_qy_n + 0.5 * (this.q_qz_n * this.qd_wx_n + this.q_qs_n * this.qd_wy_n - this.q_qx_n * this.qd_wz_n) * stepSize);
            ((FloatingJoint)this.owner).q_qz.set(this.q_qz_n + 0.5 * (-this.q_qy_n * this.qd_wx_n + this.q_qx_n * this.qd_wy_n + this.q_qs_n * this.qd_wz_n) * stepSize);
            ((FloatingJoint)this.owner).qd_wx.set(this.qd_wx_n + ((FloatingJoint)this.owner).qdd_wx.getDoubleValue() * stepSize);
            ((FloatingJoint)this.owner).qd_wy.set(this.qd_wy_n + ((FloatingJoint)this.owner).qdd_wy.getDoubleValue() * stepSize);
            ((FloatingJoint)this.owner).qd_wz.set(this.qd_wz_n + ((FloatingJoint)this.owner).qdd_wz.getDoubleValue() * stepSize);
            double q_qlength = Math.sqrt(((FloatingJoint)this.owner).q_qs.getDoubleValue() * ((FloatingJoint)this.owner).q_qs.getDoubleValue() + ((FloatingJoint)this.owner).q_qx.getDoubleValue() * ((FloatingJoint)this.owner).q_qx.getDoubleValue() + ((FloatingJoint)this.owner).q_qy.getDoubleValue() * ((FloatingJoint)this.owner).q_qy.getDoubleValue() + ((FloatingJoint)this.owner).q_qz.getDoubleValue() * ((FloatingJoint)this.owner).q_qz.getDoubleValue());
            ((FloatingJoint)this.owner).q_qs.set(((FloatingJoint)this.owner).q_qs.getDoubleValue() / q_qlength);
            ((FloatingJoint)this.owner).q_qx.set(((FloatingJoint)this.owner).q_qx.getDoubleValue() / q_qlength);
            ((FloatingJoint)this.owner).q_qy.set(((FloatingJoint)this.owner).q_qy.getDoubleValue() / q_qlength);
            ((FloatingJoint)this.owner).q_qz.set(((FloatingJoint)this.owner).q_qz.getDoubleValue() / q_qlength);
        }
        for (int i = 0; i < ((FloatingJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveEulerIntegrate(stepSize);
        }
    }

    @Override
    public void recursiveRungeKuttaSum(double stepSize) {
        if (!((FloatingJoint)this.owner).isPinned()) {
            ((FloatingJoint)this.owner).q_x.set(this.q_x_n + stepSize * (this.k_qd_x[0] / 6.0 + this.k_qd_x[1] / 3.0 + this.k_qd_x[2] / 3.0 + this.k_qd_x[3] / 6.0));
            ((FloatingJoint)this.owner).q_y.set(this.q_y_n + stepSize * (this.k_qd_y[0] / 6.0 + this.k_qd_y[1] / 3.0 + this.k_qd_y[2] / 3.0 + this.k_qd_y[3] / 6.0));
            ((FloatingJoint)this.owner).q_z.set(this.q_z_n + stepSize * (this.k_qd_z[0] / 6.0 + this.k_qd_z[1] / 3.0 + this.k_qd_z[2] / 3.0 + this.k_qd_z[3] / 6.0));
            ((FloatingJoint)this.owner).qd_x.set(this.qd_x_n + stepSize * (this.k_qdd_x[0] / 6.0 + this.k_qdd_x[1] / 3.0 + this.k_qdd_x[2] / 3.0 + this.k_qdd_x[3] / 6.0));
            ((FloatingJoint)this.owner).qd_y.set(this.qd_y_n + stepSize * (this.k_qdd_y[0] / 6.0 + this.k_qdd_y[1] / 3.0 + this.k_qdd_y[2] / 3.0 + this.k_qdd_y[3] / 6.0));
            ((FloatingJoint)this.owner).qd_z.set(this.qd_z_n + stepSize * (this.k_qdd_z[0] / 6.0 + this.k_qdd_z[1] / 3.0 + this.k_qdd_z[2] / 3.0 + this.k_qdd_z[3] / 6.0));
            ((FloatingJoint)this.owner).q_qs.set(this.q_qs_n + stepSize * (this.k_qd_qs[0] / 6.0 + this.k_qd_qs[1] / 3.0 + this.k_qd_qs[2] / 3.0 + this.k_qd_qs[3] / 6.0));
            ((FloatingJoint)this.owner).q_qx.set(this.q_qx_n + stepSize * (this.k_qd_qx[0] / 6.0 + this.k_qd_qx[1] / 3.0 + this.k_qd_qx[2] / 3.0 + this.k_qd_qx[3] / 6.0));
            ((FloatingJoint)this.owner).q_qy.set(this.q_qy_n + stepSize * (this.k_qd_qy[0] / 6.0 + this.k_qd_qy[1] / 3.0 + this.k_qd_qy[2] / 3.0 + this.k_qd_qy[3] / 6.0));
            ((FloatingJoint)this.owner).q_qz.set(this.q_qz_n + stepSize * (this.k_qd_qz[0] / 6.0 + this.k_qd_qz[1] / 3.0 + this.k_qd_qz[2] / 3.0 + this.k_qd_qz[3] / 6.0));
            double q_qlength = Math.sqrt(((FloatingJoint)this.owner).q_qs.getDoubleValue() * ((FloatingJoint)this.owner).q_qs.getDoubleValue() + ((FloatingJoint)this.owner).q_qx.getDoubleValue() * ((FloatingJoint)this.owner).q_qx.getDoubleValue() + ((FloatingJoint)this.owner).q_qy.getDoubleValue() * ((FloatingJoint)this.owner).q_qy.getDoubleValue() + ((FloatingJoint)this.owner).q_qz.getDoubleValue() * ((FloatingJoint)this.owner).q_qz.getDoubleValue());
            ((FloatingJoint)this.owner).q_qs.set(((FloatingJoint)this.owner).q_qs.getDoubleValue() / q_qlength);
            ((FloatingJoint)this.owner).q_qx.set(((FloatingJoint)this.owner).q_qx.getDoubleValue() / q_qlength);
            ((FloatingJoint)this.owner).q_qy.set(((FloatingJoint)this.owner).q_qy.getDoubleValue() / q_qlength);
            ((FloatingJoint)this.owner).q_qz.set(((FloatingJoint)this.owner).q_qz.getDoubleValue() / q_qlength);
            ((FloatingJoint)this.owner).qd_wx.set(this.qd_wx_n + stepSize * (this.k_qdd_wx[0] / 6.0 + this.k_qdd_wx[1] / 3.0 + this.k_qdd_wx[2] / 3.0 + this.k_qdd_wx[3] / 6.0));
            ((FloatingJoint)this.owner).qd_wy.set(this.qd_wy_n + stepSize * (this.k_qdd_wy[0] / 6.0 + this.k_qdd_wy[1] / 3.0 + this.k_qdd_wy[2] / 3.0 + this.k_qdd_wy[3] / 6.0));
            ((FloatingJoint)this.owner).qd_wz.set(this.qd_wz_n + stepSize * (this.k_qdd_wz[0] / 6.0 + this.k_qdd_wz[1] / 3.0 + this.k_qdd_wz[2] / 3.0 + this.k_qdd_wz[3] / 6.0));
        }
        for (int i = 0; i < ((FloatingJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveRungeKuttaSum(stepSize);
        }
    }

    @Override
    public void recursiveSaveTempState() {
        this.q_x_n = ((FloatingJoint)this.owner).q_x.getDoubleValue();
        this.q_y_n = ((FloatingJoint)this.owner).q_y.getDoubleValue();
        this.q_z_n = ((FloatingJoint)this.owner).q_z.getDoubleValue();
        this.q_qs_n = ((FloatingJoint)this.owner).q_qs.getDoubleValue();
        this.q_qx_n = ((FloatingJoint)this.owner).q_qx.getDoubleValue();
        this.q_qy_n = ((FloatingJoint)this.owner).q_qy.getDoubleValue();
        this.q_qz_n = ((FloatingJoint)this.owner).q_qz.getDoubleValue();
        if (!((FloatingJoint)this.owner).isPinned()) {
            this.qd_x_n = ((FloatingJoint)this.owner).qd_x.getDoubleValue();
            this.qd_y_n = ((FloatingJoint)this.owner).qd_y.getDoubleValue();
            this.qd_z_n = ((FloatingJoint)this.owner).qd_z.getDoubleValue();
            this.qd_wx_n = ((FloatingJoint)this.owner).qd_wx.getDoubleValue();
            this.qd_wy_n = ((FloatingJoint)this.owner).qd_wy.getDoubleValue();
            this.qd_wz_n = ((FloatingJoint)this.owner).qd_wz.getDoubleValue();
        } else {
            this.qd_x_n = 0.0;
            this.qd_y_n = 0.0;
            this.qd_z_n = 0.0;
            this.qd_wx_n = 0.0;
            this.qd_wy_n = 0.0;
            this.qd_wz_n = 0.0;
        }
        for (int i = 0; i < ((FloatingJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveSaveTempState();
        }
    }

    @Override
    public void recursiveRestoreTempState() {
        ((FloatingJoint)this.owner).q_x.set(this.q_x_n);
        ((FloatingJoint)this.owner).q_y.set(this.q_y_n);
        ((FloatingJoint)this.owner).q_z.set(this.q_z_n);
        ((FloatingJoint)this.owner).qd_x.set(this.qd_x_n);
        ((FloatingJoint)this.owner).qd_y.set(this.qd_y_n);
        ((FloatingJoint)this.owner).qd_z.set(this.qd_z_n);
        ((FloatingJoint)this.owner).q_qs.set(this.q_qs_n);
        ((FloatingJoint)this.owner).q_qx.set(this.q_qx_n);
        ((FloatingJoint)this.owner).q_qy.set(this.q_qy_n);
        ((FloatingJoint)this.owner).q_qz.set(this.q_qz_n);
        ((FloatingJoint)this.owner).qd_wx.set(this.qd_wx_n);
        ((FloatingJoint)this.owner).qd_wy.set(this.qd_wy_n);
        ((FloatingJoint)this.owner).qd_wz.set(this.qd_wz_n);
        for (int i = 0; i < ((FloatingJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveRestoreTempState();
        }
    }

    @Override
    protected void impulseResponseComputeDeltaV(SpatialVector delta_v_parent, SpatialVector delta_v_me) {
        this.Y_hat_i.getMatrix((DMatrix)this.Y_hat_matrix);
        CommonOps_DDRM.mult((DMatrix1Row)this.I_hat_inverse, (DMatrix1Row)this.Y_hat_matrix, (DMatrix1Row)this.a_hat_matrix);
        delta_v_me.top.set(-this.a_hat_matrix.get(0, 0), -this.a_hat_matrix.get(1, 0), -this.a_hat_matrix.get(2, 0));
        delta_v_me.bottom.set(-this.a_hat_matrix.get(3, 0), -this.a_hat_matrix.get(4, 0), -this.a_hat_matrix.get(5, 0));
    }

    @Override
    protected void propagateImpulseSetDeltaVOnPath(SpatialVector delta_v_parent, SpatialVector delta_v_me) {
        this.Y_hat_i.getMatrix((DMatrix)this.Y_hat_matrix);
        CommonOps_DDRM.mult((DMatrix1Row)this.I_hat_inverse, (DMatrix1Row)this.Y_hat_matrix, (DMatrix1Row)this.a_hat_matrix);
        delta_v_me.top.set(-this.a_hat_matrix.get(0, 0), -this.a_hat_matrix.get(1, 0), -this.a_hat_matrix.get(2, 0));
        delta_v_me.bottom.set(-this.a_hat_matrix.get(3, 0), -this.a_hat_matrix.get(4, 0), -this.a_hat_matrix.get(5, 0));
        ((FloatingJoint)this.owner).qd_wx.set(((FloatingJoint)this.owner).qd_wx.getDoubleValue() + delta_v_me.top.getX());
        ((FloatingJoint)this.owner).qd_wy.set(((FloatingJoint)this.owner).qd_wy.getDoubleValue() + delta_v_me.top.getY());
        ((FloatingJoint)this.owner).qd_wz.set(((FloatingJoint)this.owner).qd_wz.getDoubleValue() + delta_v_me.top.getZ());
        this.delta_qd_xyz.set(delta_v_me.bottom);
        this.R0_i.transform((Tuple3DBasics)this.delta_qd_xyz);
        ((FloatingJoint)this.owner).qd_x.set(((FloatingJoint)this.owner).qd_x.getDoubleValue() + this.delta_qd_xyz.getX());
        ((FloatingJoint)this.owner).qd_y.set(((FloatingJoint)this.owner).qd_y.getDoubleValue() + this.delta_qd_xyz.getY());
        ((FloatingJoint)this.owner).qd_z.set(((FloatingJoint)this.owner).qd_z.getDoubleValue() + this.delta_qd_xyz.getZ());
    }

    @Override
    protected boolean jointDependentVerifyReasonableAccelerations() {
        if (Math.abs(((FloatingJoint)this.owner).qdd_x.getDoubleValue()) > 1.0E12) {
            return false;
        }
        if (Math.abs(((FloatingJoint)this.owner).qdd_y.getDoubleValue()) > 1.0E12) {
            return false;
        }
        if (Math.abs(((FloatingJoint)this.owner).qdd_z.getDoubleValue()) > 1.0E12) {
            return false;
        }
        if (Math.abs(((FloatingJoint)this.owner).qdd_wx.getDoubleValue()) > 1.0E7) {
            return false;
        }
        if (Math.abs(((FloatingJoint)this.owner).qdd_wy.getDoubleValue()) > 1.0E7) {
            return false;
        }
        return !(Math.abs(((FloatingJoint)this.owner).qdd_wz.getDoubleValue()) > 1.0E7);
    }
}

