/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportSimulationTo3DMaxDialogConstructor;

public class ExportSimulationTo3DMaxDialogGenerator
implements ExportSimulationTo3DMaxDialogConstructor {
    private SimulationConstructionSet sim;
    private JFileChooser fileChooser = new JFileChooser();
    private ArrayList<String> partNamesThatExist = new ArrayList();
    private ArrayList<Object[]> angleOffsets = new ArrayList();
    private ArrayList<Object[]> posOffsets = new ArrayList();
    private int index = 0;
    private boolean rightAnklePitchSet = false;
    private boolean rightAnkleRollSet = false;
    private boolean leftAnklePitchSet = false;
    private boolean leftAnkleRollSet = false;
    private Vector3D rightAnklePitchTran = new Vector3D();
    private Vector3D rightAnkleRollTran = new Vector3D();
    private Vector3D leftAnklePitchTran = new Vector3D();
    private Vector3D leftAnkleRollTran = new Vector3D();
    private float[] rightAnklePitchAngle = new float[3];
    private float[] rightAnkleRollAngle = new float[3];
    private float[] leftAnklePitchAngle = new float[3];
    private float[] leftAnkleRollAngle = new float[3];

    public ExportSimulationTo3DMaxDialogGenerator(SimulationConstructionSet sim) {
        this.sim = sim;
    }

    @Override
    public void constructDialog() {
        File home = new File(System.getProperty("user.home") + File.separator + "Documents" + File.separator);
        File[] files = home.listFiles();
        int highestIndex = 0;
        File file = null;
        if (files != null) {
            for (int fileindex = 0; fileindex < files.length; ++fileindex) {
                if (!files[fileindex].getName().startsWith("TestSCSScript")) continue;
                highestIndex = Math.max(Integer.parseInt(files[fileindex].getName().substring(13, 15)), highestIndex);
            }
            file = new File(System.getProperty("user.home") + File.separator + "Documents" + File.separator + "TestSCSScript" + ++highestIndex + ".ms");
        } else if (this.fileChooser.showSaveDialog(null) == 0) {
            file = this.fileChooser.getSelectedFile();
        }
        if (file != null) {
            this.addExistingParts();
            this.addAngleOffsets();
            this.addPosOffsets();
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(file);
                fileWriter.write("");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                fileWriter.write(this.initialScript());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            boolean done = false;
            this.sim.setTick(0);
            this.index = 0;
            while (!done) {
                try {
                    if (this.index == this.sim.getCurrentIndex() / 30) {
                        fileWriter.append("\tat time " + this.index + "\n\t(\n");
                    } else {
                        fileWriter.append("\tat time " + this.index + " -- transition --------------------------------------------------------------------------------------\n\t(\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (Robot robot : this.sim.getRobots()) {
                    for (Joint joint : robot.getRootJoints()) {
                        try {
                            Vector3D translation = new Vector3D();
                            joint.getTranslationToWorld((Tuple3DBasics)translation);
                            fileWriter.append(this.getJointPositionsAndTranslations(joint, this.index != this.sim.getCurrentIndex() / 30));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    fileWriter.append("\t)\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.index == this.sim.getCurrentIndex() / 30) {
                    done = this.sim.tick();
                }
                if (done) continue;
                ++this.index;
            }
            try {
                fileWriter.append(this.endScript());
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.sim.closeAndDispose();
        System.exit(0);
    }

    private String getJointPositionsAndTranslations(Joint joint, boolean transition) {
        Object ret = "";
        if (this.doesPartExist(joint.getName())) {
            float xAngle = 0.0f;
            float yAngle = 0.0f;
            float zAngle = 0.0f;
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            if (!transition) {
                rawAngle = joint.get3DRotation();
                xAngle = (float)Math.toDegrees(rawAngle[0]);
                yAngle = (float)Math.toDegrees(rawAngle[1]);
                zAngle = (float)Math.toDegrees(rawAngle[2]);
                Vector3D translation = new Vector3D();
                joint.getTranslationToWorld((Tuple3DBasics)translation);
                x = (float)translation.getX();
                y = (float)translation.getY();
                z = (float)translation.getZ();
            } else {
                this.sim.unTick();
                rawAngle = joint.get3DRotation();
                double xAngle1 = Math.toDegrees(rawAngle[0]);
                double yAngle1 = Math.toDegrees(rawAngle[1]);
                double zAngle1 = Math.toDegrees(rawAngle[2]);
                Vector3D translation = new Vector3D();
                joint.getTranslationToWorld((Tuple3DBasics)translation);
                double x1 = translation.getX();
                double y1 = translation.getY();
                double z1 = translation.getZ();
                this.sim.tick();
                rawAngle = joint.get3DRotation();
                double xAngle2 = Math.toDegrees(rawAngle[0]);
                double yAngle2 = Math.toDegrees(rawAngle[1]);
                double zAngle2 = Math.toDegrees(rawAngle[2]);
                joint.getTranslationToWorld((Tuple3DBasics)translation);
                double x2 = translation.getX();
                double y2 = translation.getY();
                double z2 = translation.getZ();
                xAngle = (float)((xAngle1 + xAngle2) / 2.0);
                yAngle = (float)((yAngle1 + yAngle2) / 2.0);
                zAngle = (float)((zAngle1 + zAngle2) / 2.0);
                x = (float)((x1 + x2) / 2.0);
                y = (float)((y1 + y2) / 2.0);
                z = (float)((z1 + z2) / 2.0);
            }
            ret = "\t\t" + joint.getName() + ".pos = [" + this.convertDoubletoMaxScriptDoubleString(x) + "," + this.convertDoubletoMaxScriptDoubleString(y) + "," + this.convertDoubletoMaxScriptDoubleString(z) + "]\n";
            float[] angleOffset = this.getFloatAngleOffset(joint.getName());
            ret = (String)ret + "\t\tSetObjectRotation " + joint.getName() + " " + this.convertDoubletoMaxScriptDoubleString(xAngle) + " " + this.convertDoubletoMaxScriptDoubleString(yAngle) + " " + this.convertDoubletoMaxScriptDoubleString(zAngle) + " " + this.convertDoubletoMaxScriptDoubleString(angleOffset[0]) + " " + this.convertDoubletoMaxScriptDoubleString(angleOffset[1]) + " " + this.convertDoubletoMaxScriptDoubleString(angleOffset[2]) + "\n";
        } else if (joint.getName().equals("rightAnklePitch")) {
            this.rightAnklePitchSet = true;
            joint.getTranslationToWorld((Tuple3DBasics)this.rightAnklePitchTran);
            double[] temprightAnklePitchAngle = joint.get3DRotation();
            for (int i = 0; i < temprightAnklePitchAngle.length; ++i) {
                this.rightAnklePitchAngle[i] = (float)temprightAnklePitchAngle[i];
            }
            if (this.rightAnkleRollSet) {
                ret = this.setRightFoot();
            }
        } else if (joint.getName().equals("rightAnkleRoll")) {
            this.rightAnkleRollSet = true;
            joint.getTranslationToWorld((Tuple3DBasics)this.rightAnkleRollTran);
            double[] temprightAnklePitchAngle = joint.get3DRotation();
            for (int i = 0; i < temprightAnklePitchAngle.length; ++i) {
                this.rightAnkleRollAngle[i] = (float)temprightAnklePitchAngle[i];
            }
            if (this.rightAnklePitchSet) {
                ret = this.setRightFoot();
            }
        } else if (joint.getName().equals("leftAnklePitch")) {
            this.leftAnklePitchSet = true;
            joint.getTranslationToWorld((Tuple3DBasics)this.leftAnklePitchTran);
            double[] temprightAnklePitchAngle = joint.get3DRotation();
            for (int i = 0; i < temprightAnklePitchAngle.length; ++i) {
                this.leftAnklePitchAngle[i] = (float)temprightAnklePitchAngle[i];
            }
            if (this.leftAnkleRollSet) {
                ret = this.setLeftFoot();
            }
        } else if (joint.getName().equals("leftAnkleRoll")) {
            this.leftAnkleRollSet = true;
            joint.getTranslationToWorld((Tuple3DBasics)this.leftAnkleRollTran);
            double[] temprightAnklePitchAngle = joint.get3DRotation();
            for (int i = 0; i < temprightAnklePitchAngle.length; ++i) {
                this.leftAnkleRollAngle[i] = (float)temprightAnklePitchAngle[i];
            }
            if (this.leftAnklePitchSet) {
                ret = this.setLeftFoot();
            }
        }
        for (Joint childJoint : joint.getChildrenJoints()) {
            ret = (String)ret + this.getJointPositionsAndTranslations(childJoint, transition);
        }
        return ret;
    }

    private String setRightFoot() {
        String ret = "\t\trightFoot.pos = [" + this.convertDoubletoMaxScriptDoubleString((float)this.rightAnklePitchTran.getX()) + "," + this.convertDoubletoMaxScriptDoubleString((float)this.rightAnklePitchTran.getY()) + "," + this.convertDoubletoMaxScriptDoubleString((float)this.rightAnklePitchTran.getZ()) + "]\n\t\tSetObjectRotation rightFoot " + this.convertDoubletoMaxScriptDoubleString(this.rightAnklePitchAngle[1]) + " " + this.convertDoubletoMaxScriptDoubleString(this.rightAnkleRollAngle[0]) + " 0 0 0 180\n";
        this.rightAnklePitchSet = false;
        this.rightAnkleRollSet = false;
        return ret;
    }

    private String setLeftFoot() {
        String ret = "\t\tleftFoot.pos = [" + this.convertDoubletoMaxScriptDoubleString((float)this.leftAnklePitchTran.getX()) + "," + this.convertDoubletoMaxScriptDoubleString((float)this.leftAnklePitchTran.getY()) + "," + this.convertDoubletoMaxScriptDoubleString((float)this.leftAnklePitchTran.getZ()) + "]\n\t\tSetObjectRotation leftFoot " + this.convertDoubletoMaxScriptDoubleString(this.leftAnklePitchAngle[1]) + " " + this.convertDoubletoMaxScriptDoubleString(this.leftAnkleRollAngle[0]) + " 0 0 0 180\n";
        this.leftAnklePitchSet = false;
        this.leftAnkleRollSet = false;
        return ret;
    }

    private String initialScript() {
        String code = "resetMaxFile #noprompt\nloaded = loadMaxFile \"C:\\Users\\Madison\\Documents\\R2Robot_Madison_v09.max\" useFileUnits:true\nchest = $chest\nleftShoulderPitch = $leftShoulderPitch\nleftShoulderRoll = $leftShoulderRoll\nleftShoulderYaw = $leftShoulderYaw\nleftElbow = $leftElbow\nrightShoulderPitch = $rightShoulderPitch\nrightShoulderRoll = $rightShoulderRoll\nrightShoulderYaw = $rightShoulderYaw\nrightElbow = $rightElbow\nlowerNeckPitch = $lowerNeckPitch\nneckYaw = $neckYaw\nupperNeckPitch = $head\nspinePitch = $spinePitch\nspineYaw = $spineYaw\nspineRoll = $spineRoll\nleftHipPitch = $leftHipPitch\nleftHipRoll = $leftHipRoll\nleftHipYaw = $leftHipYaw\nleftKnee = $leftKnee\nrightHipPitch = $rightHipPitch\nrightHipRoll = $rightHipRoll\nrightHipYaw = $rightHipYaw\nrightKnee = $rightKnee\nrightFoot = $rightFoot\nleftFoot = $leftFoot\n\nfn RotatePivotOnly obj rotation =\n(\n\tlocal rotValInv=inverse (rotation as quat)\n\tin coordsys local obj.rotation*=RotValInv\n)\n\nfn SetObjectRotation obj rx ry rz ox oy oz =\n(\n\tlocal translateMat = transMatrix obj.transform.pos\n\tlocal scaleMat = scaleMatrix obj.transform.scale\n\tobj.transform = scaleMat * translateMat\n\trot = eulerangles rx ry rz\n\tRotatePivotOnly obj rot\n\trot = eulerangles ox oy oz\n\tRotatePivotOnly obj rot\n)\n\nanimate on\n(\n";
        return code;
    }

    private void addExistingParts() {
        this.partNamesThatExist.add("leftHipPitch");
        this.partNamesThatExist.add("leftHipRoll");
        this.partNamesThatExist.add("leftHipYaw");
        this.partNamesThatExist.add("leftKnee");
        this.partNamesThatExist.add("rightHipPitch");
        this.partNamesThatExist.add("rightHipRoll");
        this.partNamesThatExist.add("rightHipYaw");
        this.partNamesThatExist.add("rightKnee");
        this.partNamesThatExist.add("spineRoll");
        this.partNamesThatExist.add("spineYaw");
        this.partNamesThatExist.add("spinePitch");
        this.partNamesThatExist.add("lowerNeckPitch");
        this.partNamesThatExist.add("neckYaw");
        this.partNamesThatExist.add("upperNeckPitch");
        this.partNamesThatExist.add("chest");
        this.partNamesThatExist.add("leftShoulderPitch");
        this.partNamesThatExist.add("leftShoulderRoll");
        this.partNamesThatExist.add("leftShoulderYaw");
        this.partNamesThatExist.add("leftElbow");
        this.partNamesThatExist.add("rightShoulderPitch");
        this.partNamesThatExist.add("rightShoulderRoll");
        this.partNamesThatExist.add("rightShoulderYaw");
        this.partNamesThatExist.add("rightElbow");
    }

    private void addAngleOffsets() {
        this.angleOffsets.add(new Object[]{"leftHipPitch", 180.0, 180.0, 0.0});
        this.angleOffsets.add(new Object[]{"leftHipRoll", 90.0, 90.0, 0.0});
        this.angleOffsets.add(new Object[]{"leftKnee", -90.0, 0.0, 90.0});
        this.angleOffsets.add(new Object[]{"rightKnee", -90.0, 0.0, 90.0});
        this.angleOffsets.add(new Object[]{"spineRoll", 90.0, 0.0, 90.0});
        this.angleOffsets.add(new Object[]{"leftShoulderYaw", 0.0, 180.0, 0.0});
    }

    private void addPosOffsets() {
        this.posOffsets.add(new Object[]{"spineRoll", 0.0, 0.0, -0.1016});
        this.posOffsets.add(new Object[]{"spineYaw", 0.0254, 0.0, 0.0254});
        this.posOffsets.add(new Object[]{"spinePitch", 0.0254, 0.0, 0.03});
    }

    private float[] getFloatAngleOffset(String partName) {
        float[] angleOffset = new float[]{0.0f, 0.0f, 0.0f};
        for (int i = 0; i < this.angleOffsets.size(); ++i) {
            if (!partName.equals(this.angleOffsets.get(i)[0])) continue;
            angleOffset[0] = (float)((Double)this.angleOffsets.get(i)[1]).doubleValue();
            angleOffset[1] = (float)((Double)this.angleOffsets.get(i)[2]).doubleValue();
            angleOffset[2] = (float)((Double)this.angleOffsets.get(i)[3]).doubleValue();
            break;
        }
        return angleOffset;
    }

    private String endScript() {
        return ")\nanimationrange = interval 0 " + this.index;
    }

    private boolean doesPartExist(String partName) {
        boolean exists = false;
        for (String name : this.partNamesThatExist) {
            if (!partName.equals(name)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    private String convertDoubletoMaxScriptDoubleString(float value) {
        return this.replaceAll(Double.toString(value), "E", "e");
    }

    private String replaceAll(String orig, String regex, String rep) {
        int index = 0;
        while (index + regex.length() < orig.length()) {
            if (orig.substring(index, index + regex.length()).equals(regex)) {
                orig = this.replace(orig, index, index + regex.length(), rep);
                index += rep.length() - 1;
            }
            ++index;
        }
        return orig;
    }

    private String replace(String fullString, int beginIndex, int endIndex, String replacement) {
        if (beginIndex >= 0 && beginIndex < fullString.length() && endIndex >= 0 && endIndex < fullString.length()) {
            String prefix = fullString.substring(0, beginIndex);
            String suffix = fullString.substring(endIndex);
            return prefix + replacement + suffix;
        }
        return null;
    }

    public void closeAndDispose() {
        this.sim = null;
        this.fileChooser = null;
    }
}

