/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.scripts;

import java.util.ArrayList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class ConditionalScriptEntry {
    private final String name;
    public static int eventNumber = 0;
    public static final int DISARMED = 0;
    public static final int ARMED = 1;
    public static final int ACTIVE = 2;
    public static final int FINISHED = 3;
    protected YoDouble event_state;
    private ArrayList<ConditionalScriptEntry> parentEntries;
    private ArrayList<ConditionalScriptEntry> childEntries;

    public abstract boolean startCondition();

    public abstract void activate();

    public abstract void doActivity();

    public abstract void deactivate();

    public abstract boolean finishCondition();

    public ConditionalScriptEntry(String name, YoRegistry registry, ConditionalScriptEntry[] parents) {
        if (name == null) {
            name = "event";
        }
        this.name = name;
        this.event_state = new YoDouble(name + "_" + eventNumber + "_state", registry);
        this.event_state.set(1.0);
        ++eventNumber;
        if (parents != null) {
            for (int i = 0; i < parents.length; ++i) {
                this.addParentCondition(parents[i]);
            }
        }
    }

    public ConditionalScriptEntry(YoRegistry registry) {
        this("event", registry, (ConditionalScriptEntry[])null);
    }

    public ConditionalScriptEntry(String name, YoRegistry registry) {
        this(name, registry, (ConditionalScriptEntry[])null);
    }

    public ConditionalScriptEntry(String name, YoRegistry registry, ConditionalScriptEntry parent) {
        this(name, registry, new ConditionalScriptEntry[]{parent});
    }

    public ConditionalScriptEntry(YoRegistry registry, ConditionalScriptEntry[] parents) {
        this("event", registry, parents);
    }

    public void addParentCondition(ConditionalScriptEntry parentEntry) {
        if (parentEntry == null) {
            return;
        }
        this.event_state.set(0.0);
        if (this.parentEntries == null) {
            this.parentEntries = new ArrayList();
        }
        this.parentEntries.add(parentEntry);
        if (parentEntry.childEntries == null) {
            parentEntry.childEntries = new ArrayList();
        }
        parentEntry.childEntries.add(this);
    }

    protected void removeParentsAndChildren() {
        int i;
        for (i = 0; i < this.parentEntries.size(); ++i) {
            ConditionalScriptEntry parentEntry = this.parentEntries.get(i);
            parentEntry.removeChild(this);
        }
        for (i = 0; i < this.childEntries.size(); ++i) {
            ConditionalScriptEntry childEntry = this.childEntries.get(i);
            childEntry.removeParent(this);
        }
    }

    protected void considerArmingChildren() {
        if (this.childEntries == null) {
            return;
        }
        for (int i = 0; i < this.childEntries.size(); ++i) {
            ConditionalScriptEntry childEntry = this.childEntries.get(i);
            if (!childEntry.areAllParentsFinished()) continue;
            if (!childEntry.isDisarmed()) {
                System.err.println("Inconsistent state with ConditionalScriptEntry!");
            }
            childEntry.event_state.set(1.0);
        }
    }

    public boolean areAllParentsFinished() {
        if (this.parentEntries == null) {
            return true;
        }
        for (int i = 0; i < this.parentEntries.size(); ++i) {
            ConditionalScriptEntry parentEntry = this.parentEntries.get(i);
            if (parentEntry.isFinished()) continue;
            return false;
        }
        return true;
    }

    protected void removeChild(ConditionalScriptEntry childEntry) {
        this.childEntries.remove(childEntry);
        childEntry.parentEntries.remove(this);
        if (childEntry.parentEntries.isEmpty() && childEntry.isDisarmed()) {
            childEntry.event_state.set(1.0);
        }
    }

    protected void removeParent(ConditionalScriptEntry parentEntry) {
        this.parentEntries.remove(parentEntry);
        parentEntry.childEntries.remove(this);
        if (this.parentEntries.isEmpty() && this.isDisarmed()) {
            this.event_state.set(1.0);
        }
    }

    public boolean isDisarmed() {
        return this.event_state.getDoubleValue() == 0.0;
    }

    public boolean isArmed() {
        return this.event_state.getDoubleValue() == 1.0;
    }

    public boolean isActive() {
        return this.event_state.getDoubleValue() == 2.0;
    }

    public boolean isFinished() {
        return this.event_state.getDoubleValue() == 3.0;
    }

    public void reset() {
        if (this.parentEntries == null || this.parentEntries.isEmpty()) {
            this.event_state.set(1.0);
        } else {
            this.event_state.set(0.0);
        }
    }
}

