/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.robotdefinition;

import java.util.ArrayList;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.robotics.robotDescription.Plane;
import us.ihmc.simulationconstructionset.robotdefinition.ExternalForcePointDefinitionFixedFrame;
import us.ihmc.simulationconstructionset.robotdefinition.GroundContactDefinitionFixedFrame;
import us.ihmc.simulationconstructionset.robotdefinition.LinkDefinitionFixedFrame;

public class JointDefinitionFixedFrame
implements Comparable<JointDefinitionFixedFrame> {
    private String jointName;
    private JointDefinitionFixedFrame parentJoint = null;
    private String parentName = null;
    private JointType type;
    private boolean rootJoint = false;
    private LinkDefinitionFixedFrame link;
    private Vector3D offset;
    private Vector3D jointAxis;
    private ArrayList<JointDefinitionFixedFrame> childrenJoints = new ArrayList();
    private Plane planarType = Plane.YZ;
    private ArrayList<GroundContactDefinitionFixedFrame> groundContactDefinitionsFixedFrame = new ArrayList();
    private ArrayList<ExternalForcePointDefinitionFixedFrame> externalForcePointDefinitionsFixedFrame = new ArrayList();

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Plane getPlanarType() {
        return this.planarType;
    }

    public void setRootJoint(boolean rootJoint) {
        this.rootJoint = rootJoint;
    }

    public boolean isRootJoint() {
        return this.rootJoint;
    }

    public ArrayList<GroundContactDefinitionFixedFrame> getGroundContactDefinitionsFixedFrame() {
        return this.groundContactDefinitionsFixedFrame;
    }

    public void addGroundContactDefinitionFixedFrame(GroundContactDefinitionFixedFrame groundContactDefinitionFixedFrame) {
        this.groundContactDefinitionsFixedFrame.add(groundContactDefinitionFixedFrame);
    }

    public ArrayList<ExternalForcePointDefinitionFixedFrame> getExternalForcePointDefinitionsFixedFrame() {
        return this.externalForcePointDefinitionsFixedFrame;
    }

    public void addExternalForcePointDefinition(ExternalForcePointDefinitionFixedFrame externalForcePointDefinitionFixedFrame) {
        this.externalForcePointDefinitionsFixedFrame.add(externalForcePointDefinitionFixedFrame);
    }

    public void setPlanarType(Plane type) {
        this.planarType = type;
    }

    public int getNumberOfChildJoints() {
        int numberOfJoints = this.childrenJoints.size();
        for (JointDefinitionFixedFrame joint : this.childrenJoints) {
            numberOfJoints += joint.getNumberOfChildJoints();
        }
        return numberOfJoints;
    }

    public String getJointName() {
        return this.jointName;
    }

    public void setJointName(String jointName) {
        this.jointName = jointName;
    }

    public JointDefinitionFixedFrame getParentJoint() {
        return this.parentJoint;
    }

    public void setParentJoint(JointDefinitionFixedFrame parentJoint) {
        this.parentJoint = parentJoint;
    }

    public JointType getType() {
        return this.type;
    }

    public void setType(JointType type) {
        this.type = type;
    }

    public LinkDefinitionFixedFrame getLinkDefinition() {
        return this.link;
    }

    public void setLinkDefinition(LinkDefinitionFixedFrame link) {
        this.link = link;
    }

    public Vector3D getOffset() {
        return this.offset;
    }

    public void setOffset(Vector3D offset) {
        this.offset = offset;
    }

    public Vector3D getJointAxis() {
        return this.jointAxis;
    }

    public void setJointAxis(Vector3D jointAxis) {
        this.jointAxis = jointAxis;
    }

    public ArrayList<JointDefinitionFixedFrame> getChildrenJoints() {
        return this.childrenJoints;
    }

    public void addChildJoint(JointDefinitionFixedFrame jointDef) {
        this.childrenJoints.add(jointDef);
    }

    public String toString() {
        Object returnString = "";
        returnString = (String)returnString + "<Joint>\n";
        returnString = (String)returnString + "\t<Name>" + this.jointName + "</Name>\n";
        returnString = (String)returnString + "\t<Parent>";
        returnString = this.parentJoint != null ? (String)returnString + this.parentJoint.getJointName() : (String)returnString + "null";
        returnString = (String)returnString + "</Parent>\n";
        returnString = (String)returnString + "\t<RootJoint>" + this.rootJoint + "</RootJoint>\n";
        returnString = (String)returnString + "\t<Offset>" + this.offset + "</Offset>\n";
        returnString = (String)returnString + "\t<Axis>" + this.jointAxis + "</Axis>\n";
        returnString = (String)returnString + "\t<Type>" + this.type + "</Type>\n";
        if (this.type != JointType.PIN_JOINT && this.type != JointType.SLIDER_JOINT && this.type != JointType.FLOATING_JOINT && this.type != JointType.FLOATING_PLANAR_JOINT) {
            throw new RuntimeException("Only Pin, Slider, Floating, and Floating Planar joints implemented right now");
        }
        returnString = (String)returnString + this.getGroundContactPointsString();
        returnString = (String)returnString + this.getExternalForcePointsString();
        returnString = (String)returnString + this.getLinkDefinition();
        returnString = (String)returnString + "</Joint>\n";
        return returnString;
    }

    private String getGroundContactPointsString() {
        Object returnString = "<GroundContactPoints>\n";
        for (GroundContactDefinitionFixedFrame gcDef : this.groundContactDefinitionsFixedFrame) {
            returnString = (String)returnString + gcDef.getXMLRepresentation();
        }
        returnString = (String)returnString + "</GroundContactPoints>\n";
        return returnString;
    }

    private String getExternalForcePointsString() {
        Object returnString = "<ExternalForcePoints>\n";
        for (ExternalForcePointDefinitionFixedFrame efpDef : this.externalForcePointDefinitionsFixedFrame) {
            returnString = (String)returnString + efpDef.getXMLRepresentation();
        }
        returnString = (String)returnString + "</ExternalForcePoints>\n";
        return returnString;
    }

    @Override
    public int compareTo(JointDefinitionFixedFrame o) {
        return o.getJointName().compareTo(this.getJointName());
    }

    public static enum JointType {
        PIN_JOINT,
        SLIDER_JOINT,
        FLOATING_JOINT,
        FLOATING_PLANAR_JOINT;

    }
}

