/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision.simple;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.simulationconstructionset.physics.CollisionShape;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;

public class SimpleCollisionShape
implements CollisionShape {
    private final CollisionShapeDescription collisionShapeDescription;
    private final CollisionShapeDescription transformedCollisionShapeDescription;
    private final RigidBodyTransform transformToWorld = new RigidBodyTransform();
    private int groupMask = 0;
    private int collisionMask = 0;
    private boolean isGround = false;

    public SimpleCollisionShape(CollisionShapeDescription collisionShapeDescription) {
        this.collisionShapeDescription = collisionShapeDescription;
        this.transformedCollisionShapeDescription = collisionShapeDescription.copy();
    }

    @Override
    public boolean isGround() {
        return this.isGround;
    }

    @Override
    public void setIsGround(boolean isGround) {
        this.isGround = isGround;
    }

    public CollisionShapeDescription getCollisionShapeDescription() {
        return this.collisionShapeDescription;
    }

    public int getCollisionGroup() {
        return this.groupMask;
    }

    public int getCollisionMask() {
        return this.collisionMask;
    }

    public void setCollisionGroup(int groupMask) {
        this.groupMask = groupMask;
    }

    public void setCollisionMask(int collisionMask) {
        this.collisionMask = collisionMask;
    }

    @Override
    public void getTransformToWorld(RigidBodyTransform transformToWorldToPack) {
        transformToWorldToPack.set(this.transformToWorld);
    }

    @Override
    public void setTransformToWorld(RigidBodyTransform transformToWorld) {
        this.transformToWorld.set(transformToWorld);
    }

    public CollisionShapeDescription getTransformedCollisionShapeDescription() {
        return this.transformedCollisionShapeDescription;
    }

    @Override
    public void computeTransformedCollisionShape() {
        this.transformedCollisionShapeDescription.setFrom(this.collisionShapeDescription);
        this.getTransformToWorld(this.transformToWorld);
        this.transformedCollisionShapeDescription.applyTransform(this.transformToWorld);
    }

    @Override
    public void getBoundingBox(BoundingBox3D boundingBoxToPack) {
        this.transformedCollisionShapeDescription.getBoundingBox(boundingBoxToPack);
    }
}

