/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class HorizontalSpinnerUI
extends BasicSpinnerUI {
    private Component westButton;
    private Component eastButton;
    protected static final Dimension zeroSize = new Dimension(0, 0);
    static final String BASIC_SPINNERUI_LISTENER_NAME = "javax.swing.plaf.basic.BasicSpinnerUI$ArrowButtonHandler";

    @Override
    public void installUI(JComponent component) {
        this.spinner = (JSpinner)component;
        this.installDefaults();
        this.installListeners();
        this.westButton = this.createTheArrowButton(7, "West");
        this.spinner.add(this.westButton);
        this.spinner.add((Component)this.createEditor(), "Editor");
        this.eastButton = this.createTheArrowButton(3, "East");
        this.spinner.add(this.eastButton);
        this.installKeyboardActions();
        this.initButtonListeners();
    }

    private Component createTheArrowButton(int direction, String name) {
        BasicArrowButton button = new BasicArrowButton(direction);
        button.setName(name);
        Border buttonBorder = UIManager.getBorder("Spinner.arrowButtonBorder");
        if (buttonBorder instanceof DefaultListCellRenderer.UIResource) {
            button.setBorder(new CompoundBorder(buttonBorder, null));
        } else {
            button.setBorder(buttonBorder);
        }
        button.setInheritsPopupMenu(true);
        return button;
    }

    @Override
    protected LayoutManager createLayout() {
        HandlerLayoutManager handlerLayout = new HandlerLayoutManager();
        return handlerLayout;
    }

    public void initButtonListeners() {
        ComponentOrientation orient = this.spinner.getComponentOrientation();
        if (orient.equals(ComponentOrientation.UNKNOWN) || orient.equals(ComponentOrientation.LEFT_TO_RIGHT)) {
            this.installPreviousButtonListeners(this.westButton);
            this.installNextButtonListeners(this.eastButton);
        } else if (orient.equals(ComponentOrientation.RIGHT_TO_LEFT)) {
            this.installPreviousButtonListeners(this.eastButton);
            this.installNextButtonListeners(this.westButton);
        }
    }

    protected boolean isBasicSpinnerUIListener(Object listener) {
        boolean handler = false;
        Class<BasicSpinnerUI> basicSpinnerClass = BasicSpinnerUI.class;
        if (listener != null) {
            try {
                if (listener.getClass().getEnclosingClass().equals(basicSpinnerClass) && listener.getClass().getDeclaringClass().equals(basicSpinnerClass) && listener.getClass().isMemberClass() && listener.getClass().getName().equals(BASIC_SPINNERUI_LISTENER_NAME)) {
                    handler = true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return handler;
    }

    @Override
    protected void installPreviousButtonListeners(Component c) {
        this.uninstallArrowButtonListeners(c);
        c.setName("Spinner.previousButton");
        super.installPreviousButtonListeners(c);
        if (c instanceof JButton) {
            ActionListener[] actionListeners = ((JButton)c).getActionListeners();
            for (int a = 0; a < actionListeners.length; ++a) {
                if (!this.isBasicSpinnerUIListener(actionListeners[a])) continue;
                this.spinner.getActionMap().put("decrement", (AbstractAction)actionListeners[a]);
            }
        }
    }

    @Override
    protected void installNextButtonListeners(Component c) {
        this.uninstallArrowButtonListeners(c);
        c.setName("Spinner.nextButton");
        super.installNextButtonListeners(c);
        if (c instanceof JButton) {
            ActionListener[] actionListeners = ((JButton)c).getActionListeners();
            for (int a = 0; a < actionListeners.length; ++a) {
                if (!this.isBasicSpinnerUIListener(actionListeners[a])) continue;
                this.spinner.getActionMap().put("increment", (AbstractAction)actionListeners[a]);
            }
        }
    }

    protected void uninstallArrowButtonListeners(Component component) {
        if (component != null) {
            MouseListener[] mouseListeners = component.getMouseListeners();
            for (int m = 0; m < mouseListeners.length; ++m) {
                if (!this.isBasicSpinnerUIListener(mouseListeners[m])) continue;
                component.removeMouseListener(mouseListeners[m]);
            }
            if (component instanceof JButton) {
                ActionListener[] actionListeners = ((JButton)component).getActionListeners();
                for (int a = 0; a < actionListeners.length; ++a) {
                    if (!this.isBasicSpinnerUIListener(actionListeners[a])) continue;
                    ((JButton)component).removeActionListener(actionListeners[a]);
                }
            }
        }
    }

    class HandlerLayoutManager
    implements LayoutManager {
        private Component editor = null;

        HandlerLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
            if ("East".equals(name)) {
                HorizontalSpinnerUI.this.eastButton = c;
            } else if ("West".equals(name)) {
                HorizontalSpinnerUI.this.westButton = c;
            } else if ("Editor".equals(name)) {
                this.editor = c;
            }
        }

        @Override
        public void removeLayoutComponent(Component c) {
            if (c == HorizontalSpinnerUI.this.eastButton) {
                HorizontalSpinnerUI.this.eastButton = null;
            } else if (c == HorizontalSpinnerUI.this.westButton) {
                HorizontalSpinnerUI.this.westButton = null;
            } else if (c == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? zeroSize : c.getPreferredSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = this.preferredSize(HorizontalSpinnerUI.this.eastButton);
            Dimension previousD = this.preferredSize(HorizontalSpinnerUI.this.westButton);
            Dimension editorD = this.preferredSize(this.editor);
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += 2 * Math.max(nextD.width, previousD.width);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private void setBounds(Component c, int x, int y, int width, int height) {
            if (c != null) {
                c.setBounds(x, y, width, height);
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = parent.getInsets();
            Dimension nextD = this.preferredSize(HorizontalSpinnerUI.this.eastButton);
            Dimension previousD = this.preferredSize(HorizontalSpinnerUI.this.westButton);
            int buttonWidth = Math.max(nextD.width, previousD.width);
            int editorHeight = height - (insets.top + insets.bottom);
            Insets buttonInsets = UIManager.getInsets("Spinner.arrowButtonInsets");
            if (buttonInsets == null) {
                buttonInsets = insets;
            }
            if (parent.getComponentOrientation().isLeftToRight()) {
                int editorWidth = width - insets.left - 2 * buttonWidth - buttonInsets.right;
                this.setBounds(HorizontalSpinnerUI.this.westButton, insets.left, insets.top, buttonWidth, editorHeight);
                this.setBounds(this.editor, insets.left + buttonWidth, insets.top, editorWidth, editorHeight);
                this.setBounds(HorizontalSpinnerUI.this.eastButton, insets.left + buttonWidth + editorWidth, insets.top, buttonWidth, editorHeight);
            } else if (!parent.getComponentOrientation().isLeftToRight()) {
                int editorWidth = width - insets.right - 2 * buttonWidth - buttonInsets.left;
                this.setBounds(HorizontalSpinnerUI.this.westButton, width - buttonWidth - editorWidth - buttonWidth, insets.top, buttonWidth, editorHeight);
                this.setBounds(this.editor, width - buttonWidth - editorWidth, insets.top, editorWidth, editorHeight);
                this.setBounds(HorizontalSpinnerUI.this.eastButton, width - buttonWidth, insets.top, buttonWidth, editorHeight);
            }
        }
    }
}

