/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.gui.EntryBoxArrayPanel;
import us.ihmc.yoVariables.variable.YoVariable;

public class EntryBoxArrayTabbedPanel
extends JTabbedPane {
    private static final long serialVersionUID = 5184442227844655562L;
    private ArrayList<EntryBoxArrayPanel> entryBoxArrayPanels = new ArrayList();
    private final Container parentContainer;
    private final SelectedVariableHolder selectedVariableHolder;

    public EntryBoxArrayTabbedPanel(Container parentContainer, SelectedVariableHolder selectedVariableHolder) {
        this.parentContainer = parentContainer;
        this.selectedVariableHolder = selectedVariableHolder;
        TabTitleEditListener nameChanger = new TabTitleEditListener(this);
        this.addChangeListener(nameChanger);
        this.addMouseListener(nameChanger);
    }

    public void addEntryBoxArrayPanel(String name, EntryBoxArrayPanel panelToAdd) {
        this.add(name, panelToAdd);
        this.entryBoxArrayPanels.add(panelToAdd);
        this.setSelectedComponent(panelToAdd);
    }

    public EntryBoxArrayPanel getCurrentPanel() {
        return this.getCurrentPanel(false);
    }

    public EntryBoxArrayPanel getCurrentPanel(boolean createNewTabWhenNecessary) {
        if (this.getSelectedComponent() == null && createNewTabWhenNecessary) {
            this.addEmptyTab();
        }
        return (EntryBoxArrayPanel)this.getSelectedComponent();
    }

    public void closeAndDispose() {
        this.removeAll();
        for (EntryBoxArrayPanel panel : this.entryBoxArrayPanels) {
            panel.closeAndDispose();
        }
    }

    public String getXMLRepresentationOfClass() {
        Object returnString = "<Entry Boxes Tab Pane>";
        for (int i = 0; i < this.getTabCount(); ++i) {
            returnString = (String)returnString + "\n<EntryBoxTab>";
            returnString = (String)returnString + "\n<Title>\n" + this.getTitleAt(i) + "\n</Title>\n";
            returnString = (String)returnString + ((EntryBoxArrayPanel)this.getComponentAt(i)).getXMLRepresentationOfClass();
            returnString = (String)returnString + "\n</EntryBoxTab>";
        }
        returnString = (String)returnString + "\n</Entry Boxes Tab Pane>";
        return returnString;
    }

    public void addEntryBox(YoVariable selectedVariable) {
        if (this.getCurrentPanel() == null) {
            this.addEmptyTab();
        }
        this.getCurrentPanel().addEntryBox(selectedVariable);
    }

    public void addEmptyTab() {
        EntryBoxArrayPanel tmpEntryBoxArrayPanel = new EntryBoxArrayPanel(this.parentContainer, this.selectedVariableHolder, null);
        this.addEntryBoxArrayPanel("Tab" + this.getTabCount(), tmpEntryBoxArrayPanel);
    }

    class TabTitleEditListener
    extends MouseAdapter
    implements ChangeListener {
        private final JTextField editor = new JTextField();
        private final JTabbedPane tabbedPane;
        private int editingIdx = -1;
        private int len = -1;
        private Dimension dim;
        private Component tabComponent;

        public TabTitleEditListener(final JTabbedPane tabbedPane) {
            this.tabbedPane = tabbedPane;
            this.editor.setBorder(BorderFactory.createEmptyBorder());
            this.editor.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    TabTitleEditListener.this.renameTabTitle();
                }
            });
            this.editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        TabTitleEditListener.this.renameTabTitle();
                    } else if (e.getKeyCode() == 27) {
                        TabTitleEditListener.this.cancelEditing();
                    } else {
                        TabTitleEditListener.this.editor.setPreferredSize(TabTitleEditListener.this.editor.getText().length() > TabTitleEditListener.this.len ? null : TabTitleEditListener.this.dim);
                        tabbedPane.revalidate();
                    }
                }
            });
            tabbedPane.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "start-editing");
            tabbedPane.getActionMap().put("start-editing", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabTitleEditListener.this.startEditing();
                }
            });
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.renameTabTitle();
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            Rectangle rect = this.tabbedPane.getUI().getTabBounds(this.tabbedPane, this.tabbedPane.getSelectedIndex());
            if (rect != null && rect.contains(me.getPoint()) && me.getClickCount() == 2) {
                this.startEditing();
            } else {
                this.renameTabTitle();
            }
        }

        private void startEditing() {
            this.editingIdx = this.tabbedPane.getSelectedIndex();
            this.tabComponent = this.tabbedPane.getTabComponentAt(this.editingIdx);
            this.tabbedPane.setTabComponentAt(this.editingIdx, this.editor);
            this.editor.setVisible(true);
            this.editor.setText(this.tabbedPane.getTitleAt(this.editingIdx));
            this.editor.selectAll();
            this.editor.requestFocusInWindow();
            this.len = this.editor.getText().length();
            this.dim = this.editor.getPreferredSize();
            this.editor.setMinimumSize(this.dim);
        }

        private void cancelEditing() {
            if (this.editingIdx >= 0) {
                this.tabbedPane.setTabComponentAt(this.editingIdx, this.tabComponent);
                this.editor.setVisible(false);
                this.editingIdx = -1;
                this.len = -1;
                this.tabComponent = null;
                this.editor.setPreferredSize(null);
                this.tabbedPane.requestFocusInWindow();
            }
        }

        private void renameTabTitle() {
            String title = this.editor.getText().trim();
            if (this.editingIdx >= 0 && !title.isEmpty()) {
                this.tabbedPane.setTitleAt(this.editingIdx, title);
            }
            this.cancelEditing();
        }
    }
}

