/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import java.util.ArrayList;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.jMonkeyEngineToolkit.CombinedHeightMapWithNormals;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;

public class CombinedGroundProfile3D
implements GroundProfile3D {
    private GroundProfile3D[] groundProfiles;
    private final BoundingBox3D boundingBox;
    private final CombinedHeightMapWithNormals heightMap;
    private final Point3D tempPointToCheck = new Point3D();

    public CombinedGroundProfile3D(GroundProfile3D[] groundProfiles) {
        this.groundProfiles = groundProfiles;
        this.heightMap = new CombinedHeightMapWithNormals();
        BoundingBox3D boundingBox = null;
        for (GroundProfile3D groundProfile : groundProfiles) {
            boundingBox = boundingBox == null ? groundProfile.getBoundingBox() : BoundingBox3D.union((BoundingBox3DReadOnly)boundingBox, (BoundingBox3DReadOnly)groundProfile.getBoundingBox());
            HeightMapWithNormals heightMapIfAvailable = groundProfile.getHeightMapIfAvailable();
            if (heightMapIfAvailable == null) continue;
            this.heightMap.addHeightMap(heightMapIfAvailable);
        }
        this.boundingBox = boundingBox;
    }

    public CombinedGroundProfile3D(ArrayList<GroundProfile3D> groundProfilesArrayList) {
        this.groundProfiles = new GroundProfile3D[groundProfilesArrayList.size()];
        this.heightMap = new CombinedHeightMapWithNormals();
        BoundingBox3D boundingBox = null;
        for (GroundProfile3D groundProfile : this.groundProfiles) {
            boundingBox = boundingBox == null ? groundProfile.getBoundingBox() : BoundingBox3D.union((BoundingBox3DReadOnly)boundingBox, (BoundingBox3DReadOnly)groundProfile.getBoundingBox());
            HeightMapWithNormals heightMapIfAvailable = groundProfile.getHeightMapIfAvailable();
            if (heightMapIfAvailable == null) continue;
            this.heightMap.addHeightMap(heightMapIfAvailable);
        }
        this.boundingBox = boundingBox;
        groundProfilesArrayList.toArray(this.groundProfiles);
    }

    public GroundProfile3D[] getGroundProfiles() {
        return this.groundProfiles;
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        double smallestDistance = Double.MAX_VALUE;
        Point3D localIntersection = new Point3D();
        Vector3D localNormal = new Vector3D();
        boolean isInside = false;
        this.tempPointToCheck.set(x, y, z);
        intersectionToPack.set(x, y, 0.0);
        normalToPack.set(0.0, 0.0, 1.0);
        for (GroundProfile3D groundProfile : this.groundProfiles) {
            boolean localIsInside;
            if (!groundProfile.isClose(x, y, z) || !(localIsInside = groundProfile.checkIfInside(x, y, z, (Point3DBasics)localIntersection, (Vector3DBasics)localNormal)) || !(this.tempPointToCheck.distance((Point3DReadOnly)localIntersection) < smallestDistance)) continue;
            smallestDistance = this.tempPointToCheck.distance((Point3DReadOnly)localIntersection);
            intersectionToPack.set((Tuple3DReadOnly)localIntersection);
            normalToPack.set((Tuple3DReadOnly)localNormal);
            isInside = true;
        }
        this.tempPointToCheck.set(0.0, 0.0, 0.0);
        return isInside;
    }

    public boolean isClose(double x, double y, double z) {
        if (this.boundingBox == null) {
            return false;
        }
        return this.boundingBox.isInsideInclusive(x, y, z);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this.heightMap;
    }
}

