/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.yoVariableSearch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.gui.BookmarkedVariablesHolder;
import us.ihmc.simulationconstructionset.gui.DoubleClickListener;
import us.ihmc.simulationconstructionset.gui.EntryBoxArrayTabbedPanel;
import us.ihmc.simulationconstructionset.gui.GraphArrayPanel;
import us.ihmc.simulationconstructionset.gui.YoEntryBox;
import us.ihmc.simulationconstructionset.gui.YoVariableExplorerTabbedPane;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariableListPanel;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariablePanelJPopupMenu;
import us.ihmc.simulationconstructionset.util.AdditionalPanelTools;
import us.ihmc.simulationconstructionset.util.RegularExpression;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.buffer.YoBufferVariableEntry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableSearchPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -3986327052893068969L;
    private static final int SCROLL_PANE_INCREMENT = 12;
    private static final boolean USE_BOOKMARKS_PANEL = false;
    private VariableSearchBox variableSearchBox;
    private final YoBuffer dataBuffer;
    private YoVariableListPanel yoVariableSearchResultsPanel;
    private final JTextArea entryBoxDescriptionArea;
    private final YoEntryBox entryBox;
    private final SelectedVariableHolder holder;
    private JLabel label;
    private GridBagConstraints frameLabelConstraint;
    private AdditionalPanelTools.FrameMap frameMap;
    private Predicate<YoVariable> filter;
    private final JLabel frameLabel = new JLabel();
    private boolean showOnlyParameters = false;

    public YoVariableSearchPanel(SelectedVariableHolder holder, YoBuffer dataBuffer, GraphArrayPanel graphArrayPanel, EntryBoxArrayTabbedPanel entryBoxArrayPanel, BookmarkedVariablesHolder bookmarkedVariablesHolder, YoVariableExplorerTabbedPane combinedVarPanel) {
        super(new BorderLayout());
        this.setName("SearchPanel");
        if (bookmarkedVariablesHolder == null) {
            System.err.println("Error: Bookmarks panel null!");
        }
        this.yoVariableSearchResultsPanel = new YoVariableListPanel("Search", holder, new YoVariablePanelJPopupMenu(graphArrayPanel, entryBoxArrayPanel, holder, combinedVarPanel, bookmarkedVariablesHolder), this);
        this.holder = this.yoVariableSearchResultsPanel.getVariableHolder();
        this.holder.addChangeListener((ChangeListener)this);
        JScrollPane searchResultScrollPane = new JScrollPane(this.yoVariableSearchResultsPanel, 22, 31);
        searchResultScrollPane.getVerticalScrollBar().setUnitIncrement(12);
        searchResultScrollPane.getVerticalScrollBar().setBlockIncrement(12);
        searchResultScrollPane.setPreferredSize(new Dimension(60, 260));
        searchResultScrollPane.setBorder(new EtchedBorder());
        Object splitPane = null;
        this.entryBox = new YoEntryBox(null, holder);
        this.entryBoxDescriptionArea = new JTextArea();
        this.entryBoxDescriptionArea.setEditable(false);
        this.entryBoxDescriptionArea.setLineWrap(true);
        this.entryBoxDescriptionArea.setWrapStyleWord(true);
        this.entryBoxDescriptionArea.setVisible(true);
        JScrollPane descrScroll = new JScrollPane(this.entryBoxDescriptionArea);
        descrScroll.setVisible(true);
        this.label = new JLabel("Search Settings:");
        this.label.setAlignmentX(0.5f);
        JLabel varDescription = new JLabel("");
        this.label.setAlignmentX(0.5f);
        this.add((Component)this.entryBox, "South");
        this.add((Component)varDescription, "South");
        this.add((Component)this.label, "South");
        this.dataBuffer = dataBuffer;
        this.setLayout(new GridBagLayout());
        this.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 11;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        this.variableSearchBox = new VariableSearchBox();
        ++c.gridy;
        c.gridwidth = 6;
        this.add((Component)this.variableSearchBox, c);
        c.weighty = 1.0;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.gridwidth = 6;
        c.gridheight = 5;
        this.add((Component)searchResultScrollPane, c);
        c.weighty = 0.0;
        c.gridy += 5;
        c.gridheight = 1;
        c.fill = 2;
        this.add((Component)this.entryBox, c);
        this.frameLabel.setBorder(new EmptyBorder(0, 6, 0, 6));
        this.frameLabelConstraint = new GridBagConstraints();
        this.frameLabelConstraint.anchor = c.anchor;
        this.frameLabelConstraint.fill = c.fill;
        this.frameLabelConstraint.weightx = c.weightx;
        this.frameLabelConstraint.weighty = c.weighty;
        this.frameLabelConstraint.gridx = c.gridx;
        this.frameLabelConstraint.gridy = c.gridy + 1;
        this.frameLabelConstraint.gridwidth = c.gridwidth;
        this.frameLabelConstraint.gridheight = c.gridheight;
        holder.addChangeListener(e -> this.updateFrameLabel());
    }

    public void updateFrameLabel() {
        if (this.frameMap == null || this.filter == null) {
            return;
        }
        YoVariable yoVariable = this.holder.getSelectedVariable();
        if (this.filter.test(yoVariable)) {
            ReferenceFrame frame = this.frameMap.getReferenceFrame(yoVariable.getValueAsLongBits());
            if (frame != null) {
                this.frameLabel.setText(frame.getName());
            } else {
                this.frameLabel.setText("UNKNOWN");
            }
            this.add((Component)this.frameLabel, this.frameLabelConstraint);
        } else {
            this.remove(this.frameLabel);
        }
    }

    public void setFrameMap(AdditionalPanelTools.FrameMap frameMap, Predicate<YoVariable> filter) {
        this.frameMap = frameMap;
        this.filter = filter;
    }

    public void setDoubleClickListener(DoubleClickListener listener) {
        this.yoVariableSearchResultsPanel.setDoubleClickListener(listener);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.entryBox.updateActiveContainer();
    }

    public void setShowOnlyParameters(boolean showOnlyParameters) {
        if (this.showOnlyParameters != showOnlyParameters) {
            this.showOnlyParameters = showOnlyParameters;
            SwingUtilities.invokeLater(() -> {
                if (this.variableSearchBox.hasSearched()) {
                    this.variableSearchBox.findMatchingVariablesRegularExpression();
                }
            });
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Runnable entryBoxChanger = new Runnable(){

            @Override
            public void run() {
                YoVariable selectedVariable = YoVariableSearchPanel.this.holder.getSelectedVariable();
                if (selectedVariable != null) {
                    YoVariableSearchPanel.this.entryBox.addVariable(selectedVariable);
                    YoVariableSearchPanel.this.entryBoxDescriptionArea.setText(selectedVariable.getDescription());
                    YoVariableSearchPanel.this.entryBoxDescriptionArea.setCaretPosition(0);
                } else {
                    YoVariableSearchPanel.this.entryBox.addVariable((YoVariable)new YoDouble("null", null));
                    YoVariableSearchPanel.this.entryBoxDescriptionArea.setText("");
                }
            }
        };
        SwingUtilities.invokeLater(entryBoxChanger);
    }

    public void refreshSearchPanelWidth() {
        this.yoVariableSearchResultsPanel.refreshPanelWidth();
    }

    public class VariableSearchBox
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 2584008799193548359L;
        private final JTextField searchTextField;
        private final Executor searchExecutor = Executors.newSingleThreadExecutor();
        private Searcher searcher;
        private boolean searched = false;

        public VariableSearchBox() {
            this.setLayout(new GridLayout(1, 1));
            this.searchTextField = new JTextField();
            this.searchTextField.setName("SearchTextField");
            this.searchTextField.addActionListener(this);
            String s = "<html>Search Tips :<br>A * B  = starting with 'A' and ending with 'B' <br>A*  = starting with 'A' <br>*A  = ending with 'A' <br>\"A\"  = exactly 'A' <br>A* | B*  anything starting with 'A' or 'B' <br>";
            this.searchTextField.setToolTipText(s);
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    VariableSearchBox.this.findMatchingVariablesRegularExpression();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    VariableSearchBox.this.findMatchingVariablesRegularExpression();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
            this.searchTextField.getDocument().addDocumentListener(documentListener);
            this.add(this.searchTextField);
        }

        public boolean hasSearched() {
            return this.searched;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.findMatchingVariablesRegularExpression();
        }

        public void findMatchingVariablesRegularExpression() {
            this.searched = true;
            if (this.searcher != null) {
                this.searcher.stopSearch();
            }
            this.searcher = new Searcher(this.searchTextField.getText().toString());
            this.searchExecutor.execute(this.searcher);
        }

        public class Searcher
        implements Runnable {
            private String searchText;
            private boolean stopSearch = false;
            private ArrayList<YoVariable> startsWithSearchTextList = new ArrayList();
            private ArrayList<YoVariable> doesNotStartWithSearchTextList = new ArrayList();

            public Searcher(String searchText) {
                this.searchText = searchText;
            }

            @Override
            public void run() {
                List<YoVariable> matchedVariables = this.search(this.searchText);
                if (!this.stopSearch) {
                    YoVariableSearchPanel.this.yoVariableSearchResultsPanel.removeAllVariables();
                }
                if (matchedVariables != null) {
                    for (YoVariable variable : matchedVariables) {
                        if (this.stopSearch) break;
                        YoVariableSearchPanel.this.yoVariableSearchResultsPanel.addVariable(variable);
                    }
                }
            }

            public List<YoVariable> search(String searchText) {
                ArrayList<YoVariable> ret = new ArrayList<YoVariable>();
                List entries = YoVariableSearchPanel.this.dataBuffer.getEntries();
                for (int i = 0; i < entries.size(); ++i) {
                    if (this.stopSearch) {
                        return null;
                    }
                    YoBufferVariableEntry entry = (YoBufferVariableEntry)entries.get(i);
                    boolean match = RegularExpression.check((String)entry.getVariable().getName(), (String)searchText);
                    if (match && YoVariableSearchPanel.this.showOnlyParameters) {
                        match = entry.getVariable().isParameter();
                    }
                    if (!match) continue;
                    ret.add(entry.getVariable());
                }
                this.sortList(ret);
                return ret;
            }

            private void sortList(List<YoVariable> list) {
                int i;
                String searchTextLowerCase = this.searchText.toLowerCase();
                for (i = 0; i < list.size(); ++i) {
                    if (list.get(i).getName().length() >= this.searchText.length() && searchTextLowerCase.equals(list.get(i).getName().substring(0, this.searchText.length()))) {
                        this.startsWithSearchTextList.add(list.get(i));
                        continue;
                    }
                    this.doesNotStartWithSearchTextList.add(list.get(i));
                }
                if (this.startsWithSearchTextList != null) {
                    for (i = 0; i < this.startsWithSearchTextList.size(); ++i) {
                        if (!searchTextLowerCase.equals(this.startsWithSearchTextList.get(i).getName().toLowerCase())) continue;
                        YoVariable temporaryYoVariable = this.startsWithSearchTextList.get(i);
                        this.startsWithSearchTextList.set(i, this.startsWithSearchTextList.get(0));
                        this.startsWithSearchTextList.set(0, temporaryYoVariable);
                    }
                    for (i = 0; i < this.doesNotStartWithSearchTextList.size(); ++i) {
                        this.startsWithSearchTextList.add(this.doesNotStartWithSearchTextList.get(i));
                    }
                }
                list.clear();
                for (i = 0; i < this.startsWithSearchTextList.size(); ++i) {
                    list.add(this.startsWithSearchTextList.get(i));
                }
            }

            public void stopSearch() {
                this.stopSearch = true;
            }
        }
    }
}

