/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.BookmarkedVariableAddedListener;
import us.ihmc.simulationconstructionset.gui.BookmarkedVariableRemovedListener;
import us.ihmc.simulationconstructionset.gui.BookmarkedVariablesHolder;
import us.ihmc.simulationconstructionset.gui.BookmarkedVariablesPanelTargetListener;
import us.ihmc.simulationconstructionset.gui.EntryBoxArrayTabbedPanel;
import us.ihmc.simulationconstructionset.gui.GraphArrayPanel;
import us.ihmc.simulationconstructionset.gui.YoVariableExplorerTabbedPane;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariableListPanel;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariablePanelJPopupMenu;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoVariable;

public class BookmarkedVariablesPanel
extends YoVariableListPanel {
    private static final long serialVersionUID = 1390064658136845739L;
    private BookmarkedVariablesHolder bookmarkedVariablesHolder;

    public BookmarkedVariablesPanel(String name, SelectedVariableHolder holder, BookmarkedVariablesHolder bookmarkedVariablesHolder) {
        super(new YoVariableList(name), holder, new YoVariablePanelJPopupMenu(holder));
        this.bookmarkedVariablesHolder = bookmarkedVariablesHolder;
        this.initBookMarks();
    }

    public BookmarkedVariablesPanel(YoVariableList list, SelectedVariableHolder holder, BookmarkedVariablesHolder bookmarkedVariablesHolder) {
        super(list, holder, new YoVariablePanelJPopupMenu(holder));
        this.bookmarkedVariablesHolder = bookmarkedVariablesHolder;
        this.initBookMarks();
    }

    public BookmarkedVariablesPanel(YoVariableList list, SelectedVariableHolder holder, GraphArrayPanel graphArrayPanel, EntryBoxArrayTabbedPanel entryBoxArrayPanel, BookmarkedVariablesHolder bookmarkedVariablesHolder, YoVariableExplorerTabbedPane combinedVarPanel) {
        super(list, holder, new YoVariablePanelJPopupMenu(graphArrayPanel, entryBoxArrayPanel, holder, combinedVarPanel, bookmarkedVariablesHolder));
        this.bookmarkedVariablesHolder = bookmarkedVariablesHolder;
        this.initBookMarks();
    }

    public BookmarkedVariablesPanel(String name, SelectedVariableHolder holder, GraphArrayPanel graphArrayPanel, EntryBoxArrayTabbedPanel entryBoxArrayPanel, BookmarkedVariablesHolder bookmarkedVariablesHolder, YoVariableExplorerTabbedPane combinedVarPanel) {
        super(new YoVariableList(name), holder, new YoVariablePanelJPopupMenu(graphArrayPanel, entryBoxArrayPanel, holder, combinedVarPanel, bookmarkedVariablesHolder));
        this.bookmarkedVariablesHolder = bookmarkedVariablesHolder;
        this.initBookMarks();
    }

    private void initBookMarks() {
        if (!SimulationConstructionSet.DISABLE_DnD) {
            this.setDropTarget(new DropTarget(this, new BookmarkedVariablesPanelTargetListener(this)));
        }
        this.bookmarkedVariablesHolder.addBookmarkedVariableAddedListener(new BookmarkedVariableAddedListener(){

            @Override
            public void bookmarkAdded(YoVariable variable) {
                BookmarkedVariablesPanel.this.addVariable(variable);
            }
        });
        this.bookmarkedVariablesHolder.addBookmarkedVariableRemovedListener(new BookmarkedVariableRemovedListener(){

            @Override
            public void bookmarkRemoved(YoVariable variable) {
                BookmarkedVariablesPanel.this.removeVariable(variable);
            }
        });
        this.initPopupMenu();
    }

    private void initPopupMenu() {
        if (this.varPanelJPopupMenu != null) {
            this.varPanelJPopupMenu.removeBookmarkVariable();
            JMenuItem removeVarible = new JMenuItem("Remove Variable");
            removeVarible.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BookmarkedVariablesPanel.this.selectedVariableHolder.getSelectedVariable() != null) {
                        BookmarkedVariablesPanel.this.removeVariable(BookmarkedVariablesPanel.this.selectedVariableHolder.getSelectedVariable());
                    }
                    BookmarkedVariablesPanel.this.varPanelJPopupMenu.setVisible(false);
                }
            });
            this.varPanelJPopupMenu.add(removeVarible);
        } else {
            System.err.println("Warning: Bookmarked Variables popupmenu not initialized because it is null.");
        }
    }

    public SelectedVariableHolder getSelectedVariableHolder() {
        return this.selectedVariableHolder;
    }

    public void bookmarkVariable(YoVariable variable) {
        this.bookmarkedVariablesHolder.addBookmark(variable);
    }
}

