/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraMountInterface;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class CameraMount
implements CameraMountInterface {
    private final String name;
    private final RigidBodyTransform offsetTransform;
    private final RigidBodyTransform transformToMount = new RigidBodyTransform();
    private final RigidBodyTransform transformToCamera = new RigidBodyTransform();
    private Joint parentJoint;
    private final Robot rob;
    private YoDouble pan;
    private YoDouble tilt;
    private YoDouble roll;
    private double fieldOfView;
    private double clipDistanceNear;
    private double clipDistanceFar;
    private int imageWidth;
    private int imageHeight;
    private boolean enablePanTiltRoll = false;
    private RigidBodyTransform panTiltRollTransform3D;
    private RigidBodyTransform temp1;
    private Point3D tempPoint3d;
    public RigidBodyTransform lookAtTransform3D;

    public CameraMount(String name, Tuple3DReadOnly offsetVector, Robot rob) {
        this(name, offsetVector, 0.7853981633974483, 0.1, 1000.0, rob);
    }

    public CameraMount(String name, RigidBodyTransformReadOnly camPose, Robot rob) {
        this(name, camPose, 0.7853981633974483, 0.1, 1000.0, rob);
    }

    public CameraMount(String name, Tuple3DReadOnly offsetVector, double fieldOfView, double clipDistanceNear, double clipDistanceFar, Robot rob) {
        this(name, (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), offsetVector), fieldOfView, clipDistanceNear, clipDistanceFar, rob);
    }

    public CameraMount(String name, RigidBodyTransformReadOnly offset, double fieldOfView, double clipDistanceNear, double clipDistanceFar, Robot rob) {
        this.name = name;
        this.rob = rob;
        this.offsetTransform = new RigidBodyTransform(offset);
        this.fieldOfView = fieldOfView;
        this.clipDistanceNear = clipDistanceNear;
        this.clipDistanceFar = clipDistanceFar;
    }

    public String getName() {
        return this.name;
    }

    protected void setParentJoint(Joint parent) {
        this.parentJoint = parent;
    }

    public Joint getParentJoint() {
        return this.parentJoint;
    }

    public String toString() {
        return "name: " + this.name;
    }

    public void enablePanTiltRoll() {
        YoRegistry registry = new YoRegistry("CameraMount");
        this.pan = new YoDouble("pan_" + this.name, registry);
        this.tilt = new YoDouble("tilt_" + this.name, registry);
        this.roll = new YoDouble("roll_" + this.name, registry);
        this.panTiltRollTransform3D = new RigidBodyTransform();
        this.temp1 = new RigidBodyTransform();
        this.enablePanTiltRoll = true;
        this.rob.addYoRegistry(registry);
    }

    public void lookAt(Point3DReadOnly center) {
        this.lookAt(center.getX(), center.getY(), center.getZ());
    }

    public void lookAt(double x, double y, double z) {
        if (this.tempPoint3d == null) {
            this.tempPoint3d = new Point3D();
        }
        if (this.lookAtTransform3D == null) {
            this.lookAtTransform3D = new RigidBodyTransform();
        }
        this.tempPoint3d.set(x, y, z);
        this.lookAtTransform3D.set(this.transformToMount);
        this.lookAtTransform3D.invert();
        this.lookAtTransform3D.transform((Point3DBasics)this.tempPoint3d);
        this.pan.set(Math.atan2(this.tempPoint3d.getY(), this.tempPoint3d.getX()));
        this.tilt.set(Math.atan2(-this.tempPoint3d.getZ(), Math.sqrt(this.tempPoint3d.getX() * this.tempPoint3d.getX() + this.tempPoint3d.getY() * this.tempPoint3d.getY())));
    }

    protected void updateTransform(RigidBodyTransformReadOnly t1) {
        this.transformToMount.set(t1);
        this.transformToMount.multiply((RigidBodyTransformReadOnly)this.offsetTransform);
        if (this.enablePanTiltRoll) {
            this.panTiltRollTransform3D.setRotationYawAndZeroTranslation(this.pan.getDoubleValue());
            this.temp1.setRotationPitchAndZeroTranslation(this.tilt.getDoubleValue());
            this.panTiltRollTransform3D.multiply((RigidBodyTransformReadOnly)this.temp1);
            this.temp1.setRotationRollAndZeroTranslation(this.roll.getDoubleValue());
            this.panTiltRollTransform3D.multiply((RigidBodyTransformReadOnly)this.temp1);
            this.transformToCamera.set(this.transformToMount);
            this.transformToCamera.multiply((RigidBodyTransformReadOnly)this.panTiltRollTransform3D);
        } else {
            this.transformToCamera.set(this.transformToMount);
        }
    }

    public void getTransformToMount(RigidBodyTransformBasics transformToPack) {
        transformToPack.set((RigidBodyTransformReadOnly)this.transformToMount);
    }

    public void getTransformToCamera(RigidBodyTransform transformToPack) {
        transformToPack.set(this.transformToCamera);
    }

    public void getOffsetTransform(RigidBodyTransformBasics offsetTransformToPack) {
        offsetTransformToPack.set((RigidBodyTransformReadOnly)this.offsetTransform);
    }

    public void setOffset(RigidBodyTransformReadOnly newOffsetTransform) {
        this.offsetTransform.set(newOffsetTransform);
    }

    public void setRoll(double roll) {
        if (this.enablePanTiltRoll) {
            this.roll.set(roll);
        }
    }

    public void setPan(double pan) {
        if (this.enablePanTiltRoll) {
            this.pan.set(pan);
        }
    }

    public void setTilt(double tilt) {
        if (this.enablePanTiltRoll) {
            this.tilt.set(tilt);
        }
    }

    public void setFieldOfView(double fieldOfView) {
        this.fieldOfView = fieldOfView;
    }

    public double getFieldOfView() {
        return this.fieldOfView;
    }

    public double getClipDistanceNear() {
        return this.clipDistanceNear;
    }

    public double getClipDistanceFar() {
        return this.clipDistanceFar;
    }

    public void zoom(double amount) {
        this.fieldOfView += amount;
        if (this.fieldOfView < 0.01) {
            this.fieldOfView = 0.01;
        } else if (this.fieldOfView > 3.0) {
            this.fieldOfView = 3.0;
        }
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }
}

