/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;

public class CylinderTerrainObject
implements TerrainObject3D,
HeightMapWithNormals {
    protected final BoundingBox3D boundingBox;
    protected final Cylinder3D cylinder;
    private final RigidBodyTransform location;
    private final double height;
    private final double radius;
    protected Graphics3DObject linkGraphics;
    private final Point3D tempPoint = new Point3D();
    private final Vector3D zVector = new Vector3D(0.0, 0.0, -1.0);
    private final ArrayList<Shape3DReadOnly> terrainCollisionShapes = new ArrayList();
    private final Point3D ignoreIntesectionPoint = new Point3D();
    private final Vector3D ignoreNormal = new Vector3D();

    public CylinderTerrainObject(RigidBodyTransform location, double height, double radius, AppearanceDefinition appearance) {
        this.height = height;
        this.radius = radius;
        this.location = location;
        this.cylinder = new Cylinder3D(height, radius);
        this.cylinder.applyTransform((Transform)location);
        Box3D box = new Box3D((RigidBodyTransformReadOnly)location, radius * 2.0, radius * 2.0, height);
        Point3DBasics[] vertices = box.getVertices();
        Point3D minPoint = new Point3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Point3D maxPoint = new Point3D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (Point3DBasics cornerPoint : vertices) {
            for (int i = 0; i < 3; ++i) {
                double coordinate = cornerPoint.getElement(i);
                if (coordinate > maxPoint.getElement(i)) {
                    maxPoint.setElement(i, coordinate);
                }
                if (!(coordinate < minPoint.getElement(i))) continue;
                minPoint.setElement(i, coordinate);
            }
        }
        this.boundingBox = new BoundingBox3D((Point3DReadOnly)minPoint, (Point3DReadOnly)maxPoint);
        this.addGraphics(appearance);
        Cylinder3D cylinderShape = new Cylinder3D(height, radius);
        cylinderShape.applyTransform((Transform)location);
        this.terrainCollisionShapes.add((Shape3DReadOnly)cylinderShape);
    }

    public CylinderTerrainObject(Vector3DReadOnly center, double pitchDownDegrees, double yawDegrees, double height, double radius, AppearanceDefinition app) {
        this(CylinderTerrainObject.yawPitchDegreesTransform(center, yawDegrees, pitchDownDegrees), height, radius, app);
    }

    private static RigidBodyTransform yawPitchDegreesTransform(Vector3DReadOnly center, double yawCCWDegrees, double pitchDownDegrees) {
        RigidBodyTransform location = new RigidBodyTransform();
        location.getRotation().setYawPitchRoll(Math.toRadians(yawCCWDegrees), Math.toRadians(pitchDownDegrees), 0.0);
        location.getTranslation().set((Tuple3DReadOnly)center);
        return location;
    }

    protected void addGraphics(AppearanceDefinition appearance) {
        RigidBodyTransform transform = this.transformToBottomOfCylinder();
        this.linkGraphics = new Graphics3DObject();
        this.linkGraphics.transform((RigidBodyTransformReadOnly)transform);
        this.getLinkGraphics().addCylinder(this.height, this.radius, appearance);
    }

    private RigidBodyTransform transformToBottomOfCylinder() {
        RigidBodyTransform ret = new RigidBodyTransform((RigidBodyTransformReadOnly)this.location);
        ret.appendTranslation(0.0, 0.0, -this.height / 2.0);
        return ret;
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.linkGraphics;
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double heightAt = this.heightAt(x, y, 1.0E9);
        this.surfaceNormalAt(x, y, heightAt, normalToPack);
        return heightAt;
    }

    public double heightAt(double x, double y, double z) {
        Point3D testPoint = new Point3D(x, y, z);
        Line3D zLine = new Line3D((Point3DReadOnly)testPoint, (Vector3DReadOnly)this.zVector);
        Point3D intersection1 = new Point3D();
        Point3D intersection2 = new Point3D();
        int numberOfIntersections = this.cylinder.intersectionWith((Line3DReadOnly)zLine, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
        if (numberOfIntersections == 0) {
            return 0.0;
        }
        if (numberOfIntersections == 1) {
            return intersection1.getZ();
        }
        if (testPoint.distanceSquared((Point3DReadOnly)intersection1) < testPoint.distanceSquared((Point3DReadOnly)intersection2)) {
            return intersection1.getZ();
        }
        return intersection2.getZ();
    }

    public Line3D getAxis() {
        Point3D axisOrigin = new Point3D();
        axisOrigin.set((Tuple3DReadOnly)this.location.getTranslation());
        Vector3D axisDirection = this.getAxisDirectionCopy();
        return new Line3D((Point3DReadOnly)axisOrigin, (Vector3DReadOnly)axisDirection);
    }

    public Vector3D getAxisDirectionCopy() {
        Vector3D axisDirection = new Vector3D();
        this.location.getRotation().getColumn(Axis3D.Z.ordinal(), (Tuple3DBasics)axisDirection);
        return axisDirection;
    }

    public double getXMin() {
        return this.boundingBox.getMinX();
    }

    public double getYMin() {
        return this.boundingBox.getMinY();
    }

    public double getXMax() {
        return this.boundingBox.getMaxX();
    }

    public double getYMax() {
        return this.boundingBox.getMaxY();
    }

    public boolean isClose(double x, double y, double z) {
        return this.boundingBox.isXYInsideInclusive(x, y);
    }

    public void closestIntersectionTo(double x, double y, double z, Point3DBasics intersectionToPack) {
        this.tempPoint.set(x, y, z);
        this.cylinder.evaluatePoint3DCollision((Point3DReadOnly)this.tempPoint, intersectionToPack, (Vector3DBasics)this.ignoreNormal);
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        this.tempPoint.set(x, y, z);
        this.cylinder.evaluatePoint3DCollision((Point3DReadOnly)this.tempPoint, (Point3DBasics)this.ignoreIntesectionPoint, normalToPack);
    }

    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        this.tempPoint.set(x, y, z);
        this.cylinder.evaluatePoint3DCollision((Point3DReadOnly)this.tempPoint, intersectionToPack, normalToPack);
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        this.tempPoint.set(x, y, z);
        return this.cylinder.evaluatePoint3DCollision((Point3DReadOnly)this.tempPoint, intersectionToPack, normalToPack);
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this;
    }

    public List<Shape3DReadOnly> getTerrainCollisionShapes() {
        return this.terrainCollisionShapes;
    }
}

