/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.LoadParametersConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ParameterFileChooser;
import us.ihmc.yoVariables.parameters.XmlParameterReader;
import us.ihmc.yoVariables.registry.YoRegistry;

public class LoadParametersGenerator
implements LoadParametersConstructor {
    private final SimulationConstructionSet scs;
    private ParameterFileChooser fileChooser;

    public LoadParametersGenerator(SimulationConstructionSet scs) {
        this.scs = scs;
        this.fileChooser = new ParameterFileChooser();
    }

    @Override
    public void constructDialog() {
        if (this.fileChooser.showDialog(this.scs.getJFrame(), this.scs.getRootRegistry(), this.scs.getParameterRootPath(), this.scs.getDefaultParameterFile(), false)) {
            try {
                FileInputStream is = new FileInputStream(this.fileChooser.getFile());
                XmlParameterReader reader = new XmlParameterReader(new InputStream[]{is});
                is.close();
                for (YoRegistry child : this.fileChooser.getRegistries()) {
                    reader.readParametersInRegistry(child);
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.scs.getJFrame(), "Cannot read from " + this.fileChooser.getFile() + "\n" + e.getMessage(), "Cannot read from file", 0);
            }
        }
    }

    @Override
    public void closeAndDispose() {
        this.fileChooser.closeAndDispose();
        this.fileChooser = null;
    }
}

