/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

import java.util.function.Predicate;
import javax.swing.JLabel;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.yoVariables.variable.YoVariable;

public class AdditionalPanelTools {
    public static void setupFrameView(SimulationConstructionSet scs, FrameMap frameIndexMap, Predicate<YoVariable> variableFilter) {
        JLabel frameNameLabel = new JLabel();
        scs.addExtraJpanel(frameNameLabel, "Frame Information", false);
        AdditionalPanelTools.updateFrameLabel(frameIndexMap, variableFilter, frameNameLabel, null);
        StandardSimulationGUI gui = scs.getStandardSimulationGUI();
        gui.addSelectedVariableChangedListener(e -> AdditionalPanelTools.updateFrameLabel(frameIndexMap, variableFilter, frameNameLabel, gui.getSelectedVariable()));
        gui.setFrameMap(frameIndexMap, variableFilter);
    }

    private static void updateFrameLabel(FrameMap frameIndexMap, Predicate<YoVariable> variableFilter, JLabel frameNameLabel, YoVariable variable) {
        if (variable == null) {
            frameNameLabel.setText("No variable selected.");
            return;
        }
        String text = "Not a frame.";
        if (variableFilter.test(variable)) {
            ReferenceFrame frame = frameIndexMap.getReferenceFrame(variable.getValueAsLongBits());
            text = frame != null ? frame.getName() : "Unknown Frame";
        }
        frameNameLabel.setText("<html>" + variable.getName() + "<br/>" + text);
    }

    public static interface FrameMap {
        public ReferenceFrame getReferenceFrame(long var1);
    }
}

