/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.dataBuffer;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class MirroredYoVariableRegistry
extends YoRegistry {
    private final ConcurrentLinkedQueue<Runnable> mirrorPendingActions = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> originalPendingActions = new ConcurrentLinkedQueue();

    public MirroredYoVariableRegistry(YoRegistry original) {
        super(original.getName());
        this.copyRegistry(original, this);
    }

    private void copyRegistry(YoRegistry original, YoRegistry mirror) {
        List originalVariables = original.getVariables();
        for (YoVariable originalVariable : originalVariables) {
            YoVariable mirrorVariable = originalVariable.duplicate(mirror);
            MirroredYoVariableRegistry.bindVariables(originalVariable, mirrorVariable, this.originalPendingActions, this.mirrorPendingActions);
        }
        for (YoRegistry childMirror : original.getChildren()) {
            YoRegistry newRegistry = new YoRegistry(childMirror.getName());
            mirror.addChild(newRegistry);
            this.copyRegistry(childMirror, newRegistry);
        }
    }

    public void updateMirror() {
        this.updateChangedValues();
        this.updateValuesFromOriginal();
    }

    public void updateChangedValues() {
        while (!this.mirrorPendingActions.isEmpty()) {
            this.mirrorPendingActions.poll().run();
        }
    }

    public void updateValuesFromOriginal() {
        while (!this.originalPendingActions.isEmpty()) {
            this.originalPendingActions.poll().run();
        }
    }

    private static void bindVariables(YoVariable variableA, YoVariable variableB, ConcurrentLinkedQueue<Runnable> actionQueueA, ConcurrentLinkedQueue<Runnable> actionQueueB) {
        Runnable actionA = () -> variableB.setValue(variableA, true);
        Runnable actionB = () -> variableA.setValue(variableB, true);
        variableA.addListener(v -> {
            if (variableA.getValueAsLongBits() != variableB.getValueAsLongBits()) {
                actionQueueA.add(actionA);
            }
        });
        variableB.addListener(v -> {
            if (variableA.getValueAsLongBits() != variableB.getValueAsLongBits()) {
                actionQueueB.add(actionB);
            }
        });
    }

    ConcurrentLinkedQueue<Runnable> getMirrorPendingActions() {
        return this.mirrorPendingActions;
    }

    ConcurrentLinkedQueue<Runnable> getOriginalPendingActions() {
        return this.originalPendingActions;
    }
}

