/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.CameraMount;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.IMUMount;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.KinematicPoint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;

public class GimbalJoint
extends PinJoint {
    private static final long serialVersionUID = 6692640300004794312L;
    private PinJoint joint2;
    private PinJoint joint3;

    public GimbalJoint(String jname1, String jname2, String jname3, Vector3DReadOnly offset, Robot rob, Axis3D firstAxis, Axis3D secondAxis, Axis3D thirdAxis) {
        super(jname1, (Tuple3DReadOnly)offset, rob, (Vector3DReadOnly)firstAxis);
        this.joint2 = new PinJoint(jname2, (Tuple3DReadOnly)new Vector3D(), rob, (Vector3DReadOnly)secondAxis);
        this.joint3 = new PinJoint(jname3, (Tuple3DReadOnly)new Vector3D(), rob, (Vector3DReadOnly)thirdAxis);
        this.joint2.parentJoint = this;
        this.childrenJoints.add(this.joint2);
        this.joint2.physics.r_in.setX(0.0);
        this.joint2.physics.r_in.setY(0.0);
        this.joint2.physics.r_in.setZ(0.0);
        this.joint3.parentJoint = this.joint2;
        this.joint2.childrenJoints.add(this.joint3);
        this.joint3.physics.r_in.setX(0.0);
        this.joint3.physics.r_in.setY(0.0);
        this.joint3.physics.r_in.setZ(0.0);
    }

    @Override
    public void addJoint(Joint nextJoint) {
        this.joint3.addJoint(nextJoint);
    }

    @Override
    public void setLink(Link l) {
        Link nullLink = new Link("null");
        nullLink.setMass(0.0);
        nullLink.setMomentOfInertia(0.0, 0.0, 0.0);
        nullLink.setComOffset(0.0, 0.0, 0.0);
        super.setLink(nullLink);
        nullLink = new Link("null");
        nullLink.setMass(0.0);
        nullLink.setMomentOfInertia(0.0, 0.0, 0.0);
        nullLink.setComOffset(0.0, 0.0, 0.0);
        this.joint2.setLink(nullLink);
        this.joint3.setLink(l);
    }

    @Override
    public void addCameraMount(CameraMount mount) {
        this.joint3.addCameraMount(mount);
    }

    @Override
    public void addIMUMount(IMUMount mount) {
        this.joint3.addIMUMount(mount);
    }

    @Override
    public void addKinematicPoint(KinematicPoint point) {
        this.joint3.addKinematicPoint(point);
    }

    @Override
    public void addGroundContactPoint(GroundContactPoint point) {
        this.joint3.addGroundContactPoint(point);
    }

    @Override
    public void addExternalForcePoint(ExternalForcePoint point) {
        this.joint3.addExternalForcePoint(point);
    }

    public void setLimitStops(int axis, double q_min, double q_max, double k_limit, double b_limit) {
        if (axis == 1) {
            super.setLimitStops(q_min, q_max, k_limit, b_limit);
        } else if (axis == 2) {
            this.joint2.setLimitStops(q_min, q_max, k_limit, b_limit);
        } else if (axis == 3) {
            this.joint3.setLimitStops(q_min, q_max, k_limit, b_limit);
        }
    }

    public void setDamping(int axis, double b_damp) {
        if (axis == 1) {
            super.setDamping(b_damp);
        } else if (axis == 2) {
            this.joint2.setDamping(b_damp);
        } else if (axis == 3) {
            this.joint3.setDamping(b_damp);
        }
    }

    @Override
    public void setDamping(double b_damp) {
        super.setDamping(b_damp);
        this.joint2.setDamping(b_damp);
        this.joint3.setDamping(b_damp);
    }

    public void setInitialState(double q1_init, double qd1_init, double q2_init, double qd2_init, double q3_init, double qd3_init) {
        super.setInitialState(q1_init, qd1_init);
        this.joint2.setInitialState(q2_init, qd2_init);
        this.joint3.setInitialState(q3_init, qd3_init);
    }

    @Override
    public void getState(double[] state) {
        state[0] = this.q.getDoubleValue();
        state[1] = this.qd.getDoubleValue();
        state[2] = this.joint2.q.getDoubleValue();
        state[3] = this.joint2.qd.getDoubleValue();
        state[4] = this.joint3.q.getDoubleValue();
        state[5] = this.joint3.qd.getDoubleValue();
    }
}

