/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;
import us.ihmc.robotics.robotDescription.Plane;
import us.ihmc.simulationconstructionset.FloatingSCSJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.FloatingPlanarJointPhysics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoDouble;

public class FloatingPlanarJoint
extends Joint
implements FloatingSCSJoint {
    private static final long serialVersionUID = -1627814016079577790L;
    public YoDouble q_t1;
    public YoDouble q_t2;
    public YoDouble qd_t1;
    public YoDouble qd_t2;
    public YoDouble q_rot;
    public YoDouble qd_rot;
    public YoDouble qdd_t1;
    public YoDouble qdd_t2;
    public YoDouble qdd_rot;
    public Plane type = Plane.XZ;
    YoVariableList floatingJointVars;
    private Vector3D position = new Vector3D();
    private final YawPitchRoll yawPitchRoll = new YawPitchRoll();

    public YoDouble getQ_t1() {
        return this.q_t1;
    }

    public YoDouble getQ_t2() {
        return this.q_t2;
    }

    public YoDouble getQd_t1() {
        return this.qd_t1;
    }

    public YoDouble getQd_t2() {
        return this.qd_t2;
    }

    public YoDouble getQ_rot() {
        return this.q_rot;
    }

    public YoDouble getQd_rot() {
        return this.qd_rot;
    }

    public YoDouble getQdd_t1() {
        return this.qdd_t1;
    }

    public YoDouble getQdd_t2() {
        return this.qdd_t2;
    }

    public YoDouble getQdd_rot() {
        return this.qdd_rot;
    }

    public FloatingPlanarJoint(String jname, Robot rob) {
        this(jname, rob, Plane.XZ);
        this.physics = new FloatingPlanarJointPhysics(this);
    }

    public FloatingPlanarJoint(String jname, Tuple3DReadOnly offset, Robot rob) {
        this(jname, offset, rob, Plane.XZ);
        this.physics = new FloatingPlanarJointPhysics(this);
    }

    public FloatingPlanarJoint(String jname, Robot rob, Plane type) {
        this(jname, (Tuple3DReadOnly)new Vector3D(), rob, type);
    }

    public FloatingPlanarJoint(String jname, Tuple3DReadOnly offset, Robot rob, Plane type) {
        super(jname, offset, rob, 3);
        String rot_name;
        String t2_name;
        String t1_name;
        this.physics = new FloatingPlanarJointPhysics(this);
        this.type = type;
        this.floatingJointVars = new YoVariableList(jname + " jointVars");
        if (type == Plane.XY) {
            t1_name = "x";
            t2_name = "y";
            rot_name = "yaw";
        } else if (type == Plane.XZ) {
            t1_name = "x";
            t2_name = "z";
            rot_name = "pitch";
        } else {
            t1_name = "y";
            t2_name = "z";
            rot_name = "roll";
        }
        YoRegistry registry = rob.getRobotsYoRegistry();
        this.q_t1 = new YoDouble("q_" + t1_name, "PlanarFloatingJoint " + t1_name + " position", registry);
        this.q_t2 = new YoDouble("q_" + t2_name, "PlanarFloatingJoint " + t2_name + " position", registry);
        this.q_rot = new YoDouble("q_" + rot_name, "PlanarFloatingJoint " + rot_name + " angle", registry);
        this.qd_t1 = new YoDouble("qd_" + t1_name, "PlanarFloatingJoint " + t1_name + " linear velocity", registry);
        this.qd_t2 = new YoDouble("qd_" + t2_name, "PlanarFloatingJoint " + t2_name + " linear velocity", registry);
        this.qd_rot = new YoDouble("qd_" + rot_name, "PlanarFloatingJoint " + rot_name + " angular velocity", registry);
        this.qdd_t1 = new YoDouble("qdd_" + t1_name, "PlanarFloatingJoint " + t1_name + " linear acceleration", registry);
        this.qdd_t2 = new YoDouble("qdd_" + t2_name, "PlanarFloatingJoint " + t2_name + " linear acceleration", registry);
        this.qdd_rot = new YoDouble("qdd_" + rot_name, "PlanarFloatingJoint " + rot_name + " angular acceleration", registry);
        this.setFloatingTransform3D(this.jointTransform3D);
        this.physics.u_i = null;
    }

    public FloatingPlanarJoint(String jname, String varName, Robot rob, Plane type) {
        this(jname, varName, (Tuple3DReadOnly)new Vector3D(), rob, type);
    }

    public FloatingPlanarJoint(String jname, String varName, Tuple3DReadOnly offset, Robot rob, Plane type) {
        super(jname, offset, rob, 6);
        String rot_name;
        String t2_name;
        String t1_name;
        this.physics = new FloatingPlanarJointPhysics(this);
        this.type = type;
        this.floatingJointVars = new YoVariableList(jname + " jointVars");
        if (type == Plane.XY) {
            t1_name = varName + "_x";
            t2_name = varName + "_y";
            rot_name = varName + "_yaw";
        } else if (type == Plane.XZ) {
            t1_name = varName + "x";
            t2_name = varName + "z";
            rot_name = varName + "pitch";
        } else {
            t1_name = varName + "y";
            t2_name = varName + "z";
            rot_name = varName + "roll";
        }
        YoRegistry registry = rob.getRobotsYoRegistry();
        this.q_t1 = new YoDouble("q_" + t1_name, "PlanarFloatingJoint " + t1_name + " position", registry);
        this.q_t2 = new YoDouble("q_" + t2_name, "PlanarFloatingJoint " + t2_name + " position", registry);
        this.q_rot = new YoDouble("q_" + rot_name, "PlanarFloatingJoint " + rot_name + " angle", registry);
        this.qd_t1 = new YoDouble("qd_" + t1_name, "PlanarFloatingJoint " + t1_name + " linear velocity", registry);
        this.qd_t2 = new YoDouble("qd_" + t2_name, "PlanarFloatingJoint " + t2_name + " linear velocity", registry);
        this.qd_rot = new YoDouble("qd_" + rot_name, "PlanarFloatingJoint " + rot_name + " angular velocity", registry);
        this.qdd_t1 = new YoDouble("qdd_" + t1_name, "PlanarFloatingJoint " + t1_name + " linear acceleration", registry);
        this.qdd_t2 = new YoDouble("qdd_" + t2_name, "PlanarFloatingJoint " + t2_name + " linear acceleration", registry);
        this.qdd_rot = new YoDouble("qdd_" + rot_name, "PlanarFloatingJoint " + rot_name + " angular acceleration", registry);
        this.setFloatingTransform3D(this.jointTransform3D);
        this.physics.u_i = null;
    }

    public void setCartesianPosition(double t1, double t2) {
        this.q_t1.set(t1);
        this.q_t2.set(t2);
    }

    public void setCartesianPosition(double t1, double t2, double t1Dot, double t2Dot) {
        this.q_t1.set(t1);
        this.q_t2.set(t2);
        this.qd_t1.set(t1Dot);
        this.qd_t2.set(t2Dot);
    }

    public void setCartesianPosition(Tuple2DReadOnly position, Tuple2DReadOnly velocity) {
        this.q_t1.set(position.getX());
        this.q_t2.set(position.getY());
        this.qd_t1.set(velocity.getX());
        this.qd_t2.set(velocity.getY());
    }

    public void setCartesianVelocity(Tuple2DReadOnly velocity) {
        this.qd_t1.set(velocity.getX());
        this.qd_t2.set(velocity.getY());
    }

    public void setCartesianVelocity(double t1Dot, double t2Dot) {
        this.qd_t1.set(t1Dot);
        this.qd_t2.set(t2Dot);
    }

    public void setRotation(double theta) {
        this.q_rot.set(theta);
    }

    public void setRotation(double theta, double thetaDot) {
        this.q_rot.set(theta);
        this.qd_rot.set(thetaDot);
    }

    public void setRotationalVelocity(double thetaDot) {
        this.qd_rot.set(thetaDot);
    }

    protected YoVariableList getJointVars() {
        return this.floatingJointVars;
    }

    @Override
    protected void update() {
        this.setFloatingTransform3D(this.jointTransform3D);
    }

    protected void setFloatingTransform3D(RigidBodyTransform t1) {
        if (this.type == Plane.YZ) {
            this.position.set(0.0, this.q_t1.getDoubleValue(), this.q_t2.getDoubleValue());
            t1.setRotationRollAndZeroTranslation(this.q_rot.getDoubleValue());
        } else if (this.type == Plane.XZ) {
            this.position.set(this.q_t1.getDoubleValue(), 0.0, this.q_t2.getDoubleValue());
            t1.setRotationPitchAndZeroTranslation(this.q_rot.getDoubleValue());
        } else {
            this.position.set(this.q_t1.getDoubleValue(), this.q_t2.getDoubleValue(), 0.0);
            t1.setRotationYawAndZeroTranslation(this.q_rot.getDoubleValue());
        }
        t1.getTranslation().set((Tuple3DReadOnly)this.position);
    }

    public Plane getType() {
        return this.type;
    }

    @Override
    public void setRotationAndTranslation(RigidBodyTransformReadOnly transform) {
        Quaternion rotation = new Quaternion();
        rotation.set(transform.getRotation());
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)rotation, (YawPitchRollBasics)this.yawPitchRoll);
        Vector3D translation = new Vector3D();
        translation.set(transform.getTranslation());
        switch (this.type) {
            case XY: {
                this.setRotation(this.yawPitchRoll.getRoll());
                this.setCartesianPosition(translation.getX(), translation.getY());
                break;
            }
            case XZ: {
                this.setRotation(this.yawPitchRoll.getPitch());
                this.setCartesianPosition(translation.getX(), translation.getZ());
                break;
            }
            default: {
                this.setRotation(this.yawPitchRoll.getYaw());
                this.setCartesianPosition(translation.getY(), translation.getZ());
            }
        }
    }

    @Override
    public void setVelocity(Tuple3DReadOnly velocity) {
        switch (this.type) {
            case XY: {
                this.setCartesianVelocity(velocity.getX(), velocity.getY());
                break;
            }
            case XZ: {
                this.setCartesianVelocity(velocity.getX(), velocity.getZ());
                break;
            }
            default: {
                this.setCartesianVelocity(velocity.getY(), velocity.getZ());
            }
        }
    }

    @Override
    public void setAngularVelocityInBody(Vector3DReadOnly angularVelocityInBody) {
        switch (this.type) {
            case XY: {
                this.setRotationalVelocity(angularVelocityInBody.getZ());
                break;
            }
            case XZ: {
                this.setRotationalVelocity(angularVelocityInBody.getY());
                break;
            }
            default: {
                this.setRotationalVelocity(angularVelocityInBody.getX());
            }
        }
    }

    @Override
    public void getVelocity(FrameVector3DBasics linearVelocityToPack) {
        switch (this.type) {
            case XY: {
                linearVelocityToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), this.qd_t1.getDoubleValue(), this.qd_t2.getDoubleValue(), 0.0);
                break;
            }
            case XZ: {
                linearVelocityToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), this.qd_t1.getDoubleValue(), 0.0, this.qd_t2.getDoubleValue());
                break;
            }
            default: {
                linearVelocityToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), 0.0, this.qd_t1.getDoubleValue(), this.qd_t2.getDoubleValue());
            }
        }
    }

    @Override
    public void getAngularVelocity(FrameVector3DBasics angularVelocityToPack, ReferenceFrame bodyFrame) {
        switch (this.type) {
            case XY: {
                angularVelocityToPack.setIncludingFrame(bodyFrame, 0.0, 0.0, this.qd_rot.getDoubleValue());
                break;
            }
            case XZ: {
                angularVelocityToPack.setIncludingFrame(bodyFrame, 0.0, this.qd_rot.getDoubleValue(), 0.0);
                break;
            }
            default: {
                angularVelocityToPack.setIncludingFrame(bodyFrame, this.qd_rot.getDoubleValue(), 0.0, 0.0);
            }
        }
    }
}

