/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class RampsGroundProfile
extends GroundProfileFromHeightMap {
    private final double rampSlope;
    private final double rampLength;
    private final double flatgroundLengthAtZero;
    private final BoundingBox3D boundingBox;

    public RampsGroundProfile(double rampSlope, double rampLength, double flatgroundLengthAtZero) {
        this.rampSlope = rampSlope;
        this.rampLength = rampLength;
        this.flatgroundLengthAtZero = flatgroundLengthAtZero;
        this.boundingBox = new BoundingBox3D((Point3DReadOnly)new Point3D(-20.0, -20.0, Double.NEGATIVE_INFINITY), (Point3DReadOnly)new Point3D(20.0, 20.0, Double.POSITIVE_INFINITY));
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        if (Math.abs(x) < this.flatgroundLengthAtZero / 2.0) {
            if (normalToPack != null) {
                normalToPack.setX(0.0);
                normalToPack.setY(0.0);
                normalToPack.setZ(1.0);
            }
            return 0.0;
        }
        if ((x = (Math.abs(x) - this.flatgroundLengthAtZero / 2.0) % (2.0 * this.rampLength)) > this.rampLength) {
            x -= this.rampLength;
            if (normalToPack != null) {
                normalToPack.setX(Math.tan(this.rampSlope));
                normalToPack.setY(0.0);
                normalToPack.setZ(1.0);
                normalToPack.normalize();
            }
            return this.rampSlope * this.rampLength - this.rampSlope * x;
        }
        if (normalToPack != null) {
            normalToPack.setX(-Math.tan(this.rampSlope));
            normalToPack.setY(0.0);
            normalToPack.setZ(1.0);
            normalToPack.normalize();
        }
        return this.rampSlope * x;
    }

    public double heightAt(double x, double y, double z) {
        return this.heightAndNormalAt(x, y, z, null);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

