/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.graphicsDescription.graphInterfaces.GraphIndicesHolder;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.GraphConfiguration;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.BodePlotConstructor;
import us.ihmc.simulationconstructionset.gui.ForcedRepaintPopupMenu;
import us.ihmc.simulationconstructionset.gui.YoGraphRemover;
import us.ihmc.simulationconstructionset.gui.YoGraphTargetListener;
import us.ihmc.simulationconstructionset.gui.YoGraphTransferHandler;
import us.ihmc.simulationconstructionset.gui.dialogs.GraphPropertiesDialog;
import us.ihmc.yoVariables.buffer.YoBufferBounds;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryHolder;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryReader;
import us.ihmc.yoVariables.buffer.interfaces.YoTimeBufferHolder;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraph
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    private static final int DONT_PLOT_BOTTOM_PIXELS = 25;
    private static final int PIXELS_PER_BOTTOM_ROW = 14;
    private static final int DONT_PLOT_TIMELINE_BOTTOM_PIXELS = 16;
    private GraphConfiguration graphConfiguration = new GraphConfiguration("default");
    protected static final int INDIVIDUAL_SCALING = 0;
    protected static final int AUTO_SCALING = 1;
    protected static final int MANUAL_SCALING = 2;
    protected static final int TIME_PLOT = 100;
    protected static final int PHASE_PLOT = 101;
    private final JFrame parentFrame;
    private final YoTimeBufferHolder timeDataHolder;
    private final YoBufferVariableEntryHolder dataEntryHolder;
    private final GraphIndicesHolder graphIndicesHolder;
    private final YoGraphRemover yoGraphRemover;
    private static final int MAX_NUM_GRAPHS = 10;
    private static final int MAX_NUM_BASELINES = 6;
    private static final int VAR_NAME_SPACING_FOR_PRINT = 160;
    private final Color[] colors = new Color[10];
    private final Color[] baseLineColors = new Color[6];
    private final List<YoBufferVariableEntryReader> entriesOnThisGraph;
    private final SelectedVariableHolder selectedVariableHolder;
    private boolean hasMinMaxChanged = true;
    private double min = 0.0;
    private double max = 1.1;
    private int[] xData;
    private int[] yData;
    private final List<Integer> entryNamePaintWidths = new ArrayList<Integer>();
    private final List<Integer> entryNamePaintRows = new ArrayList<Integer>();
    private int totalEntryNamePaintRows = 1;
    private JPopupMenu popupMenu;
    private JMenuItem delete;
    private static int actionPerformedByDragAndDrop = -1;
    private static Object sourceOfDrag = null;
    private static Object recipientOfDrag = null;
    boolean hadFocus = false;
    private boolean showNamespace = false;
    private boolean showBaseLines = false;
    private int focusedBaseLine = 0;
    private int previousGraphWidth;
    private static final String clickMessage = new String("Middle Click to graph selected variable");
    private StringBuffer stringBuffer = new StringBuffer(80);
    private String spaceString = "  ";
    private char[] charArray = new char[80];
    private final NumberFormat doubleFormat = new DecimalFormat(" 0.00000;-0.00000");
    private final FieldPosition fieldPosition = new FieldPosition(0);
    private final Stroke dashedStroke = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
    private final Stroke wideStroke = new BasicStroke(1.5f, 0, 2, 0.0f);
    private final Stroke normalStroke = new BasicStroke();
    private static final String SPACE_STRING = "  ";
    private static final String DOUBLE_FORMAT = EuclidCoreIOTools.getStringFormat((int)8, (int)5);
    private int clickedX;
    private int clickedY;
    private int draggedX;
    private int draggedY;
    private int clickedIndex;
    private int clickedLeftIndex;
    private int clickedRightIndex;

    public YoGraph(GraphIndicesHolder graphIndicesHolder, YoGraphRemover yoGraphRemover, SelectedVariableHolder holder, YoBufferVariableEntryHolder dataEntryHolder, YoTimeBufferHolder timeDataHolder, JFrame jFrame) {
        this.setName("YoGraph");
        this.selectedVariableHolder = holder;
        this.dataEntryHolder = dataEntryHolder;
        this.timeDataHolder = timeDataHolder;
        this.xData = new int[0];
        this.yData = new int[0];
        this.setBorder(new SoftBevelBorder(1));
        this.graphIndicesHolder = graphIndicesHolder;
        this.yoGraphRemover = yoGraphRemover;
        this.parentFrame = jFrame;
        this.setOpaque(true);
        this.entriesOnThisGraph = new ArrayList<YoBufferVariableEntryReader>();
        this.colors[0] = new Color(160, 0, 0);
        this.colors[1] = new Color(0, 0, 255);
        this.colors[2] = new Color(0, 128, 0);
        this.colors[3] = new Color(0, 0, 0);
        this.colors[4] = new Color(128, 128, 128);
        this.colors[5] = new Color(128, 0, 128);
        this.colors[6] = new Color(0, 128, 128);
        this.colors[7] = new Color(96, 96, 0);
        this.colors[8] = new Color(255, 80, 80);
        this.colors[9] = new Color(80, 255, 255);
        this.baseLineColors[0] = new Color(9662683);
        this.baseLineColors[1] = new Color(3978097);
        this.baseLineColors[2] = Color.ORANGE;
        this.baseLineColors[3] = Color.ORANGE;
        this.baseLineColors[4] = Color.ORANGE;
        this.baseLineColors[5] = Color.ORANGE;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        if (!SimulationConstructionSet.DISABLE_DnD) {
            this.setDropTarget(new DropTarget(this, new YoGraphTargetListener(this)));
        }
        this.popupMenu = new ForcedRepaintPopupMenu();
        this.delete = new JMenuItem("Delete Graph");
        final YoGraph thisYoGraph = this;
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                thisYoGraph.yoGraphRemover.removeGraph(thisYoGraph);
            }
        });
        this.popupMenu.addFocusListener(this);
        this.addFocusListener(this);
        this.setTransferHandler(new YoGraphTransferHandler());
        this.showNamespace = false;
    }

    public GraphConfiguration getGraphConfiguration() {
        return this.graphConfiguration;
    }

    protected int getScalingMethod() {
        return this.graphConfiguration.getScalingMethod();
    }

    protected void setScalingMethod(int method) {
        this.graphConfiguration.setScalingMethod(method);
    }

    protected int getPlotType() {
        return this.graphConfiguration.getPlotType();
    }

    protected void setPlotType(int type) {
        this.graphConfiguration.setPlotType(type);
    }

    protected double getManualMinScaling() {
        return this.graphConfiguration.getManualScalingMin();
    }

    protected double getManualMaxScaling() {
        return this.graphConfiguration.getManualScalingMax();
    }

    public void setShowBaseLines(boolean useBaseLine) {
        this.graphConfiguration.setShowBaseLines(useBaseLine);
    }

    public boolean getShowBaseLines() {
        return this.graphConfiguration.getShowBaseLines();
    }

    public void setBaseLine(double baseLine) {
        this.graphConfiguration.setBaseLine(baseLine);
    }

    public void setBaseLines(double baseLine1, double baseLine2) {
        this.graphConfiguration.setBaseLines(baseLine1, baseLine2);
    }

    public void setBaseLines(double[] baseLines) {
        this.graphConfiguration.setBaseLines(baseLines);
    }

    public void incrementBaseLine(int baseLineIndex, double scale) {
        if (baseLineIndex >= this.graphConfiguration.getBaseLines().length) {
            baseLineIndex = 0;
        }
        double min = this.getMin();
        double max = this.getMax();
        double range = max - min;
        double amountToIncrement = 0.01 * range * scale;
        this.graphConfiguration.incrementBaseLine(baseLineIndex, amountToIncrement);
    }

    public void zeroBaseLine(int baseLineIndex) {
        if (baseLineIndex >= this.graphConfiguration.getBaseLines().length) {
            baseLineIndex = 0;
        }
        this.graphConfiguration.setBaseLine(baseLineIndex, 0.0);
    }

    public void centerBaseLine(int baseLineIndex) {
        if (baseLineIndex >= this.graphConfiguration.getBaseLines().length) {
            baseLineIndex = 0;
        }
        double min = this.getMin();
        double max = this.getMax();
        double center = (max + min) / 2.0;
        this.graphConfiguration.setBaseLine(baseLineIndex, center);
    }

    public double[] getBaseLines() {
        return this.graphConfiguration.getBaseLines();
    }

    protected double getMax() {
        this.reCalcMinMax();
        return this.max;
    }

    protected double getMin() {
        this.reCalcMinMax();
        return this.min;
    }

    protected void setGraphConfiguration(GraphConfiguration graphConfiguration) {
        if (graphConfiguration == null) {
            return;
        }
        this.setManualScaling(graphConfiguration.getManualScalingMin(), graphConfiguration.getManualScalingMax());
        this.setScalingMethod(graphConfiguration.getScalingMethod());
        this.setPlotType(graphConfiguration.getPlotType());
        this.setShowBaseLines(graphConfiguration.getShowBaseLines());
        this.setBaseLines(graphConfiguration.getBaseLines());
    }

    protected void setManualScaling(double minScaling, double maxScaling) {
        this.graphConfiguration.setManualScalingMinMax(minScaling, maxScaling);
    }

    public List<YoBufferVariableEntryReader> getEntriesOnThisGraph() {
        return this.entriesOnThisGraph;
    }

    public boolean isEmpty() {
        return this.entriesOnThisGraph.isEmpty();
    }

    public void setInteractionEnable(boolean enable) {
        if (enable) {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            this.removeKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addKeyListener(this);
        } else {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            this.removeKeyListener(this);
        }
    }

    public int getNumVars() {
        return this.entriesOnThisGraph.size();
    }

    private void calculateRequiredEntryPaintWidthsAndRows() {
        int graphWidth;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.entryNamePaintWidths.clear();
        this.entryNamePaintRows.clear();
        this.previousGraphWidth = graphWidth = this.getWidth();
        int cumulatedWidth = 0;
        int row = 0;
        for (YoBufferVariableEntryReader entry : this.entriesOnThisGraph) {
            int variableWidth = fontMetrics.stringWidth(entry.getVariableName());
            int variablePlusValueWidth = variableWidth + 120;
            if (cumulatedWidth != 0 && cumulatedWidth + variablePlusValueWidth > graphWidth) {
                ++row;
                cumulatedWidth = 0;
            }
            cumulatedWidth += variablePlusValueWidth;
            this.entryNamePaintWidths.add(variablePlusValueWidth);
            this.entryNamePaintRows.add(row);
        }
        this.totalEntryNamePaintRows = row + 1;
    }

    public void addVariable(YoBufferVariableEntryReader entry) {
        if (entry == null) {
            return;
        }
        if (this.entriesOnThisGraph.size() >= 10) {
            return;
        }
        if (!this.entriesOnThisGraph.contains(entry)) {
            this.entriesOnThisGraph.add(entry);
        }
        this.reCalcMinMax();
        this.calculateRequiredEntryPaintWidthsAndRows();
        this.updateUI();
    }

    public void addVariableFromSelectedVariableHolder() {
        YoVariable yoVariable = this.selectedVariableHolder.getSelectedVariable();
        if (yoVariable != null) {
            this.addVariable(this.dataEntryHolder.getEntry(yoVariable));
        }
    }

    public void removeEntry(YoBufferVariableEntryReader entry) {
        if (this.entriesOnThisGraph.contains(entry)) {
            this.entriesOnThisGraph.remove(entry);
        }
        this.reCalcMinMax();
        this.calculateRequiredEntryPaintWidthsAndRows();
        this.updateUI();
    }

    private void reCalcMinMax() {
        if (this.graphConfiguration.getScalingMethod() != 1) {
            return;
        }
        int numVars = this.entriesOnThisGraph.size();
        if (numVars < 1) {
            return;
        }
        double newMin = Double.POSITIVE_INFINITY;
        double newMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < numVars; ++i) {
            YoBufferVariableEntryReader entry = this.entriesOnThisGraph.get(i);
            boolean inverted = entry.getInverted();
            YoBufferBounds bounds = entry.getBounds();
            double entryMin = bounds.getLowerBound();
            double entryMax = bounds.getUpperBound();
            if (inverted) {
                double temp = entryMax;
                entryMax = -entryMin;
                entryMin = -temp;
            }
            if (entryMax > newMax) {
                newMax = entryMax;
            }
            if (!(entryMin < newMin)) continue;
            newMin = entryMin;
        }
        this.hasMinMaxChanged = this.min != newMin || this.max != newMax;
        this.min = newMin;
        this.max = newMax;
    }

    private void calcXYData(YoBufferVariableEntryReader entry, int nPoints, int[] xData, int[] yData, double min, double max, int width, int height, int offsetFromLeft, int offsetFromTop, int leftPlotIndex, int rightPlotIndex) {
        double[] data = entry.getBuffer();
        boolean inverted = entry.getInverted();
        if (leftPlotIndex == rightPlotIndex) {
            for (int i = 0; i < nPoints; ++i) {
                xData[i] = offsetFromLeft;
                yData[i] = offsetFromTop;
            }
        } else {
            for (int i = 0; i < nPoints; ++i) {
                double dataAtTick = data[i];
                if (inverted) {
                    dataAtTick = -dataAtTick;
                }
                xData[i] = (i - leftPlotIndex) * width / (rightPlotIndex - leftPlotIndex) + offsetFromLeft;
                yData[i] = height - (int)((dataAtTick - min) / (max - min) * (double)height) + offsetFromTop;
            }
        }
    }

    private void calcScatterData(YoBufferVariableEntryReader entryX, YoBufferVariableEntryReader entryY, int nPoints, int[] xData, int[] yData, double minX, double maxX, double minY, double maxY, int width, int height, int offsetFromLeft, int offsetFromTop) {
        double[] dataX = entryX.getBuffer();
        double[] dataY = entryY.getBuffer();
        for (int i = 0; i < nPoints; ++i) {
            xData[i] = (int)((dataX[i] - minX) / (maxX - minX) * (double)width) + offsetFromLeft;
            yData[i] = height - (int)((dataY[i] - minY) / (maxY - minY) * (double)height) + offsetFromTop;
        }
    }

    protected synchronized void printGraph(Graphics g, int printWidth, int printHeight) {
        int inPoint = this.graphIndicesHolder.getInPoint();
        int outPoint = this.graphIndicesHolder.getOutPoint();
        int numVars = this.entriesOnThisGraph.size();
        if (numVars == 0) {
            return;
        }
        int cumOffset = 3;
        this.reCalcMinMax();
        for (int i = 0; i < numVars; ++i) {
            cumOffset = i * 96 + 3;
            YoBufferVariableEntryReader entry = this.entriesOnThisGraph.get(i);
            double[] data = entry.getBuffer();
            double minVal = 0.0;
            double maxVal = 1.0;
            if (this.graphConfiguration.getScalingMethod() == 0) {
                YoBufferBounds bounds = entry.isUsingCustomBounds() ? entry.getCustomBounds() : entry.getBounds();
                minVal = bounds.getLowerBound();
                maxVal = bounds.getUpperBound();
            } else if (this.graphConfiguration.getScalingMethod() == 1) {
                minVal = this.min;
                maxVal = this.max;
            } else if (this.graphConfiguration.getScalingMethod() == 2) {
                minVal = this.graphConfiguration.getManualScalingMin();
                maxVal = this.graphConfiguration.getManualScalingMax();
            }
            int nPoints = data.length;
            int length = (outPoint - inPoint + 1 + nPoints) % nPoints;
            if (length == 0) {
                length = nPoints;
            }
            int[] xDataPrint = new int[length];
            int[] yDataPrint = new int[length];
            for (int j = 0; j < length; ++j) {
                int index = (inPoint + j) % nPoints;
                xDataPrint[j] = j * printWidth / length;
                yDataPrint[j] = printHeight - 25 - (int)((data[index] - minVal) / (maxVal - minVal) * (double)(printHeight - 25));
            }
            g.setColor(this.colors[i % 10]);
            g.drawPolyline(xDataPrint, yDataPrint, xDataPrint.length);
            String dString = entry.getVariableName();
            g.drawString(dString, cumOffset, printHeight);
        }
    }

    public void repaintAllGraph() {
        this.reCalcMinMax();
        this.repaint();
    }

    public void repaintPartialGraph(int index, int oldIndex, int inPoint, int outPoint, int leftPlotIndex, int rightPlotIndex) {
        if (leftPlotIndex == rightPlotIndex) {
            return;
        }
        this.reCalcMinMax();
        if (this.hasMinMaxChanged) {
            this.hasMinMaxChanged = false;
            this.repaint();
            return;
        }
        int width = this.getWidth() - 6;
        int offsetFromLeft = 3;
        int xStart = (oldIndex - leftPlotIndex) * width / (rightPlotIndex - leftPlotIndex) + offsetFromLeft - 1;
        int xEnd = (index - leftPlotIndex) * width / (rightPlotIndex - leftPlotIndex) + offsetFromLeft;
        if (xStart < 0) {
            xStart = 0;
        }
        if (xEnd < 0) {
            xEnd = 0;
        }
        if (index > oldIndex) {
            this.repaint(xStart, 0, xEnd - xStart + 1, this.getHeight());
            this.repaint(0, this.getHeight() - 20, this.getWidth() - 1, 20);
        }
    }

    public void repaintGraphOnSetPoint(int leftIndex, int rightIndex, int leftPlotIndex, int rightPlotIndex) {
        if (leftIndex == rightIndex) {
            return;
        }
        double newMin = Double.POSITIVE_INFINITY;
        double newMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.entriesOnThisGraph.size(); ++i) {
            YoBufferVariableEntryReader entry = this.entriesOnThisGraph.get(i);
            boolean inverted = entry.getInverted();
            YoBufferBounds windowBounds = leftIndex < rightIndex ? entry.getWindowBounds(Math.max(leftIndex, leftPlotIndex), Math.min(rightIndex, rightPlotIndex)) : entry.getWindowBounds(leftPlotIndex, rightPlotIndex);
            double entryMax = windowBounds.getUpperBound();
            double entryMin = windowBounds.getLowerBound();
            if (inverted) {
                double temp = entryMax;
                entryMax = -entryMin;
                entryMin = -temp;
            }
            if (entryMax > newMax) {
                newMax = entryMax;
            }
            if (!(entryMin < newMin)) continue;
            newMin = entryMin;
        }
        this.min = newMin;
        this.max = newMax;
    }

    public void createBodePlotFromEntriesBetweenInOutPoints() {
        if (this.entriesOnThisGraph.size() < 2) {
            System.out.println("need 2 entries (input/output) for Bode plot");
            return;
        }
        if (!this.checkInOutPoints()) {
            return;
        }
        int inPoint = this.graphIndicesHolder.getInPoint();
        int outPoint = this.graphIndicesHolder.getOutPoint();
        YoBufferVariableEntryReader input = this.entriesOnThisGraph.get(0);
        YoBufferVariableEntryReader output = this.entriesOnThisGraph.get(1);
        double[] inputData = Arrays.copyOfRange(input.getBuffer(), inPoint, outPoint);
        double[] outputData = Arrays.copyOfRange(output.getBuffer(), inPoint, outPoint);
        double[] timeData = Arrays.copyOfRange(this.timeDataHolder.getTimeBuffer(), inPoint, outPoint);
        BodePlotConstructor.plotBodeFromInputToOutput(input.getVariableName(), output.getVariableName(), timeData, inputData, outputData);
    }

    public void createBodePlotFromEntries() {
        if (this.entriesOnThisGraph.size() < 2) {
            return;
        }
        YoBufferVariableEntryReader input = this.entriesOnThisGraph.get(0);
        YoBufferVariableEntryReader output = this.entriesOnThisGraph.get(1);
        double[] inputData = input.getBuffer();
        double[] outputData = output.getBuffer();
        double[] timeData = this.timeDataHolder.getTimeBuffer();
        BodePlotConstructor.plotBodeFromInputToOutput(input.getVariableName(), output.getVariableName(), timeData, inputData, outputData);
    }

    private boolean checkInOutPoints() {
        boolean valid;
        int inPoint = this.graphIndicesHolder.getInPoint();
        int outPoint = this.graphIndicesHolder.getOutPoint();
        boolean bl = valid = outPoint > inPoint;
        if (!valid) {
            System.out.println("Please set inPoint < outPoint and re-try");
        }
        return valid;
    }

    public void createFFTPlotsFromEntriesBetweenInOutPoints() {
        if (!this.checkInOutPoints()) {
            return;
        }
        int inPoint = this.graphIndicesHolder.getInPoint();
        int outPoint = this.graphIndicesHolder.getOutPoint();
        double[] timeData = this.timeDataHolder.getTimeBuffer();
        double[] rngTimeData = Arrays.copyOfRange(timeData, inPoint, outPoint);
        for (YoBufferVariableEntryReader entry : this.entriesOnThisGraph) {
            double[] data = entry.getBuffer();
            double[] rngData = Arrays.copyOfRange(data, inPoint, outPoint);
            BodePlotConstructor.plotFFT(entry.getVariableName(), rngTimeData, rngData);
        }
    }

    public void createFFTPlotsFromEntries() {
        double[] timeData = this.timeDataHolder.getTimeBuffer();
        for (YoBufferVariableEntryReader entry : this.entriesOnThisGraph) {
            double[] data = entry.getBuffer();
            BodePlotConstructor.plotFFT(entry.getVariableName(), timeData, data);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.graphConfiguration.getPlotType() == 100) {
            this.paintTimePlot(g);
        } else if (this.graphConfiguration.getPlotType() == 101) {
            this.paintPhasePlot(g);
        }
    }

    public void paintPhasePlot(Graphics g) {
        super.paintComponent(g);
        int graphWidth = this.getWidth();
        int graphHeight = this.getHeight();
        int numVars = this.entriesOnThisGraph.size();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (numVars == 0) {
            g.setColor(Color.white);
            int messageWidth = fontMetrics.stringWidth(clickMessage);
            g.drawString(clickMessage, (graphWidth - messageWidth) / 2, graphHeight / 2);
        }
        for (int i = 0; i < this.entriesOnThisGraph.size() / 2; ++i) {
            YoBufferVariableEntryReader entryX = this.entriesOnThisGraph.get(i);
            double[] dataX = entryX.getBuffer();
            YoBufferVariableEntryReader entryY = this.entriesOnThisGraph.get(i + 1);
            double minValX = 0.0;
            double maxValX = 1.0;
            double minValY = 0.0;
            double maxValY = 1.0;
            if (this.graphConfiguration.getScalingMethod() == 0) {
                YoBufferBounds xBounds = entryX.isUsingCustomBounds() ? entryX.getCustomBounds() : entryX.getBounds();
                minValX = xBounds.getLowerBound();
                maxValX = xBounds.getUpperBound();
                YoBufferBounds yBounds = entryY.isUsingCustomBounds() ? entryY.getCustomBounds() : entryY.getBounds();
                minValY = yBounds.getLowerBound();
                maxValY = yBounds.getUpperBound();
            } else if (this.graphConfiguration.getScalingMethod() == 1) {
                YoBufferBounds yBounds = entryY.getBounds();
                minValY = yBounds.getLowerBound();
                maxValY = yBounds.getUpperBound();
                YoBufferBounds xBounds = entryX.getBounds();
                minValX = xBounds.getLowerBound();
                maxValX = xBounds.getUpperBound();
            } else if (this.graphConfiguration.getScalingMethod() == 2) {
                minValX = minValY = this.graphConfiguration.getManualScalingMin();
                maxValX = maxValY = this.graphConfiguration.getManualScalingMax();
            }
            int nPoints = dataX.length;
            if (this.xData.length != nPoints || this.yData.length != nPoints) {
                this.xData = new int[nPoints];
                this.yData = new int[nPoints];
            }
            int totalDontPlotBottomPixels = 25 + 14 * (this.totalEntryNamePaintRows - 1);
            this.calcScatterData(entryX, entryY, nPoints, this.xData, this.yData, minValX, maxValX, minValY, maxValY, graphWidth - 6, graphHeight - totalDontPlotBottomPixels, 3, 5);
            g.setColor(this.colors[i % 10]);
            g.drawPolyline(this.xData, this.yData, this.xData.length);
            int index = this.graphIndicesHolder.getIndex();
            if (index >= this.xData.length || !(index < this.yData.length & index >= 0)) continue;
            g.setColor(Color.BLACK);
            g.drawLine(this.xData[index] - 5, this.yData[index], this.xData[index] + 5, this.yData[index]);
            g.drawLine(this.xData[index], this.yData[index] - 10, this.xData[index], this.yData[index] + 10);
        }
        this.paintVariableNamesAndValues(g, true);
    }

    public void paintTimePlot(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g2d = (Graphics2D)graphics;
        int graphWidth = this.getWidth();
        int graphHeight = this.getHeight();
        if (graphWidth != this.previousGraphWidth) {
            this.calculateRequiredEntryPaintWidthsAndRows();
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int index = this.graphIndicesHolder.getIndex();
        int inPoint = this.graphIndicesHolder.getInPoint();
        int outPoint = this.graphIndicesHolder.getOutPoint();
        int leftPlotIndex = this.graphIndicesHolder.getLeftPlotIndex();
        int rightPlotIndex = this.graphIndicesHolder.getRightPlotIndex();
        int numVars = this.entriesOnThisGraph.size();
        if (numVars == 0) {
            graphics.setColor(Color.white);
            int messageWidth = fontMetrics.stringWidth(clickMessage);
            graphics.drawString(clickMessage, (graphWidth - messageWidth) / 2, graphHeight / 2);
        }
        for (int i = 0; i < numVars; ++i) {
            YoBufferVariableEntryReader entry = this.entriesOnThisGraph.get(i);
            double[] data = entry.getBuffer();
            double minVal = 0.0;
            double maxVal = 1.0;
            if (this.graphConfiguration.getScalingMethod() == 0) {
                YoBufferBounds bounds = entry.isUsingCustomBounds() ? entry.getCustomBounds() : entry.getBounds();
                minVal = bounds.getLowerBound();
                maxVal = bounds.getUpperBound();
            } else if (this.graphConfiguration.getScalingMethod() == 1) {
                minVal = this.min;
                maxVal = this.max;
            } else if (this.graphConfiguration.getScalingMethod() == 2) {
                minVal = this.graphConfiguration.getManualScalingMin();
                maxVal = this.graphConfiguration.getManualScalingMax();
            }
            int nPoints = data.length;
            if (this.xData.length != nPoints || this.yData.length != nPoints) {
                this.xData = new int[nPoints];
                this.yData = new int[nPoints];
            }
            int totalDontPlotBottomPixels = 25 + 14 * (this.totalEntryNamePaintRows - 1);
            this.calcXYData(entry, nPoints, this.xData, this.yData, minVal, maxVal, graphWidth - 6, graphHeight - totalDontPlotBottomPixels, 3, 5, leftPlotIndex, rightPlotIndex);
            graphics.setColor(this.colors[i % 10]);
            g2d.setStroke(this.normalStroke);
            graphics.drawPolyline(this.xData, this.yData, this.xData.length);
            if (!this.graphConfiguration.getShowBaseLines()) continue;
            double[] baseLines = this.graphConfiguration.getBaseLines();
            for (int j = 0; j < baseLines.length; ++j) {
                double baseLine = baseLines[j];
                int baseY = graphHeight - totalDontPlotBottomPixels - (int)((baseLine - minVal) / (maxVal - minVal) * (double)(graphHeight - totalDontPlotBottomPixels)) + 5;
                graphics.setColor(this.baseLineColors[j]);
                g2d.setStroke(this.dashedStroke);
                graphics.drawLine(0, baseY, this.getWidth(), baseY);
                g2d.setStroke(this.normalStroke);
            }
        }
        this.paintVerticalIndexLines(graphics, graphWidth, graphHeight, index, inPoint, outPoint, leftPlotIndex, rightPlotIndex);
        this.paintVerticalTimeGrids(graphics, graphWidth, graphHeight);
        this.paintVariableNamesAndValues(graphics, false);
    }

    private void paintVerticalTimeGrids(Graphics graphics, int graphWidth, int graphHeight) {
        Graphics2D g2d = (Graphics2D)graphics;
        graphics.setColor(Color.green);
        g2d.setStroke(this.wideStroke);
        graphics.setColor(Color.red);
        g2d.setStroke(this.normalStroke);
    }

    private void paintVerticalIndexLines(Graphics graphics, int graphWidth, int graphHeight, int index, int inPoint, int outPoint, int leftPlotIndex, int rightPlotIndex) {
        Graphics2D g2d = (Graphics2D)graphics;
        graphics.setColor(Color.green);
        int leftToRightPlotIndexDelta = rightPlotIndex - leftPlotIndex;
        if (leftToRightPlotIndexDelta == 0) {
            return;
        }
        int linex = (graphWidth - 6) * (inPoint - leftPlotIndex) / leftToRightPlotIndexDelta + 3;
        int totalDontPlotTimelineBottomPixels = 16 + 14 * (this.totalEntryNamePaintRows - 1);
        int graphTopYValue = graphHeight - totalDontPlotTimelineBottomPixels;
        g2d.setStroke(this.wideStroke);
        graphics.drawLine(linex, 0, linex, graphTopYValue);
        graphics.setColor(Color.red);
        linex = (graphWidth - 6) * (outPoint - leftPlotIndex) / leftToRightPlotIndexDelta + 3;
        graphics.drawLine(linex, 0, linex, graphTopYValue);
        graphics.setColor(Color.ORANGE);
        List keys = this.graphIndicesHolder.getKeyPoints();
        for (int i = 0; i < keys.size(); ++i) {
            linex = (graphWidth - 6) * ((Integer)keys.get(i) - leftPlotIndex) / leftToRightPlotIndexDelta + 3;
            graphics.drawLine(linex, 0, linex, graphTopYValue);
        }
        graphics.setColor(Color.black);
        linex = (graphWidth - 6) * (index - leftPlotIndex) / leftToRightPlotIndexDelta + 3;
        graphics.drawLine(linex, 0, linex, graphTopYValue);
        g2d.setStroke(this.normalStroke);
    }

    private void paintVariableNamesAndValues(Graphics g, boolean phasePlot) {
        int previousRow = 0;
        int cumulativeOffset = 3;
        if (this.showBaseLines) {
            this.drawBaseLines(g);
            return;
        }
        for (int i = 0; i < this.entriesOnThisGraph.size(); ++i) {
            YoBufferVariableEntryReader entry = this.entriesOnThisGraph.get(i);
            if (phasePlot) {
                g.setColor(this.colors[i / 2 % 10]);
            } else {
                g.setColor(this.colors[i % 10]);
            }
            int row = this.entryNamePaintRows.get(i);
            if (row != previousRow) {
                cumulativeOffset = 3;
                previousRow = row;
            }
            this.drawVariableNameAndValue(g, cumulativeOffset, row, entry);
            cumulativeOffset += this.entryNamePaintWidths.get(i).intValue();
        }
    }

    private void drawBaseLines(Graphics g) {
        if (!this.graphConfiguration.getShowBaseLines()) {
            return;
        }
        double[] baseLines = this.graphConfiguration.getBaseLines();
        if (baseLines.length == 0) {
            return;
        }
        int row = 0;
        int graphHeight = this.getHeight();
        int yToDrawAt = graphHeight - 5 - 14 * (this.totalEntryNamePaintRows - row - 1);
        int cumOffset = 3;
        double total = 0.0;
        g.setColor(Color.black);
        g.drawString("BaseLines: ", cumOffset, yToDrawAt);
        cumOffset += 80;
        for (int i = 0; i < baseLines.length; ++i) {
            this.stringBuffer.delete(0, this.stringBuffer.length());
            double baseLine = baseLines[i];
            total += baseLine;
            this.formatDouble(this.stringBuffer, baseLine);
            String baseLineString = this.stringBuffer.toString();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int baseLineStringWidth = fontMetrics.stringWidth(baseLineString);
            g.setColor(this.colors[i]);
            g.drawString(baseLineString, cumOffset, yToDrawAt);
            cumOffset = cumOffset + baseLineStringWidth + 10;
        }
        double average = total / (double)baseLines.length;
        g.setColor(Color.black);
        this.stringBuffer.delete(0, this.stringBuffer.length());
        this.formatDouble(this.stringBuffer, average);
        String averageString = this.stringBuffer.toString();
        g.drawString("    Average = " + averageString, cumOffset, yToDrawAt);
    }

    private void drawVariableNameAndValue(Graphics g, int cumOffset, int row, YoBufferVariableEntryReader entry) {
        int graphHeight = this.getHeight();
        this.stringBuffer.delete(0, this.stringBuffer.length());
        if (this.graphIndicesHolder.isIndexAtOutPoint()) {
            YoGraph.getVariableNameAndValue(entry, this.stringBuffer);
        } else {
            YoGraph.getVariableNameAndValueAtIndex(entry, this.stringBuffer, this.graphIndicesHolder.getIndex());
        }
        if (this.showNamespace) {
            YoNamespace namespace = entry.getVariable().getNamespace();
            this.stringBuffer.insert(0, namespace);
        }
        int length = Math.min(this.stringBuffer.length(), this.charArray.length);
        this.stringBuffer.getChars(0, length, this.charArray, 0);
        int yToDrawAt = graphHeight - 5 - 14 * (this.totalEntryNamePaintRows - row - 1);
        g.drawChars(this.charArray, 0, length, cumOffset, yToDrawAt);
    }

    public static void getVariableNameAndValue(YoBufferVariableEntryReader entry, StringBuffer stringBuffer) {
        YoGraph.getVariableNameAndValueString(entry, stringBuffer, entry.getVariable().getValueAsDouble());
    }

    private static void getVariableNameAndValueAtIndex(YoBufferVariableEntryReader entry, StringBuffer stringBuffer, int index) {
        YoGraph.getVariableNameAndValueString(entry, stringBuffer, entry.readBufferAt(index));
    }

    private static void getVariableNameAndValueString(YoBufferVariableEntryReader entry, StringBuffer stringBuffer, double value) {
        YoVariable variable = entry.getVariable();
        stringBuffer.append(variable.getName()).append(SPACE_STRING).append(variable.convertDoubleValueToString(DOUBLE_FORMAT, value));
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        switch (code) {
            case 37: {
                this.graphIndicesHolder.tickLater(-1);
                break;
            }
            case 39: {
                this.graphIndicesHolder.tickLater(1);
                break;
            }
            case 18: {
                this.showNamespace = true;
                this.calculateRequiredEntryPaintWidthsAndRows();
                this.repaint();
                break;
            }
            case 17: {
                this.showBaseLines = true;
                this.calculateRequiredEntryPaintWidthsAndRows();
                this.repaint();
                break;
            }
            case 38: {
                this.incrementBaseLine(this.focusedBaseLine, 1.0);
                this.repaint();
                break;
            }
            case 40: {
                this.incrementBaseLine(this.focusedBaseLine, -1.0);
                this.repaint();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        int code = evt.getKeyCode();
        switch (code) {
            case 18: {
                this.showNamespace = false;
                this.calculateRequiredEntryPaintWidthsAndRows();
                this.repaint();
                break;
            }
            case 17: {
                this.showBaseLines = false;
                this.calculateRequiredEntryPaintWidthsAndRows();
                this.repaint();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        char character = evt.getKeyChar();
        switch (character) {
            case '1': {
                this.focusedBaseLine = 0;
                this.repaint();
                break;
            }
            case '2': {
                this.focusedBaseLine = 1;
                this.repaint();
                break;
            }
            case '3': {
                this.focusedBaseLine = 2;
                this.repaint();
                break;
            }
            case '4': {
                this.focusedBaseLine = 3;
                this.repaint();
                break;
            }
            case '5': {
                this.focusedBaseLine = 4;
                this.repaint();
                break;
            }
            case '6': {
                this.focusedBaseLine = 5;
                this.repaint();
                break;
            }
            case 'z': {
                this.zeroBaseLine(this.focusedBaseLine);
                this.repaint();
                break;
            }
            case 'c': {
                this.centerBaseLine(this.focusedBaseLine);
                this.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (evt.getSource().equals(this)) {
            this.popupMenu.setVisible(false);
        }
        this.requestFocus();
        int y = evt.getY();
        int x = evt.getX();
        int h = this.getHeight();
        int w = this.getWidth();
        this.clickedX = x;
        this.clickedY = y;
        this.draggedX = x;
        this.draggedY = y;
        this.clickedIndex = this.clickIndex(x, w);
        this.clickedLeftIndex = this.graphIndicesHolder.getLeftPlotIndex();
        this.clickedRightIndex = this.graphIndicesHolder.getRightPlotIndex();
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2 && !this.entriesOnThisGraph.isEmpty() && this.parentFrame != null) {
            new GraphPropertiesDialog(this.parentFrame, this);
        }
        if (SwingUtilities.isMiddleMouseButton(evt)) {
            if (y > h - this.totalEntryNamePaintRows * 14) {
                int idx = this.getClickedVariableIndex(x, y, h);
                if (idx < this.entriesOnThisGraph.size()) {
                    this.removeEntry(this.entriesOnThisGraph.get(idx));
                }
            } else {
                this.addVariableFromSelectedVariableHolder();
            }
        } else if (SwingUtilities.isLeftMouseButton(evt)) {
            if (this.entriesOnThisGraph == null || this.entriesOnThisGraph.size() < 1 || this.getPlotType() == 101) {
                return;
            }
            if (y <= h - this.totalEntryNamePaintRows * 14) {
                int newIndex = this.clickIndex(x, w);
                this.graphIndicesHolder.setIndexLater(newIndex);
            } else {
                int index = this.getClickedVariableIndex(x, y, h);
                if (index < this.entriesOnThisGraph.size()) {
                    YoBufferVariableEntryReader entry = this.entriesOnThisGraph.get(index);
                    this.selectedVariableHolder.setSelectedVariable(entry.getVariable());
                    if (!SimulationConstructionSet.DISABLE_DnD) {
                        if (!evt.isControlDown()) {
                            this.getTransferHandler().exportAsDrag(this, evt, 2);
                            actionPerformedByDragAndDrop = 2;
                        } else if (evt.isControlDown()) {
                            this.getTransferHandler().exportAsDrag(this, evt, 1);
                            actionPerformedByDragAndDrop = 1;
                        }
                        sourceOfDrag = this;
                    }
                    this.repaint();
                }
            }
        } else if (SwingUtilities.isRightMouseButton(evt)) {
            this.popupMenu.remove(this.delete);
            Component[] components = this.popupMenu.getComponents();
            for (Component component : components) {
                this.popupMenu.remove(component);
            }
            for (final YoBufferVariableEntryReader dataBufferEntry : this.entriesOnThisGraph) {
                final JMenuItem menuItem = new JMenuItem("Remove " + dataBufferEntry.getVariableName());
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        YoGraph.this.removeEntry(dataBufferEntry);
                        YoGraph.this.popupMenu.remove(menuItem);
                        YoGraph.this.popupMenu.setVisible(false);
                        YoGraph.this.popupMenu.invalidate();
                        YoGraph.this.popupMenu.revalidate();
                    }
                });
                this.popupMenu.add(menuItem);
            }
            this.popupMenu.add(this.delete);
            this.popupMenu.setLocation(evt.getXOnScreen(), evt.getYOnScreen());
            this.popupMenu.setVisible(true);
        }
    }

    private int getClickedVariableIndex(int x, int y, int graphHeight) {
        int rowClicked = (y - (graphHeight - this.totalEntryNamePaintRows * 14)) / 14;
        int index = 0;
        int totalOffset = 3;
        for (int j = 0; j < this.entryNamePaintWidths.size(); ++j) {
            Integer entryPaintWidth = this.entryNamePaintWidths.get(j);
            Integer row = this.entryNamePaintRows.get(j);
            if (row < rowClicked) {
                ++index;
                continue;
            }
            if (x <= (totalOffset += entryPaintWidth.intValue())) continue;
            ++index;
        }
        return index;
    }

    private int clickIndex(int x, int w) {
        int leftPlotIndex = this.graphIndicesHolder.getLeftPlotIndex();
        int rightPlotIndex = this.graphIndicesHolder.getRightPlotIndex();
        return this.clickIndex(x, w, leftPlotIndex, rightPlotIndex);
    }

    private int clickIndex(int x, int w, int leftPlotIndex, int rightPlotIndex) {
        return leftPlotIndex + (2 * x * (rightPlotIndex - leftPlotIndex) + w) / (2 * w);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        int index;
        this.draggedX = evt.getX();
        this.draggedY = evt.getY();
        int h = this.getHeight();
        int w = this.getWidth();
        if (this.draggedX > w) {
            this.draggedX = w;
        }
        if (this.draggedX < 0) {
            this.draggedX = 0;
        }
        if (this.clickedY > h - 16) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(evt) && this.getPlotType() != 101) {
            index = this.clickIndex(this.draggedX, w, this.clickedLeftIndex, this.clickedRightIndex);
            this.graphIndicesHolder.setIndexLater(index);
        }
        if (SwingUtilities.isRightMouseButton(evt)) {
            index = this.clickIndex(this.draggedX, w, this.clickedLeftIndex, this.clickedRightIndex);
            int newLeftIndex = this.clickedLeftIndex + this.clickedIndex - index;
            int newRightIndex = this.clickedRightIndex + this.clickedIndex - index;
            if (newLeftIndex < 0) {
                newLeftIndex = 0;
                newRightIndex = this.clickedRightIndex - this.clickedLeftIndex;
            }
            if (newRightIndex > this.graphIndicesHolder.getMaxIndex()) {
                newRightIndex = this.graphIndicesHolder.getMaxIndex();
                newLeftIndex = newRightIndex - (this.clickedRightIndex - this.clickedLeftIndex);
            }
            this.graphIndicesHolder.setLeftPlotIndex(newLeftIndex);
            this.graphIndicesHolder.setRightPlotIndex(newRightIndex);
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        if (arg0.getSource().equals(this) && this.hadFocus) {
            this.popupMenu.setVisible(false);
        }
        this.hadFocus = true;
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.popupMenu.setVisible(false);
        this.hadFocus = false;
    }

    public static int getActionPerformedByDragAndDrop() {
        return actionPerformedByDragAndDrop;
    }

    public static void setActionPerformedByDragAndDrop(int actionPerformedByDragAndDrop) {
        YoGraph.actionPerformedByDragAndDrop = actionPerformedByDragAndDrop;
    }

    public static Object getSourceOfDrag() {
        return sourceOfDrag;
    }

    public static void setSourceOfDrag(Object sourceOfDrag) {
        YoGraph.sourceOfDrag = sourceOfDrag;
    }

    public static Object getRecipientOfDrag() {
        return recipientOfDrag;
    }

    public static void setRecipientOfDrag(Object recipientOfDrag) {
        YoGraph.recipientOfDrag = recipientOfDrag;
    }

    private void formatDouble(StringBuffer stringBuffer, double doubleValue) {
        this.doubleFormat.format(doubleValue, stringBuffer, this.fieldPosition);
    }
}

