/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.util.ArrayList;
import us.ihmc.simulationconstructionset.gui.BookmarkedVariableAddedListener;
import us.ihmc.simulationconstructionset.gui.BookmarkedVariableRemovedListener;
import us.ihmc.yoVariables.variable.YoVariable;

public class BookmarkedVariablesHolder {
    private ArrayList<YoVariable> bookmarkedVariables = new ArrayList(0);
    private ArrayList<BookmarkedVariableAddedListener> listeners = new ArrayList(0);
    private ArrayList<BookmarkedVariableRemovedListener> removedListeners = new ArrayList(0);

    public ArrayList<YoVariable> getBookMarkedVariables() {
        return new ArrayList<YoVariable>(this.bookmarkedVariables);
    }

    public void addBookmark(YoVariable variable) {
        if (!this.bookmarkedVariables.contains(variable)) {
            this.bookmarkedVariables.add(variable);
            this.notifyBookmarkedVariableAddedListeners();
        }
    }

    public void removeBookmark(YoVariable variable) {
        if (this.bookmarkedVariables.remove(variable)) {
            this.notifyBookmarkedVariableRemovedListeners(variable);
        }
    }

    public void addBookmarkedVariableAddedListener(BookmarkedVariableAddedListener listener) {
        this.listeners.add(listener);
    }

    public void addBookmarkedVariableRemovedListener(BookmarkedVariableRemovedListener listener) {
        this.removedListeners.add(listener);
    }

    private void notifyBookmarkedVariableRemovedListeners(YoVariable variable) {
        for (BookmarkedVariableRemovedListener removedListener : this.removedListeners) {
            removedListener.bookmarkRemoved(variable);
        }
    }

    private void notifyBookmarkedVariableAddedListeners() {
        for (BookmarkedVariableAddedListener listener : this.listeners) {
            listener.bookmarkAdded(this.bookmarkedVariables.get(this.bookmarkedVariables.size() - 1));
        }
    }
}

