/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision.simple;

import java.util.List;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.robotDescription.CollisionMeshDescription;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.RigidJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.physics.CollisionHandler;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;
import us.ihmc.simulationconstructionset.physics.CollisionShapeFactory;
import us.ihmc.simulationconstructionset.physics.ScsCollisionDetector;
import us.ihmc.simulationconstructionset.physics.collision.DefaultCollisionVisualizer;
import us.ihmc.simulationconstructionset.physics.collision.simple.SimpleCollisionDetector;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class CollisionManager {
    private ScsCollisionDetector collisionDetector;
    private static final double collisionDetectorMargin = 0.002;
    private CollisionHandler collisionHandler;
    private DefaultCollisionVisualizer collisionVisualizer = null;
    private static final double impulseScale = 100.0;
    private static final double forceScale = 100.0;
    private static final double collisionBallRadius = 0.01;
    private final int numberOfVectorsToCreate = 1000;
    private final TerrainObject3D environmentObject;

    public CollisionManager(CollisionHandler collisionHandler) {
        this(null, collisionHandler);
    }

    public CollisionManager(TerrainObject3D environmentObject, CollisionHandler collisionHandler) {
        this.environmentObject = environmentObject;
        this.collisionHandler = collisionHandler;
    }

    public void setUpCollisionVisualizer(SimulationConstructionSet scs) {
        this.collisionVisualizer = new DefaultCollisionVisualizer(100.0, 100.0, 0.01, scs, 1000);
        if (this.collisionHandler == null) {
            throw new NullPointerException(this.getClass().getName() + "collision handler should be defined");
        }
        this.addListener();
    }

    private void addListener() {
        if (this.collisionVisualizer != null) {
            this.collisionHandler.addListener(this.collisionVisualizer);
        }
    }

    public void setUpCollisionDetector(ScsCollisionDetector collisionDetector) {
        this.collisionDetector = collisionDetector;
        this.collisionDetector.initialize();
    }

    public void setUpEnvironment() {
        Robot environmentRobot = new Robot("environmentRobot");
        RigidJoint environmentRobotRootJoint = new RigidJoint("envRootJoint", (Vector3DReadOnly)new Vector3D(), environmentRobot);
        Link environmentStaticLink = new Link("environmentLink");
        environmentRobotRootJoint.setLink(environmentStaticLink);
        if (this.environmentObject != null) {
            List<? extends Shape3DReadOnly> simpleShapes = this.environmentObject.getTerrainCollisionShapes();
            CollisionShapeFactory shapeFactory = this.getCollisionDetector().getShapeFactory();
            for (int i = 0; i < simpleShapes.size(); ++i) {
                Shape3DReadOnly shape3D = simpleShapes.get(i);
                CollisionShapeDescription<?> collisionShapeDescription = shapeFactory.createSimpleCollisionShape(shape3D);
                shapeFactory.addShape(environmentStaticLink, CollisionManager.extractRigidBodyTransform(shape3D), collisionShapeDescription, true, 65535, 65535);
            }
        }
        environmentStaticLink.enableCollisions(10, this.getCollisionHandler(), environmentRobot.getRobotsYoRegistry());
    }

    public void createCollisionShapesFromRobots(Robot[] robots) {
        SimpleCollisionDetector collisionDetector = new SimpleCollisionDetector();
        CollisionShapeFactory collisionShapeFactory = collisionDetector.getShapeFactory();
        collisionShapeFactory.setMargin(0.002);
        for (int i = 0; i < robots.length; ++i) {
            Robot robot = robots[i];
            CollisionManager.createCollisionShapesFromLinks(robot, collisionShapeFactory, this.collisionHandler, robot.getRobotsYoRegistry());
        }
        this.collisionDetector = collisionDetector;
    }

    public ScsCollisionDetector getCollisionDetector() {
        return this.collisionDetector;
    }

    public CollisionHandler getCollisionHandler() {
        return this.collisionHandler;
    }

    public DefaultCollisionVisualizer getCollisionVisualizer() {
        return this.collisionVisualizer;
    }

    private static void createCollisionShapesFromLinks(Robot robot, CollisionShapeFactory collisionShapeFactory, CollisionHandler collisionHandler, YoRegistry registry) {
        List<Joint> rootJoints = robot.getRootJoints();
        for (int i = 0; i < rootJoints.size(); ++i) {
            Joint rootJoint = rootJoints.get(i);
            CollisionManager.createCollisionShapesFromLinksRecursively(rootJoint, collisionShapeFactory, collisionHandler, registry);
        }
    }

    private static void createCollisionShapesFromLinksRecursively(Joint joint, CollisionShapeFactory collisionShapeFactory, CollisionHandler collisionHandler, YoRegistry registry) {
        Link link = joint.getLink();
        List<CollisionMeshDescription> collisionMeshDescriptions = link.getCollisionMeshDescriptions();
        if (collisionMeshDescriptions != null) {
            for (int i = 0; i < collisionMeshDescriptions.size(); ++i) {
                CollisionMeshDescription collisionMesh = collisionMeshDescriptions.get(i);
                collisionShapeFactory.addCollisionMeshDescription(link, collisionMesh);
            }
            link.enableCollisions(collisionHandler);
        }
        List<Joint> childrenJoints = joint.getChildrenJoints();
        for (int i = 0; i < childrenJoints.size(); ++i) {
            Joint childJoint = childrenJoints.get(i);
            CollisionManager.createCollisionShapesFromLinksRecursively(childJoint, collisionShapeFactory, collisionHandler, registry);
        }
    }

    private static RigidBodyTransform extractRigidBodyTransform(Shape3DReadOnly shape3D) {
        UnitVector3DReadOnly axis;
        RigidBodyTransform transform = new RigidBodyTransform();
        if (shape3D instanceof Sphere3DReadOnly) {
            Sphere3DReadOnly sphereShape = (Sphere3DReadOnly)shape3D;
            transform.getTranslation().set((Tuple3DReadOnly)sphereShape.getPosition());
        }
        if (shape3D instanceof Box3DReadOnly) {
            Box3DReadOnly boxShape = (Box3DReadOnly)shape3D;
            transform.set((RigidBodyTransformReadOnly)boxShape.getPose());
        }
        if (shape3D instanceof Capsule3DReadOnly) {
            Capsule3DReadOnly capsuleShape = (Capsule3DReadOnly)shape3D;
            transform.getTranslation().set((Tuple3DReadOnly)capsuleShape.getPosition());
            axis = capsuleShape.getAxis();
            transform.getRotation().set((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)axis));
        }
        if (shape3D instanceof Cylinder3DReadOnly) {
            Cylinder3DReadOnly cylinderShape = (Cylinder3DReadOnly)shape3D;
            transform.getTranslation().set((Tuple3DReadOnly)cylinderShape.getPosition());
            axis = cylinderShape.getAxis();
            transform.getRotation().set((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)axis));
        }
        return transform;
    }
}

