/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import us.ihmc.tools.gui.MyFileFilter;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ParameterFileChooser {
    private final JTextField rootPath = new JTextField("", 30);
    private JFileChooser fileChooser;
    private List<YoRegistry> registries;
    private File parameterFile;
    private YoNamespace defaultRoot = null;
    private File parameterFilePath = null;

    public ParameterFileChooser() {
        JPanel extraPanel = new JPanel();
        extraPanel.setLayout(new GridLayout(2, 1));
        extraPanel.add(new JLabel("Parameter root path:"));
        JPanel textHolder = new JPanel();
        textHolder.add(this.rootPath);
        this.rootPath.setAlignmentY(0.0f);
        extraPanel.add(textHolder);
        this.fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.fileChooser.setFileFilter((FileFilter)new MyFileFilter("xml", "XML Files"));
        this.fileChooser.setAccessory(extraPanel);
    }

    public boolean showDialog(Component parent, YoRegistry registry, YoNamespace newDefaultRoot, File file, boolean save) {
        int returnVal;
        if (file != null && file != this.parameterFilePath) {
            this.parameterFilePath = file;
            this.fileChooser.setSelectedFile(this.parameterFilePath);
        }
        if (newDefaultRoot != this.defaultRoot) {
            if (newDefaultRoot == null) {
                this.rootPath.setText("");
            } else {
                this.rootPath.setText(newDefaultRoot.getName());
            }
            this.defaultRoot = newDefaultRoot;
        }
        if ((returnVal = save ? this.fileChooser.showSaveDialog(parent) : this.fileChooser.showOpenDialog(parent)) == 0) {
            if (this.rootPath.getText().trim().isEmpty()) {
                this.registries = Collections.singletonList(registry);
            } else {
                YoNamespace fullNamespace;
                try {
                    fullNamespace = new YoNamespace(this.rootPath.getText().trim());
                }
                catch (RuntimeException e) {
                    JOptionPane.showMessageDialog(parent, "Invalid namespace. " + e.getMessage(), "Invalid namespace", 0);
                    return false;
                }
                try {
                    YoRegistry root = registry.findRegistry(fullNamespace);
                    this.registries = Collections.unmodifiableList(root.getChildren());
                }
                catch (RuntimeException e) {
                    JOptionPane.showMessageDialog(parent, "Cannot find registry with namespace " + this.rootPath.getText(), "Unknown root", 0);
                    return false;
                }
            }
            this.parameterFile = this.fileChooser.getSelectedFile();
            if (!this.parameterFile.getName().endsWith(".xml")) {
                this.parameterFile = new File(this.parameterFile.getParentFile(), this.parameterFile.getName() + ".xml");
            }
            if (save) {
                if (this.parameterFile.exists() && !this.parameterFile.canWrite()) {
                    JOptionPane.showMessageDialog(parent, "Cannot write to " + this.parameterFile.getPath(), "Cannot write to file", 0);
                    return false;
                }
                if (this.parameterFile.exists()) {
                    return JOptionPane.showOptionDialog(parent, "File exists, overwrite?", "Overwrite?", 0, 2, null, null, null) == 0;
                }
                return true;
            }
            if (!this.parameterFile.canRead()) {
                JOptionPane.showMessageDialog(parent, "Cannot read " + this.parameterFile.getPath(), "Cannot read file", 0);
                return false;
            }
            return true;
        }
        return false;
    }

    public List<YoRegistry> getRegistries() {
        return this.registries;
    }

    public File getFile() {
        return this.parameterFile;
    }

    public void closeAndDispose() {
        this.fileChooser = null;
    }
}

