/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.io.File;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.commands.ExportSnapshotCommandExecutor;
import us.ihmc.simulationconstructionset.gui.ActiveCanvas3DHolder;
import us.ihmc.simulationconstructionset.gui.SwingWorker;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportSnapshotDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.GUIEnablerAndDisabler;
import us.ihmc.tools.gui.MyFileFilter;

public class ExportSnapshotDialogGenerator
implements ExportSnapshotDialogConstructor {
    private ExportSnapshotCommandExecutor exportSnapshotCommandExecutor;
    private GUIEnablerAndDisabler guiEnablerAndDisabler;
    private ActiveCanvas3DHolder activeCanvas3DHolder;
    private JFrame frame;
    private JFileChooser fileChooser;
    private FileFilter jpegFileFilter = new MyFileFilter(new String[]{".jpg", ".jpeg"}, "JPEG (.jpg, .jpeg)");

    public ExportSnapshotDialogGenerator(ExportSnapshotCommandExecutor exportSnapshotCommandExecutor, GUIEnablerAndDisabler guiEnablerAndDisabler, Robot[] robots, ActiveCanvas3DHolder activeCanvas3DHolder, JFrame frame) {
        this.exportSnapshotCommandExecutor = exportSnapshotCommandExecutor;
        this.guiEnablerAndDisabler = guiEnablerAndDisabler;
        this.activeCanvas3DHolder = activeCanvas3DHolder;
        this.frame = frame;
        try {
            String defaultDirString;
            URL defaultDirURL;
            this.fileChooser = new JFileChooser();
            if (robots != null && (defaultDirURL = robots.getClass().getResource(".")) != null && (defaultDirString = defaultDirURL.getPath()) != null) {
                int idx = defaultDirString.indexOf("classes");
                if (idx > 0) {
                    defaultDirString = defaultDirString.substring(0, idx);
                }
                this.setCurrentDirectory(defaultDirString);
            }
            this.fileChooser.addChoosableFileFilter(this.jpegFileFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.fileChooser.setCurrentDirectory(dir);
    }

    @Override
    public void setCurrentDirectory(String dir) {
        this.fileChooser.setCurrentDirectory(new File(dir));
    }

    @Override
    public void constructDialog() {
        this.guiEnablerAndDisabler.disableGUIComponents();
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                try {
                    if (ExportSnapshotDialogGenerator.this.fileChooser.showSaveDialog(ExportSnapshotDialogGenerator.this.frame) == 0) {
                        File chosenFile = ExportSnapshotDialogGenerator.this.fileChooser.getSelectedFile();
                        ExportSnapshotDialogGenerator.this.exportSnapshotCommandExecutor.exportSnapshot(chosenFile);
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
                return new Object();
            }

            @Override
            public void finished() {
                ExportSnapshotDialogGenerator.this.guiEnablerAndDisabler.enableGUIComponents();
            }
        };
    }

    public void closeAndDispose() {
        this.exportSnapshotCommandExecutor = null;
        this.guiEnablerAndDisabler = null;
        this.activeCanvas3DHolder = null;
        this.frame = null;
        this.fileChooser = null;
        this.jpegFileFilter = null;
    }
}

