/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.SaveConfigurationDialogConstructor;
import us.ihmc.tools.gui.MyFileFilter;

public class SaveConfigurationDialogGenerator
implements SaveConfigurationDialogConstructor {
    private FileFilter dataFileFilter = new MyFileFilter(new String[]{".guiConf"}, "Gui Configuration (.guiConf)");
    private File chosenFile;
    private JFileChooser dataFileChooser;
    private JFrame frame;
    private StandardSimulationGUI myGUI;
    private SimulationConstructionSet sim;

    public SaveConfigurationDialogGenerator(SimulationConstructionSet sim, JFrame frame, StandardSimulationGUI myGUI) {
        this.frame = frame;
        this.sim = sim;
        this.myGUI = myGUI;
        try {
            File Configs = new File("Configurations");
            String path = Configs.toURI().getPath();
            this.dataFileChooser = new JFileChooser();
            this.setCurrentDirectory(path);
            this.dataFileChooser.setAcceptAllFileFilterUsed(false);
            this.dataFileChooser.addChoosableFileFilter(this.dataFileFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.dataFileChooser.setCurrentDirectory(dir);
    }

    @Override
    public void setCurrentDirectory(String dir) {
        this.dataFileChooser.setCurrentDirectory(new File(dir));
    }

    @Override
    public void constructDialog() {
        this.sim.disableGUIComponents();
        String fileEnding = ".guiConf";
        if (this.dataFileChooser.showSaveDialog(this.frame) == 0) {
            try {
                this.chosenFile = this.dataFileChooser.getSelectedFile();
                String filename = this.chosenFile.getName();
                if (!filename.endsWith(fileEnding)) {
                    filename = filename.concat(fileEnding);
                    if (!this.chosenFile.getName().equals(filename)) {
                        File newChosenFile;
                        this.chosenFile = newChosenFile = new File(this.chosenFile.getParent(), filename);
                    }
                }
                BufferedWriter output = null;
                output = new BufferedWriter(new FileWriter(this.chosenFile));
                output.write(this.writeGUIConfig());
                ((Writer)output).close();
                System.out.println("Your file has been written");
            }
            catch (Exception e) {
                System.err.println("Error While Writting/Saving Gui Configuration File");
                e.printStackTrace();
            }
        }
        this.sim.enableGUIComponents();
    }

    private String writeGUIConfig() {
        Object textToWrite = this.myGUI.getXMLStyleRepresentationOfGraphArrayPanel();
        textToWrite = (String)textToWrite + "\n" + this.myGUI.getXMLStyleRepresentationOfEntryBoxes();
        textToWrite = (String)textToWrite + "\n" + this.myGUI.getXMLStyleRepresentationOfViewPorts();
        textToWrite = (String)textToWrite + "\n" + this.myGUI.getXMLStyleRepresentationOfGraphWindows();
        textToWrite = (String)textToWrite + "\n" + this.myGUI.getXMLStyleRepresentationofJPanels();
        textToWrite = (String)textToWrite + "\n" + this.myGUI.getXMLStyleRepresentationofMultiViews();
        return textToWrite;
    }

    public void closeAndDispose() {
        this.dataFileFilter = null;
        this.chosenFile = null;
        this.dataFileChooser = null;
        this.frame = null;
        this.myGUI = null;
        this.sim = null;
    }
}

