/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.dataBuffer;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class MirroredYoVariableRegistry
extends YoRegistry {
    private final ConcurrentLinkedQueue<Runnable> mirrorPendingActions = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> originalPendingActions = new ConcurrentLinkedQueue();
    private boolean enableChangedListener = true;

    public MirroredYoVariableRegistry(YoRegistry original) {
        super(original.getName());
        this.copyRegistry(original, this);
    }

    private void copyRegistry(YoRegistry original, YoRegistry mirror) {
        List originalVariables = original.getVariables();
        for (YoVariable originalVariable : originalVariables) {
            YoVariable mirrorVariable = originalVariable.duplicate(mirror);
            mirrorVariable.addListener((YoVariableChangedListener)new YoVariableChangeForwarder(mirrorVariable, originalVariable, this.mirrorPendingActions));
            originalVariable.addListener((YoVariableChangedListener)new YoVariableChangeForwarder(originalVariable, mirrorVariable, this.originalPendingActions));
        }
        for (YoRegistry childMirror : original.getChildren()) {
            YoRegistry newRegistry = new YoRegistry(childMirror.getName());
            mirror.addChild(newRegistry);
            this.copyRegistry(childMirror, newRegistry);
        }
    }

    public void updateMirror() {
        this.updateChangedValues();
        this.updateValuesFromOriginal();
    }

    public void updateChangedValues() {
        while (!this.mirrorPendingActions.isEmpty()) {
            this.mirrorPendingActions.poll().run();
        }
    }

    public void updateValuesFromOriginal() {
        while (!this.originalPendingActions.isEmpty()) {
            this.originalPendingActions.poll().run();
        }
    }

    private class YoVariableChangeForwarder
    implements YoVariableChangedListener {
        private final Runnable forwardAction;
        private final ConcurrentLinkedQueue<Runnable> forwardActionQueue;

        public YoVariableChangeForwarder(YoVariable source, YoVariable target, ConcurrentLinkedQueue<Runnable> forwardActionQueue) {
            this.forwardActionQueue = forwardActionQueue;
            this.forwardAction = () -> {
                MirroredYoVariableRegistry.this.enableChangedListener = false;
                target.setValue(source, true);
                MirroredYoVariableRegistry.this.enableChangedListener = true;
            };
        }

        public void changed(YoVariable source) {
            if (MirroredYoVariableRegistry.this.enableChangedListener) {
                this.forwardActionQueue.add(this.forwardAction);
            }
        }
    }
}

