/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.simulatedSensors;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.JointWrenchSensor;
import us.ihmc.simulationconstructionset.simulatedSensors.WrenchCalculatorInterface;

public class FeatherStoneJointBasedWrenchCalculator
implements WrenchCalculatorInterface {
    private static final int WRENCH_SIZE = 6;
    private final String forceSensorName;
    private final Joint forceTorqueSensorJoint;
    private boolean doWrenchCorruption = false;
    private final DMatrixRMaj wrenchMatrix = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj corruptionMatrix = new DMatrixRMaj(6, 1);
    private Vector3D force = new Vector3D();
    private Vector3D tau = new Vector3D();

    public FeatherStoneJointBasedWrenchCalculator(String forceSensorName, Joint forceTorqueSensorJoint) {
        this.forceSensorName = forceSensorName;
        this.forceTorqueSensorJoint = forceTorqueSensorJoint;
    }

    @Override
    public String getName() {
        return this.forceSensorName;
    }

    @Override
    public void calculate() {
        JointWrenchSensor sensor = this.forceTorqueSensorJoint.getJointWrenchSensor();
        sensor.getJointForce((Tuple3DBasics)this.force);
        sensor.getJointTorque((Tuple3DBasics)this.tau);
        this.wrenchMatrix.zero();
        this.wrenchMatrix.set(0, 0, this.tau.getX());
        this.wrenchMatrix.set(1, 0, this.tau.getY());
        this.wrenchMatrix.set(2, 0, this.tau.getZ());
        this.wrenchMatrix.set(3, 0, this.force.getX());
        this.wrenchMatrix.set(4, 0, this.force.getY());
        this.wrenchMatrix.set(5, 0, this.force.getZ());
        if (this.doWrenchCorruption) {
            for (int i = 0; i < 6; ++i) {
                this.wrenchMatrix.add(i, 0, this.corruptionMatrix.get(i, 0));
            }
        }
    }

    @Override
    public Joint getJoint() {
        return this.forceTorqueSensorJoint;
    }

    @Override
    public DMatrixRMaj getWrench() {
        return this.wrenchMatrix;
    }

    @Override
    public void corruptWrenchElement(int row, double value) {
        this.corruptionMatrix.add(row, 0, value);
    }

    public String toString() {
        return this.forceSensorName;
    }

    @Override
    public void getTransformToParentJoint(RigidBodyTransform transformToPack) {
        this.forceTorqueSensorJoint.getJointWrenchSensor().getTransformToParentJoint((RigidBodyTransformBasics)transformToPack);
    }

    @Override
    public void setDoWrenchCorruption(boolean value) {
        this.doWrenchCorruption = value;
    }
}

