/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.physics.CollisionShapeWithLink;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoInteger;

public class ContactingExternalForcePoint
extends ExternalForcePoint {
    private static final long serialVersionUID = -5919153372698232766L;
    private final YoFrameVector3D surfaceNormalInJointFrame;
    private final YoInteger indexOfContactingPair;
    private final YoBoolean isSlipping;
    private int index = -1;
    private CollisionShapeWithLink collisionShape;
    private int numberOfPointsInContactWithSameShape = 0;
    private final Vector3D tempSurfaceNormal = new Vector3D();
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();

    public ContactingExternalForcePoint(String name, Joint parentJoint, YoRegistry registry) {
        super(name, registry);
        this.setParentJoint(parentJoint);
        this.surfaceNormalInJointFrame = new YoFrameVector3D(name + "SurfaceNormal", null, registry);
        this.indexOfContactingPair = new YoInteger(name + "PairIndex", registry);
        this.isSlipping = new YoBoolean(name + "IsSlipping", registry);
        this.indexOfContactingPair.set(-1);
    }

    public int getNumberOfPointsInContactWithSameShape() {
        return this.numberOfPointsInContactWithSameShape;
    }

    public void setNumberOfPointsInContactWithSameShape(int numberOfPointsInContactWithSameShape) {
        this.numberOfPointsInContactWithSameShape = numberOfPointsInContactWithSameShape;
    }

    public int getIndexOfContactingPair() {
        return this.indexOfContactingPair.getIntegerValue();
    }

    public void setIndexOfContactingPair(int indexOfContactingPair) {
        this.indexOfContactingPair.set(indexOfContactingPair);
    }

    public void setIsSlipping(boolean isSlipping) {
        this.isSlipping.set(isSlipping);
    }

    public boolean getIsSlipping() {
        return this.isSlipping.getBooleanValue();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public Link getLink() {
        return this.parentJoint.getLink();
    }

    public void setSurfaceNormalInWorld(Vector3DReadOnly surfaceNormalInWorld) {
        this.tempSurfaceNormal.set((Tuple3DReadOnly)surfaceNormalInWorld);
        this.parentJoint.getTransformToWorld((RigidBodyTransformBasics)this.tempTransform);
        this.tempTransform.invert();
        this.tempTransform.transform((Vector3DBasics)this.tempSurfaceNormal);
        this.surfaceNormalInJointFrame.set((Tuple3DReadOnly)this.tempSurfaceNormal);
    }

    public void getSurfaceNormalInWorld(Vector3DBasics surfaceNormalInWorldToPack) {
        surfaceNormalInWorldToPack.set((Tuple3DReadOnly)this.surfaceNormalInJointFrame);
        this.parentJoint.getTransformToWorld((RigidBodyTransformBasics)this.tempTransform);
        this.tempTransform.transform(surfaceNormalInWorldToPack);
    }

    public boolean isInContact() {
        return this.getIndexOfContactingPair() != -1;
    }

    public void setCollisionShape(CollisionShapeWithLink collisionShape) {
        this.collisionShape = collisionShape;
        if (collisionShape.getLink() != this.getLink()) {
            throw new RuntimeException("Inconsistent links...");
        }
    }

    public CollisionShapeWithLink getCollisionShape() {
        return this.collisionShape;
    }
}

