/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

import java.util.List;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.GroundContactPointsHolder;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class LinearStickSlipGroundContactModel
implements GroundContactModel {
    private YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final long serialVersionUID = -2481515446904072547L;
    private static final double DEFAULT_K_XY = 1422.0;
    private static final double DEFAULT_B_XY = 15.6;
    private static final double DEFAULT_K_Z = 125.0;
    private static final double DEFAULT_B_Z = 300.0;
    private static final double DEFAULT_STIFFENING_LENGTH = 0.008;
    private static final double DEFAULT_ALPHA_SLIP = 0.7;
    private static final double DEFAULT_ALPHA_STICK = 0.7;
    private final YoDouble groundKxy = new YoDouble("groundKxy", "LinearStickSlipGroundContactModel x and y spring constant", this.registry);
    private final YoDouble groundBxy = new YoDouble("groundBxy", "LinearStickSlipGroundContactModel x and y damping constant", this.registry);
    private final YoDouble groundKz = new YoDouble("groundKz", "LinearStickSlipGroundContactModel z spring constant", this.registry);
    private final YoDouble groundBz = new YoDouble("groundBz", "LinearStickSlipGroundContactModel z damping constant", this.registry);
    private final YoDouble groundStiffeningLength = new YoDouble("groundStiffeningLength", "LinearStickSlipGroundContactModel z spring nominal stiffening length", this.registry);
    private final YoDouble groundAlphaSlip = new YoDouble("groundAlphaSlip", "LinearStickSlipGroundContactModel slip coefficient of friction", this.registry);
    private final YoDouble groundAlphaStick = new YoDouble("groundAlphaStick", "LinearStickSlipGroundContactModel stick coefficient of friction", this.registry);
    private final YoBoolean groundEnableSlip = new YoBoolean("groundEnableSlip", "LinearStickSlipGroundContactModel. If true can slip", this.registry);
    private final YoBoolean groundEnableSurfaceNormal = new YoBoolean("groundEnableSurfaceNormal", "LinearStickSlipGroundContactModel. If true will take into account surface normals in computations.", this.registry);
    private List<GroundContactPoint> groundContactPoints;
    private GroundProfile3D groundProfile3D;
    private final Point3D intersectionPositionInWorld = new Point3D();
    private final Vector3D surfaceNormalTemp = new Vector3D();
    private final Point3D touchdownLocation = new Point3D();
    private final Point3D position = new Point3D();
    private final Vector3D deltaPositionFromTouchdown = new Vector3D();
    private final Vector3D velocity = new Vector3D();
    private final Vector3D inPlaneVector1 = new Vector3D();
    private final Vector3D inPlaneVector2 = new Vector3D();
    private final Point3D touchDownPoint = new Point3D();
    private final Vector3D tempVector = new Vector3D();
    private final Vector3D forceWorld = new Vector3D();
    private final Vector3D forceNormal = new Vector3D();
    private final Vector3D forceParallel = new Vector3D();

    public LinearStickSlipGroundContactModel(GroundContactPointsHolder groundContactPointsHolder, YoRegistry parentRegistry) {
        this(groundContactPointsHolder, 1422.0, 15.6, 125.0, 300.0, 0.7, 0.7, parentRegistry);
    }

    public LinearStickSlipGroundContactModel(GroundContactPointsHolder groundContactPointsHolder, double alphaSlip, double alphaStick, YoRegistry parentRegistry) {
        this(groundContactPointsHolder, 1422.0, 15.6, 125.0, 300.0, alphaSlip, alphaStick, parentRegistry);
    }

    public LinearStickSlipGroundContactModel(GroundContactPointsHolder groundContactPointsHolder, int groundContactGroupIdentifier, double groundKxy, double groundBxy, double groundKz, double groundBz, YoRegistry parentRegistry) {
        this(groundContactPointsHolder, groundContactGroupIdentifier, groundKxy, groundBxy, groundKz, groundBz, 0.7, 0.7, parentRegistry);
    }

    public LinearStickSlipGroundContactModel(GroundContactPointsHolder groundContactPointsHolder, double groundKxy, double groundBxy, double groundKz, double groundBz, double groundAlphaSlip, double groundAlphaStick, YoRegistry parentRegistry) {
        this(groundContactPointsHolder, 0, groundKxy, groundBxy, groundKz, groundBz, groundAlphaSlip, groundAlphaStick, parentRegistry);
    }

    public LinearStickSlipGroundContactModel(GroundContactPointsHolder groundContactPointsHolder, int groundContactGroupIdentifier, double groundKxy, double groundBxy, double groundKz, double groundBz, double groundAlphaSlip, double groundAlphaStick, YoRegistry parentRegistry) {
        this.groundContactPoints = groundContactPointsHolder.getGroundContactPoints(groundContactGroupIdentifier);
        this.groundKxy.set(groundKxy);
        this.groundBxy.set(groundBxy);
        this.groundKz.set(groundKz);
        this.groundBz.set(groundBz);
        this.groundAlphaSlip.set(groundAlphaSlip);
        this.groundAlphaStick.set(groundAlphaStick);
        this.groundStiffeningLength.set(0.008);
        this.groundEnableSlip.set(true);
        this.groundEnableSurfaceNormal.set(true);
        parentRegistry.addChild(this.registry);
    }

    public void enableSlipping() {
        this.groundEnableSlip.set(true);
    }

    public void disableSlipping() {
        this.groundEnableSlip.set(false);
    }

    public void enableSurfaceNormal() {
        this.groundEnableSurfaceNormal.set(true);
    }

    public void disableSurfaceNormal() {
        this.groundEnableSurfaceNormal.set(false);
    }

    public void setGroundStiffeningLength(double groundStiffeningLength) {
        this.groundStiffeningLength.set(groundStiffeningLength);
    }

    public void setAlphaStickSlip(double groundAlphaStick, double groundAlphaSlip) {
        this.groundAlphaStick.set(groundAlphaStick);
        this.groundAlphaSlip.set(groundAlphaSlip);
    }

    public void setXYStiffness(double xyStiffness) {
        this.groundKxy.set(xyStiffness);
    }

    public void setZStiffness(double zStiffness) {
        this.groundKz.set(zStiffness);
    }

    public void setXYDamping(double xyDamping) {
        this.groundBxy.set(xyDamping);
    }

    public void setZDamping(double zDamping) {
        this.groundBz.set(zDamping);
    }

    @Override
    public void setGroundProfile3D(GroundProfile3D profile3D) {
        this.groundProfile3D = profile3D;
    }

    @Override
    public GroundProfile3D getGroundProfile3D() {
        return this.groundProfile3D;
    }

    @Override
    public void doGroundContact() {
        if (this.groundAlphaStick.getDoubleValue() < this.groundAlphaSlip.getDoubleValue()) {
            throw new RuntimeException("alpha stick < alpha slip!");
        }
        for (int i = 0; i < this.groundContactPoints.size(); ++i) {
            GroundContactPoint groundContactPoint = this.groundContactPoints.get(i);
            this.doGroundContact(groundContactPoint);
        }
        this.zeroOutTemporaryVariables();
    }

    private boolean checkIfInContactUsingProfile3D(GroundContactPoint groundContactPoint) {
        boolean isInside;
        if (this.groundProfile3D == null) {
            isInside = groundContactPoint.getZ() < 0.0;
            this.intersectionPositionInWorld.set(groundContactPoint.getX(), groundContactPoint.getY(), 0.0);
            this.surfaceNormalTemp.set(0.0, 0.0, 1.0);
        } else {
            isInside = !this.groundProfile3D.isClose(groundContactPoint.getX(), groundContactPoint.getY(), groundContactPoint.getZ()) ? false : this.groundProfile3D.checkIfInside(groundContactPoint.getX(), groundContactPoint.getY(), groundContactPoint.getZ(), (Point3DBasics)this.intersectionPositionInWorld, (Vector3DBasics)this.surfaceNormalTemp);
        }
        if (isInside && !groundContactPoint.isInContact()) {
            groundContactPoint.setInContact();
            groundContactPoint.setTouchdownToCurrentLocation();
            groundContactPoint.setSurfaceNormal((Vector3DReadOnly)this.surfaceNormalTemp);
        }
        return isInside;
    }

    private void doGroundContact(GroundContactPoint groundContactPoint) {
        if (groundContactPoint.isDisabled()) {
            groundContactPoint.setForce(0.0, 0.0, 0.0);
            return;
        }
        boolean inContact = this.checkIfInContactUsingProfile3D(groundContactPoint);
        if (!inContact) {
            groundContactPoint.setNotInContact();
            groundContactPoint.setIsSlipping(false);
            groundContactPoint.setForce(0.0, 0.0, 0.0);
            return;
        }
        this.resolveContactForce(groundContactPoint);
        this.checkIfSlipping(groundContactPoint);
    }

    private void resolveContactForce(GroundContactPoint groundContactPoint) {
        groundContactPoint.getTouchdownLocation((Point3DBasics)this.touchdownLocation);
        groundContactPoint.getPosition((Tuple3DBasics)this.position);
        groundContactPoint.getVelocity((Vector3DBasics)this.velocity);
        this.deltaPositionFromTouchdown.sub((Tuple3DReadOnly)this.touchdownLocation, (Tuple3DReadOnly)this.position);
        if (this.groundEnableSurfaceNormal.getBooleanValue()) {
            this.resolveContactForceUsingSurfaceNormal(this.deltaPositionFromTouchdown, this.velocity, groundContactPoint);
        } else {
            this.resolveContactForceZUp(this.deltaPositionFromTouchdown, this.velocity, groundContactPoint);
        }
    }

    private void resolveContactForceUsingSurfaceNormal(Vector3D deltaPositionFromTouchdown, Vector3D velocity, GroundContactPoint groundContactPoint) {
        groundContactPoint.getSurfaceNormal((Vector3DBasics)this.surfaceNormalTemp);
        this.tempVector.set(0.0, 1.0, 0.0);
        if (this.tempVector.dot((Tuple3DReadOnly)this.surfaceNormalTemp) == 1.0 || this.tempVector.dot((Tuple3DReadOnly)this.surfaceNormalTemp) == -1.0) {
            this.tempVector.set(1.0, 0.0, 0.0);
        }
        this.inPlaneVector1.cross((Tuple3DReadOnly)this.tempVector, (Tuple3DReadOnly)this.surfaceNormalTemp);
        this.inPlaneVector1.normalize();
        this.inPlaneVector2.cross((Tuple3DReadOnly)this.surfaceNormalTemp, (Tuple3DReadOnly)this.inPlaneVector1);
        this.inPlaneVector2.normalize();
        double xPrime = this.inPlaneVector1.dot((Tuple3DReadOnly)deltaPositionFromTouchdown);
        double yPrime = this.inPlaneVector2.dot((Tuple3DReadOnly)deltaPositionFromTouchdown);
        double zPrime = this.surfaceNormalTemp.dot((Tuple3DReadOnly)deltaPositionFromTouchdown);
        this.forceParallel.set(this.inPlaneVector1);
        this.forceParallel.scale(xPrime);
        this.forceParallel.scaleAdd(yPrime, (Tuple3DReadOnly)this.inPlaneVector2, (Tuple3DReadOnly)this.forceParallel);
        this.forceParallel.scale(this.groundKxy.getDoubleValue());
        this.forceNormal.set(this.surfaceNormalTemp);
        if (this.groundStiffeningLength.getDoubleValue() - zPrime > 0.002) {
            this.forceNormal.scale(this.groundKz.getDoubleValue() * zPrime / (this.groundStiffeningLength.getDoubleValue() - zPrime));
        } else {
            this.forceNormal.scale(this.groundKz.getDoubleValue() * zPrime / 0.002);
        }
        xPrime = this.inPlaneVector1.dot((Tuple3DReadOnly)velocity);
        yPrime = this.inPlaneVector2.dot((Tuple3DReadOnly)velocity);
        zPrime = this.surfaceNormalTemp.dot((Tuple3DReadOnly)velocity);
        this.forceParallel.scaleAdd(-this.groundBxy.getDoubleValue() * xPrime, (Tuple3DReadOnly)this.inPlaneVector1, (Tuple3DReadOnly)this.forceParallel);
        this.forceParallel.scaleAdd(-this.groundBxy.getDoubleValue() * yPrime, (Tuple3DReadOnly)this.inPlaneVector2, (Tuple3DReadOnly)this.forceParallel);
        this.forceNormal.scaleAdd(-this.groundBz.getDoubleValue() * zPrime, (Tuple3DReadOnly)this.surfaceNormalTemp, (Tuple3DReadOnly)this.forceNormal);
        double magnitudeOfForceNormal = this.forceNormal.dot((Tuple3DReadOnly)this.surfaceNormalTemp);
        if (magnitudeOfForceNormal < 0.0) {
            if (zPrime < 0.0) {
                this.forceParallel.set(0.0, 0.0, 0.0);
                this.forceNormal.set(0.0, 0.0, 0.0);
                groundContactPoint.setNotInContact();
            } else {
                this.forceNormal.set(0.0, 0.0, 0.0);
            }
        }
        this.forceWorld.set(this.forceParallel);
        this.forceWorld.add((Tuple3DReadOnly)this.forceNormal);
        groundContactPoint.setForce((Vector3DReadOnly)this.forceWorld);
    }

    private void resolveContactForceZUp(Vector3D deltaPositionFromTouchdown, Vector3D velocity, GroundContactPoint groundContactPoint) {
        double xForce = this.groundKxy.getDoubleValue() * deltaPositionFromTouchdown.getX() - this.groundBxy.getDoubleValue() * velocity.getX();
        double yForce = this.groundKxy.getDoubleValue() * deltaPositionFromTouchdown.getY() - this.groundBxy.getDoubleValue() * velocity.getY();
        double zForce = this.groundStiffeningLength.getDoubleValue() - deltaPositionFromTouchdown.getZ() > 0.002 ? this.groundKz.getDoubleValue() * deltaPositionFromTouchdown.getZ() / (this.groundStiffeningLength.getDoubleValue() - deltaPositionFromTouchdown.getZ()) - this.groundBz.getDoubleValue() * velocity.getZ() : this.groundKz.getDoubleValue() * deltaPositionFromTouchdown.getZ() / 0.002 - this.groundBz.getDoubleValue() * velocity.getZ();
        if (zForce < 0.0) {
            if (deltaPositionFromTouchdown.getZ() < 0.0) {
                xForce = 0.0;
                yForce = 0.0;
                zForce = 0.0;
                groundContactPoint.setNotInContact();
            } else {
                zForce = 0.0;
            }
        }
        groundContactPoint.setForce(xForce, yForce, zForce);
    }

    private void checkIfSlipping(GroundContactPoint groundContactPoint) {
        if (!this.groundEnableSlip.getBooleanValue()) {
            groundContactPoint.setIsSlipping(false);
            return;
        }
        groundContactPoint.getForce((Vector3DBasics)this.forceWorld);
        groundContactPoint.getSurfaceNormal((Vector3DBasics)this.surfaceNormalTemp);
        this.forceNormal.set(this.surfaceNormalTemp);
        this.forceNormal.scale(this.surfaceNormalTemp.dot((Tuple3DReadOnly)this.forceWorld));
        this.forceParallel.set(this.forceWorld);
        this.forceParallel.sub((Tuple3DReadOnly)this.forceNormal);
        double parallelSpringForce = this.forceParallel.length();
        double normalSpringForce = this.forceNormal.length();
        double ratio = parallelSpringForce / normalSpringForce;
        if (ratio > this.groundAlphaStick.getDoubleValue() || groundContactPoint.isSlipping() && ratio > this.groundAlphaSlip.getDoubleValue()) {
            boolean isInside;
            groundContactPoint.setIsSlipping(true);
            double parallelSlipForce = this.groundAlphaSlip.getDoubleValue() * normalSpringForce;
            double parallelScale = parallelSlipForce / parallelSpringForce;
            if (parallelScale < 1.0) {
                this.forceParallel.scale(parallelScale);
            }
            this.forceWorld.add((Tuple3DReadOnly)this.forceNormal, (Tuple3DReadOnly)this.forceParallel);
            groundContactPoint.setForce((Vector3DReadOnly)this.forceWorld);
            double len = this.forceParallel.length();
            if (len > 1.0E-7) {
                this.forceParallel.scale(1.0 / len);
            }
            groundContactPoint.getPosition((Tuple3DBasics)this.tempVector);
            groundContactPoint.getTouchdownLocation((Point3DBasics)this.touchDownPoint);
            this.tempVector.sub((Tuple3DReadOnly)this.touchDownPoint);
            this.forceParallel.scale(-0.05 * this.tempVector.length());
            this.touchDownPoint.add((Tuple3DReadOnly)this.forceParallel);
            groundContactPoint.setTouchdownLocation((Point3DReadOnly)this.touchDownPoint);
            if (this.groundProfile3D == null) {
                isInside = groundContactPoint.getZ() < 0.0;
                this.intersectionPositionInWorld.set(groundContactPoint.getX(), groundContactPoint.getY(), 0.0);
                this.surfaceNormalTemp.set(0.0, 0.0, 1.0);
            } else {
                isInside = this.groundProfile3D.checkIfInside(groundContactPoint.getX(), groundContactPoint.getY(), groundContactPoint.getZ(), (Point3DBasics)this.intersectionPositionInWorld, (Vector3DBasics)this.surfaceNormalTemp);
            }
            if (isInside) {
                groundContactPoint.setSurfaceNormal((Vector3DReadOnly)this.surfaceNormalTemp);
            }
        } else {
            groundContactPoint.setIsSlipping(false);
        }
    }

    private void zeroOutTemporaryVariables() {
        this.intersectionPositionInWorld.set(0.0, 0.0, 0.0);
        this.surfaceNormalTemp.set(0.0, 0.0, 0.0);
        this.touchDownPoint.set(0.0, 0.0, 0.0);
        this.tempVector.set(0.0, 0.0, 0.0);
        this.forceWorld.set(0.0, 0.0, 0.0);
        this.forceNormal.set(0.0, 0.0, 0.0);
        this.forceParallel.set(0.0, 0.0, 0.0);
    }
}

