/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.PinJointPhysics;
import us.ihmc.simulationconstructionset.torqueSpeedCurve.TorqueSpeedCurve;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class PinJoint
extends OneDegreeOfFreedomJoint {
    private static final long serialVersionUID = -8016564065453170730L;
    private AxisAngle axisAngle = new AxisAngle();
    protected YoDouble q;
    protected YoDouble qd;
    protected YoDouble qdd;
    protected YoDouble tau;
    public YoDouble tauJointLimit;
    public YoDouble tauVelocityLimit;
    public YoDouble tauDamping;
    public YoDouble qLowerLimit;
    public YoDouble qUpperLimit;
    public YoDouble kLimit;
    public YoDouble bLimit;
    private YoDouble b_damp;
    private YoDouble f_stiction;
    public YoDouble qd_max;
    public YoDouble b_vel_limit;
    public YoDouble tau_max;
    protected YoRegistry registry;
    public TorqueSpeedCurve torqueSpeedCurve;

    public PinJoint(String jname, Tuple3DReadOnly offset, Robot rob, Vector3DReadOnly axis) {
        super(jname, offset, rob);
        this.physics = new PinJointPhysics(this);
        this.registry = rob.getRobotsYoRegistry();
        this.initializeYoVariables(jname, this.registry);
        this.physics.u_i = new Vector3D();
        this.physics.u_i.set((Tuple3DReadOnly)axis);
        this.physics.u_i.normalize();
        this.setPinTransform3D(this.jointTransform3D, (Vector3DReadOnly)this.physics.u_i);
    }

    @Override
    protected void update() {
        this.setPinTransform3D(this.jointTransform3D, (Vector3DReadOnly)this.physics.u_i, this.q.getDoubleValue());
    }

    public void setInitialState(double q_init, double qd_init) {
        this.q.set(q_init);
        this.qd.set(qd_init);
    }

    public void getState(double[] state) {
        state[0] = this.q.getDoubleValue();
        state[1] = this.qd.getDoubleValue();
    }

    @Override
    public void setTau(double tau) {
        if (Double.isNaN(tau)) {
            throw new RuntimeException(this.getName() + " tau = NaN.");
        }
        this.tau.set(tau);
    }

    public void addTau(double tau) {
        if (Double.isNaN(tau)) {
            throw new RuntimeException("tau = NaN.");
        }
        this.tau.add(tau);
    }

    @Override
    public YoDouble getQYoVariable() {
        return this.q;
    }

    @Override
    public double getQ() {
        return this.q.getDoubleValue();
    }

    @Override
    public YoDouble getQDYoVariable() {
        return this.qd;
    }

    @Override
    public double getQD() {
        return this.qd.getDoubleValue();
    }

    @Override
    public YoDouble getQDDYoVariable() {
        return this.qdd;
    }

    @Override
    public double getQDD() {
        return this.qdd.getDoubleValue();
    }

    @Override
    public YoDouble getTauYoVariable() {
        return this.tau;
    }

    @Override
    public double getTau() {
        return this.tau.getDoubleValue();
    }

    @Override
    public void setQ(double q) {
        if (Double.isNaN(q)) {
            throw new RuntimeException("q = NaN.");
        }
        this.q.set(q);
    }

    @Override
    public void setQd(double qd) {
        if (Double.isNaN(qd)) {
            throw new RuntimeException("qd = NaN.");
        }
        this.qd.set(qd);
    }

    @Override
    public void setQdd(double qdd) {
        if (Double.isNaN(qdd)) {
            throw new RuntimeException("qdd = NaN.");
        }
        this.qdd.set(qdd);
    }

    public void setLimitStops(double q_min, double q_max, double k_limit, double b_limit) {
        if (this.tauJointLimit == null) {
            this.tauJointLimit = new YoDouble("tau_joint_limit_" + this.name, "PinJoint limit stop torque", this.registry);
            this.qLowerLimit = new YoDouble("qLowerLimit" + this.name, "Pin Joint minimum limit", this.registry);
            this.qUpperLimit = new YoDouble("qUpperLimit" + this.name, "Pin Joint maximum limit", this.registry);
            this.kLimit = new YoDouble("kLimit_" + this.name, "Pin Joint limit spring constant", this.registry);
            this.bLimit = new YoDouble("bLimit_" + this.name, "Pin Joint limit damping constant", this.registry);
        }
        this.qLowerLimit.set(q_min);
        this.qUpperLimit.set(q_max);
        this.kLimit.set(k_limit);
        this.bLimit.set(b_limit);
        if (q_min >= q_max) {
            throw new RuntimeException("q_min must be less than q_max. q_min=" + q_min + ", q_max=" + q_max);
        }
    }

    public void setVelocityLimits(double qd_max, double b_vel_limit) {
        if (this.tauVelocityLimit == null) {
            this.tauVelocityLimit = new YoDouble("tau_vel_limit_" + this.name, "PinJoint velocity limit torque", this.registry);
            this.b_vel_limit = new YoDouble("b_vel_limit_" + this.name, "PinJoint damping after maximum angular velocity is reached", this.registry);
            this.qd_max = new YoDouble("qd_max_" + this.name, "PinJoint maximum angular velocity", this.registry);
        }
        this.qd_max.set(qd_max);
        this.b_vel_limit.set(b_vel_limit);
    }

    public void setTorqueSpeedCurve(TorqueSpeedCurve torqueSpeedCurve) {
        this.torqueSpeedCurve = torqueSpeedCurve;
    }

    public void setTorqueLimits(double maxTorque) {
        if (this.tau_max == null) {
            this.tau_max = new YoDouble("tau_max_" + this.name, "PinJoint maximum torque", this.registry);
        }
        this.tau_max.set(Math.abs(maxTorque));
    }

    @Override
    public void setDamping(double b_damp) {
        if (this.tauDamping == null) {
            this.tauDamping = new YoDouble("tau_damp_" + this.name, "PinJoint damping torque", this.registry);
        }
        if (this.b_damp == null) {
            this.b_damp = new YoDouble("b_damp_" + this.name, "PinJoint damping parameter", this.registry);
        }
        this.b_damp.set(b_damp);
    }

    public void setStiction(double f_stiction) {
        if (this.tauDamping == null) {
            this.tauDamping = new YoDouble("tau_damp_" + this.name, "PinJoint damping torque", this.registry);
        }
        if (this.f_stiction == null) {
            this.f_stiction = new YoDouble("f_stiction_" + this.name, "PinJoint stiction force", this.registry);
        }
        this.f_stiction.set(f_stiction);
    }

    protected void setPinTransform3D(RigidBodyTransform t1, Vector3DReadOnly u_i) {
        this.setPinTransform3D(t1, u_i, 0.0);
    }

    protected void setPinTransform3D(RigidBodyTransform t1, Vector3DReadOnly u_i, double rotAng) {
        t1.setIdentity();
        this.axisAngle.set(u_i, rotAng);
        t1.getRotation().set((Orientation3DReadOnly)this.axisAngle);
    }

    protected void initializeYoVariables(String jname, YoRegistry registry) {
        this.q = new YoDouble("q_" + jname, "PinJoint angle", registry);
        this.qd = new YoDouble("qd_" + jname, "PinJoint anglular velocity", registry);
        this.qdd = new YoDouble("qdd_" + jname, "PinJoint angular acceleration", registry);
        this.tau = new YoDouble("tau_" + jname, "PinJoint torque", registry);
    }

    public void setDampingParameterOnly(double b_damp) {
        if (this.b_damp != null) {
            this.b_damp.set(b_damp);
        }
    }

    public void setStictionParameterOnly(double f_stiction) {
        if (this.f_stiction != null) {
            this.f_stiction.set(f_stiction);
        }
    }

    @Override
    public double getDamping() {
        if (this.b_damp == null) {
            return 0.0;
        }
        return this.b_damp.getDoubleValue();
    }

    @Override
    public double getTorqueLimit() {
        if (this.tau_max != null) {
            return this.tau_max.getDoubleValue();
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getVelocityLimit() {
        if (this.qd_max != null) {
            return this.qd_max.getDoubleValue();
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getJointUpperLimit() {
        if (this.qUpperLimit == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.qUpperLimit.getDoubleValue();
    }

    @Override
    public double getJointLowerLimit() {
        if (this.qLowerLimit == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.qLowerLimit.getDoubleValue();
    }

    private double getJointLimitStiffness() {
        if (this.kLimit == null) {
            return 0.0;
        }
        return this.kLimit.getDoubleValue();
    }

    private double getJointLimitDamping() {
        if (this.bLimit == null) {
            return 0.0;
        }
        return this.bLimit.getDoubleValue();
    }

    @Override
    public double getJointStiction() {
        if (this.f_stiction == null) {
            return 0.0;
        }
        return this.f_stiction.getDoubleValue();
    }

    @Override
    public String toString() {
        Object string = super.toString();
        string = (String)string + "\n q_min = " + this.getJointLowerLimit() + ", q_max = " + this.getJointUpperLimit();
        string = (String)string + "\n k_limit = " + this.getJointLimitStiffness() + ", b_limit = " + this.getJointLimitDamping();
        if (this.b_damp != null) {
            string = (String)string + "\n b_damp = " + this.b_damp.getDoubleValue();
        }
        if (this.f_stiction != null) {
            string = (String)string + "\n f_stiction = " + this.f_stiction.getDoubleValue();
        }
        if (this.qd_max != null) {
            string = (String)string + "\n qd_max = " + this.qd_max.getDoubleValue();
        }
        if (this.b_vel_limit != null) {
            string = (String)string + "\n b_vel_limit = " + this.b_vel_limit.getDoubleValue();
        }
        if (this.tau_max != null) {
            string = (String)string + "\n tau_max = " + this.tau_max.getDoubleValue();
        }
        return string;
    }
}

