/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.MovingGroundContactModel;
import us.ihmc.simulationconstructionset.MovingGroundProfile;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class CollisionGroundContactModel
implements GroundContactModel,
MovingGroundContactModel {
    private static final long serialVersionUID = -1038863972028441303L;
    private static final double defaultCoefficientOfRestitution = 0.5;
    private static final double defaultCoefficientOfFriction = 0.7;
    private final YoRegistry registry = new YoRegistry("CollisionGroundContactModel");
    private YoDouble groundRestitution;
    private YoDouble groundFriction;
    private List<GroundContactPoint> gcPoints;
    private GroundProfile3D profile3D;
    private MovingGroundProfile movingProfile;
    private final Vector3D tempForceOne = new Vector3D();
    private final Vector3D tempForceTwo = new Vector3D();
    private boolean microCollision;
    private Map<GroundContactPoint, YoBoolean> isInsideSpies = new HashMap<GroundContactPoint, YoBoolean>();
    private Map<GroundContactPoint, YoBoolean> microCollisionSpies = new HashMap<GroundContactPoint, YoBoolean>();
    private Map<GroundContactPoint, YoDouble> closestIntersectionSpies = new HashMap<GroundContactPoint, YoDouble>();
    private Map<GroundContactPoint, YoBoolean> contactIsCloseToGround = new HashMap<GroundContactPoint, YoBoolean>();
    private Vector3D normalVector = new Vector3D(0.0, 0.0, 1.0);
    private Vector3D velocityVector = new Vector3D(0.0, 0.0, 0.0);
    private Vector3D p_world = new Vector3D();
    boolean iterateForward = true;
    int jj = 0;
    private final Point3D closestIntersection = new Point3D();

    public CollisionGroundContactModel(Robot rob, YoRegistry parentRegistry) {
        this(rob, 0.5, 0.7, parentRegistry);
    }

    public CollisionGroundContactModel(Robot rob, double epsilon, double mu, YoRegistry parentRegistry) {
        this(rob, 0, epsilon, mu, parentRegistry);
    }

    public CollisionGroundContactModel(Robot robot, int groundContactGroupIdentifier, double epsilon, double mu, YoRegistry parentRegistry) {
        this(robot.getGroundContactPoints(groundContactGroupIdentifier), epsilon, mu, parentRegistry);
    }

    public CollisionGroundContactModel(List<GroundContactPoint> gcPoints, YoRegistry parentRegistry) {
        this(gcPoints, 0.5, 0.7, parentRegistry);
    }

    public CollisionGroundContactModel(List<GroundContactPoint> gcPoints, double epsilon, double mu, YoRegistry parentRegistry) {
        this.gcPoints = gcPoints;
        for (GroundContactPoint groundContactPoint : gcPoints) {
            this.isInsideSpies.put(groundContactPoint, new YoBoolean(groundContactPoint.getName() + "_isInsideSpy", this.registry));
            this.microCollisionSpies.put(groundContactPoint, new YoBoolean(groundContactPoint.getName() + "_microCollisionSpy", this.registry));
            this.closestIntersectionSpies.put(groundContactPoint, new YoDouble(groundContactPoint.getName() + "_closestIntersectionZ", this.registry));
            this.contactIsCloseToGround.put(groundContactPoint, new YoBoolean(groundContactPoint.getName() + "_isCloseToGround", this.registry));
        }
        this.groundRestitution = new YoDouble("groundRestitution", "CollisionGroundContactModel coefficient Of Restitution", this.registry);
        this.groundFriction = new YoDouble("groundFriction", "CollisionGroundContactModel coefficient Of Friction", this.registry);
        this.addRegistryToParent(parentRegistry);
        this.groundRestitution.set(epsilon);
        this.groundFriction.set(mu);
        this.initGroundContact();
    }

    @Override
    public void setGroundProfile3D(GroundProfile3D profile3D) {
        this.profile3D = profile3D;
        this.movingProfile = null;
    }

    @Override
    public GroundProfile3D getGroundProfile3D() {
        return this.profile3D;
    }

    @Override
    public void setGroundProfile(MovingGroundProfile profile) {
        this.profile3D = profile;
        this.movingProfile = null;
    }

    private void initGroundContact() {
    }

    @Override
    public void doGroundContact() {
        boolean bl = this.iterateForward = !this.iterateForward;
        if (this.iterateForward) {
            for (int i = 0; i < this.gcPoints.size(); ++i) {
                GroundContactPoint gc = this.gcPoints.get(i);
                this.doGroundContact(gc);
            }
        } else {
            for (int i = this.gcPoints.size() - 1; i >= 0; --i) {
                GroundContactPoint gc = this.gcPoints.get(i);
                this.doGroundContact(gc);
            }
        }
    }

    private void doGroundContact(GroundContactPoint gc) {
        if (gc.isDisabled()) {
            gc.setForce(0.0, 0.0, 0.0);
            return;
        }
        boolean isInside = false;
        if (this.profile3D != null) {
            isInside = this.profile3D.checkIfInside(gc.getX(), gc.getY(), gc.getZ(), (Point3DBasics)this.closestIntersection, (Vector3DBasics)this.normalVector);
            this.closestIntersectionSpies.get(gc).set(this.closestIntersection.getZ());
        }
        this.isInsideSpies.get(gc).set(isInside);
        if (isInside) {
            if (!gc.isInContact()) {
                this.microCollision = false;
                gc.setInContact();
                gc.setTouchdownToCurrentLocation();
            } else {
                this.microCollision = true;
            }
            this.microCollisionSpies.get(gc).set(this.microCollision);
        } else {
            gc.setNotInContact();
        }
        this.contactIsCloseToGround.get(gc).set(this.profile3D != null && this.profile3D.isClose(gc.getX(), gc.getY(), gc.getZ()));
        if (!this.contactIsCloseToGround.get(gc).getBooleanValue()) {
            return;
        }
        if (gc.isInContact()) {
            if (this.movingProfile != null) {
                this.movingProfile.velocityAt(gc.getX(), gc.getY(), gc.getZ(), this.velocityVector);
            } else {
                this.velocityVector.set(0.0, 0.0, 0.0);
            }
            if (this.microCollision) {
                double penetration_squared = this.profile3D != null ? (gc.getX() - this.closestIntersection.getX()) * (gc.getX() - this.closestIntersection.getX()) + (gc.getY() - this.closestIntersection.getY()) * (gc.getY() - this.closestIntersection.getY()) + (gc.getZ() - this.closestIntersection.getZ()) * (gc.getZ() - this.closestIntersection.getZ()) : gc.getZ() * gc.getZ();
                gc.resolveMicroCollision(penetration_squared, (Vector3DReadOnly)this.velocityVector, (Vector3DReadOnly)this.normalVector, this.groundRestitution.getDoubleValue(), this.groundFriction.getDoubleValue(), (Vector3DBasics)this.p_world);
                double RATE = 0.0;
                gc.getForce((Vector3DBasics)this.tempForceOne);
                this.tempForceTwo.set(this.p_world);
                this.tempForceTwo.scale(RATE);
                this.tempForceOne.add((Tuple3DReadOnly)this.tempForceTwo);
                gc.setForce((Vector3DReadOnly)this.tempForceOne);
            } else if (gc.getParentJoint() != null) {
                gc.resolveCollision((Vector3DReadOnly)this.velocityVector, (Vector3DReadOnly)this.normalVector, this.groundRestitution.getDoubleValue(), this.groundFriction.getDoubleValue(), (Vector3DBasics)this.p_world);
            }
            gc.incrementCollisionCount();
            if (this.p_world.getZ() < 0.0) {
                // empty if block
            }
        } else {
            gc.setForce(0.0, 0.0, 0.0);
            gc.setImpulse(0.0, 0.0, 0.0);
        }
    }

    private void addRegistryToParent(YoRegistry parentRegistry) {
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }
}

