/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics;

import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;
import us.ihmc.simulationconstructionset.physics.CollisionShapeWithLink;
import us.ihmc.simulationconstructionset.physics.collision.simple.SimpleCollisionShape;

public class SimpleCollisionShapeWithLink
extends SimpleCollisionShape
implements CollisionShapeWithLink {
    private final Link link;
    private final RigidBodyTransform shapeToLink = new RigidBodyTransform();
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();

    public SimpleCollisionShapeWithLink(Link link, CollisionShapeDescription collisionShapeDescription, RigidBodyTransform shapeToLink) {
        super(collisionShapeDescription);
        this.link = link;
        if (shapeToLink != null) {
            this.shapeToLink.set(shapeToLink);
        }
    }

    @Override
    public Link getLink() {
        return this.link;
    }

    @Override
    public void getShapeToLink(RigidBodyTransform shapeToLinkToPack) {
        shapeToLinkToPack.set(this.shapeToLink);
    }

    @Override
    public void getTransformToWorld(RigidBodyTransform transformToWorldToPack) {
        if (this.link != null) {
            this.link.getParentJoint().getTransformToWorld((RigidBodyTransformBasics)this.tempTransform);
            transformToWorldToPack.set(this.tempTransform);
            transformToWorldToPack.multiply((RigidBodyTransformReadOnly)this.shapeToLink);
        } else {
            super.getTransformToWorld(transformToWorldToPack);
        }
    }

    @Override
    public void setTransformToWorld(RigidBodyTransform transformToWorld) {
        if (this.link != null) {
            throw new RuntimeException("Shouldn't call this!");
        }
        super.setTransformToWorld(transformToWorld);
    }
}

