/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import com.jmatio.io.MatFileIncrementalWriter;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLStructure;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import us.ihmc.log.LogTools;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.robotdefinition.RobotDefinitionFixedFrame;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.buffer.YoBufferVariableEntry;
import us.ihmc.yoVariables.variable.YoVariable;

public class DataFileWriter {
    private static final boolean DEBUG = true;
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy");
    private final File outFile;

    public DataFileWriter(File file) {
        this.outFile = file;
    }

    public void writeData(String model, double recordDT, YoBuffer dataBuffer, List<YoVariable> vars, boolean binary, boolean compress) {
        this.writeData(model, recordDT, dataBuffer, vars, binary, compress, null);
    }

    public void writeData(String model, double recordDT, YoBuffer dataBuffer, List<YoVariable> vars, boolean binary, boolean compress, Robot robot) {
        if (binary) {
            this.writeBinaryData(model, recordDT, dataBuffer, vars, compress, robot);
        } else {
            this.writeASCIIData(model, recordDT, dataBuffer, vars, compress);
        }
    }

    public void writeState(String model, double recordDT, List<YoVariable> variables, boolean binary, boolean compress) {
        if (binary) {
            this.writeBinaryState(model, recordDT, variables, compress);
        } else {
            this.writeASCIIState(model, recordDT, variables, compress);
        }
    }

    private DataOutputStream openDataOutputStreamForWriting(File outFile, boolean compress) throws IOException {
        DataOutputStream dataStream = compress ? new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(outFile))))) : new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        return dataStream;
    }

    private void writeHeaderInformation(DataOutput dataOutputStream, List<YoBufferVariableEntry> entries, String model, double recordDT, YoBuffer dataBuffer, List<YoVariable> vars, boolean compress, Robot robot) throws IOException {
        String columnFormatted = "$COLUMN";
        int bufferLength = dataBuffer.getBufferInOutLength();
        this.writeHeaderInformation(dataOutputStream, entries, model, columnFormatted, recordDT, bufferLength, vars, compress, robot);
    }

    private void writeHeaderInformation(DataOutput dataOutputStream, List<YoBufferVariableEntry> entries, String model, String columnOrRowFormatted, double recordDT, int bufferLength, List<YoVariable> vars, boolean compress, Robot robot) throws IOException {
        YoVariable variable;
        YoBufferVariableEntry entry;
        int i;
        dataOutputStream.writeBytes("$BEGIN_HEADER\n");
        dataOutputStream.writeBytes("$WHEN " + ZonedDateTime.now().format(dateTimeFormatter) + "\n");
        dataOutputStream.writeBytes("$MODEL " + model + "\n");
        dataOutputStream.writeBytes("$INDIVIDUAL\n");
        dataOutputStream.writeBytes("$SUN_DATA\n");
        dataOutputStream.writeBytes("$BINARY\n");
        dataOutputStream.writeBytes(columnOrRowFormatted + "\n");
        dataOutputStream.writeBytes("$DT " + String.valueOf(recordDT) + "\n");
        int nVars = 0;
        if (entries != null) {
            for (i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                variable = entry.getVariable();
                if (!vars.contains(variable)) continue;
                ++nVars;
            }
        } else {
            nVars = vars.size();
        }
        dataOutputStream.writeBytes("$NVAR " + nVars + "\n");
        if (entries != null) {
            for (i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                variable = entry.getVariable();
                if (!vars.contains(variable)) continue;
                dataOutputStream.writeBytes("$VAR " + variable.getFullNameString() + " " + entry.getCustomLowerBound() + " " + entry.getCustomUpperBound() + "\n");
            }
        } else {
            for (i = 0; i < vars.size(); ++i) {
                YoVariable variable2 = vars.get(i);
                dataOutputStream.writeBytes("$VAR " + variable2.getFullNameString() + " -1.0 1.0\n");
            }
        }
        dataOutputStream.writeBytes("$N " + String.valueOf(bufferLength) + "\n");
        if (robot != null) {
            RobotDefinitionFixedFrame rd = new RobotDefinitionFixedFrame();
            rd.createRobotDefinitionFromRobot(robot);
            String robotConfig = "$" + rd.toString();
            robotConfig = this.replaceAll(robotConfig, "\n", "\n$");
            robotConfig = robotConfig.substring(0, robotConfig.length() - 1);
            dataOutputStream.writeBytes(robotConfig + "\n");
        } else {
            System.err.println("Warning: Could not write robot definition data: Robot is null");
        }
        dataOutputStream.writeBytes("$END_HEADER\n");
    }

    private String replaceAll(String orig, String regex, String rep) {
        int index = 0;
        while (index + regex.length() < orig.length()) {
            if (orig.substring(index, index + regex.length()).equals(regex)) {
                orig = this.replace(orig, index, index + regex.length(), rep);
                index += rep.length() - 1;
            }
            ++index;
        }
        return orig;
    }

    private String replace(String fullString, int beginIndex, int endIndex, String replacement) {
        if (beginIndex >= 0 && beginIndex < fullString.length() && endIndex >= 0 && endIndex < fullString.length()) {
            String prefix = fullString.substring(0, beginIndex);
            String suffix = fullString.substring(endIndex);
            return prefix + replacement + suffix;
        }
        return null;
    }

    public DataOutputStream openDataOutputStreamAndWriteHeaderInformationForLoggingData(String model, double recordDT, YoBuffer dataBuffer, List<YoVariable> vars, boolean compress) {
        return this.openDataOutputStreamAndWriteHeaderInformationForLoggingData(model, recordDT, dataBuffer, vars, compress, null);
    }

    private DataOutputStream openDataOutputStreamAndWriteHeaderInformationForLoggingData(String model, double recordDT, YoBuffer dataBuffer, List<YoVariable> vars, boolean compress, Robot robot) {
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = this.openDataOutputStreamForWriting(this.outFile, compress);
            List entries = null;
            if (dataBuffer != null) {
                entries = dataBuffer.getEntries();
            }
            String columnFormatted = "$ROW";
            int bufferLength = -1;
            this.writeHeaderInformation(dataOutputStream, entries, model, columnFormatted, recordDT, bufferLength, vars, compress, robot);
        }
        catch (IOException ioException) {
            System.err.println("Caught IOException in openDataOutputStreamAndWriteHeaderInformationForLoggingData. exception = " + ioException);
        }
        return dataOutputStream;
    }

    public void writeOutOneRowOfLogData(DataOutput dataOutputStream, List<YoVariable> variablesToWrite) throws IOException {
        for (YoVariable variableToWrite : variablesToWrite) {
            double value = variableToWrite.getValueAsDouble();
            dataOutputStream.writeFloat((float)value);
        }
    }

    public void writeOutOneRowOfLogData(DataOutput dataOutputStream, double[] dataToWrite, int numberOfVariables) throws IOException {
        if (numberOfVariables > dataToWrite.length) {
            throw new RuntimeException("numberOfVariables > dataToWrite.length");
        }
        for (int i = 0; i < numberOfVariables; ++i) {
            double value = dataToWrite[i];
            dataOutputStream.writeFloat((float)value);
        }
    }

    public void writeMatlabBinaryData(double recordDT, YoBuffer dataBufferSortedByNamespace, List<YoVariable> vars) {
        try {
            MatFileIncrementalWriter writer = new MatFileIncrementalWriter(this.outFile);
            int bufferLength = dataBufferSortedByNamespace.getBufferInOutLength();
            List entries = dataBufferSortedByNamespace.getEntries();
            MLDouble dt = new MLDouble("DT", (double[][])new double[][]{{recordDT}});
            writer.write((MLArray)dt);
            MLStructure mlRoot = null;
            for (int i = 0; i < entries.size(); ++i) {
                YoBufferVariableEntry entry = (YoBufferVariableEntry)entries.get(i);
                YoVariable variable = entry.getVariable();
                List subNames = variable.getNamespace().getSubNames();
                int subNameDepth = 0;
                if (!vars.contains(variable)) continue;
                String rootName = (String)subNames.get(subNameDepth++);
                if (mlRoot == null) {
                    mlRoot = new MLStructure(rootName, new int[]{1, 1});
                } else if (!mlRoot.getName().equals(rootName)) {
                    writer.write(mlRoot);
                    LogTools.info((String)("MLStructure '" + mlRoot.getName() + "' written"), (Object)true);
                    mlRoot = new MLStructure(rootName, new int[]{1, 1});
                }
                MLStructure mlNode = mlRoot;
                while (subNameDepth < subNames.size()) {
                    String childSubName = (String)subNames.get(subNameDepth);
                    MLStructure mlSubNode = (MLStructure)mlNode.getField(childSubName);
                    if (mlSubNode == null) {
                        mlSubNode = new MLStructure(childSubName, new int[]{1, 1});
                        mlNode.setField(childSubName, (MLArray)mlSubNode);
                    }
                    mlNode = mlSubNode;
                    ++subNameDepth;
                }
                double[] data = entry.getBufferWindow(dataBufferSortedByNamespace.getInPoint(), bufferLength);
                MLDouble outArray = new MLDouble(variable.getName(), new int[]{1, bufferLength});
                for (int j = 0; j < bufferLength; ++j) {
                    outArray.set((Number)data[j], j);
                }
                mlNode.setField(variable.getName(), (MLArray)outArray);
            }
            if (mlRoot != null) {
                writer.write(mlRoot);
                LogTools.info((String)("MLStructure '" + mlRoot.getName() + "' written"), (Object)true);
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeBinaryData(String model, double recordDT, YoBuffer dataBuffer, List<YoVariable> vars, boolean compress, Robot robot) {
        try {
            DataOutputStream dataOutputStream = this.openDataOutputStreamForWriting(this.outFile, compress);
            List entries = dataBuffer.getEntries();
            this.writeHeaderInformation(dataOutputStream, entries, model, recordDT, dataBuffer, vars, compress, robot);
            int bufferLength = dataBuffer.getBufferInOutLength();
            for (int i = 0; i < entries.size(); ++i) {
                YoBufferVariableEntry entry = (YoBufferVariableEntry)entries.get(i);
                YoVariable variable = entry.getVariable();
                if (!vars.contains(variable)) continue;
                double[] data = entry.getBufferWindow(dataBuffer.getInPoint(), bufferLength);
                for (int j = 0; j < bufferLength; ++j) {
                    dataOutputStream.writeFloat((float)data[j]);
                }
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeASCIIData(String model, double recordDT, YoBuffer dataBuffer, List<YoVariable> vars, boolean compress) {
        List entries = dataBuffer.getEntries();
        try {
            int i;
            PrintStream printStream = compress ? new PrintStream(new BufferedOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(this.outFile))))) : new PrintStream(new BufferedOutputStream(new FileOutputStream(this.outFile)));
            int bufferLength = dataBuffer.getBufferInOutLength();
            String[] varnamesToWrite = new String[vars.size()];
            double[][] dataToWrite = new double[vars.size()][];
            for (i = 0; i < entries.size(); ++i) {
                YoBufferVariableEntry entry = (YoBufferVariableEntry)entries.get(i);
                YoVariable variable = entry.getVariable();
                if (!vars.contains(variable)) continue;
                varnamesToWrite[vars.indexOf((Object)variable)] = entry.getVariable().getFullNameString();
                varnamesToWrite[vars.indexOf((Object)variable)] = varnamesToWrite[vars.indexOf(variable)].replace("[", "");
                varnamesToWrite[vars.indexOf((Object)variable)] = varnamesToWrite[vars.indexOf(variable)].replace("]", "");
                double[] data = entry.getBufferWindow(dataBuffer.getInPoint(), bufferLength);
                dataToWrite[vars.indexOf((Object)variable)] = data;
            }
            printStream.println("DT = " + recordDT + ";");
            for (i = 0; i < varnamesToWrite.length; ++i) {
                printStream.print(varnamesToWrite[i] + " = [");
                for (int j = 0; j < bufferLength; ++j) {
                    double dataElement = dataToWrite[i][j];
                    printStream.print(dataElement + " ");
                }
                printStream.println("];");
            }
            printStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeSpreadsheetFormattedData(YoBuffer dataBuffer, List<? extends YoVariable> vars) {
        List entries = dataBuffer.getEntries();
        try {
            int i;
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.outFile)));
            int bufferLength = dataBuffer.getBufferInOutLength();
            String[] varnamesToWrite = new String[vars.size()];
            double[][] dataToWrite = new double[vars.size()][];
            for (i = 0; i < entries.size(); ++i) {
                YoBufferVariableEntry entry = (YoBufferVariableEntry)entries.get(i);
                YoVariable variable = entry.getVariable();
                if (!vars.contains(variable)) continue;
                varnamesToWrite[vars.indexOf((Object)variable)] = entry.getVariable().getFullNameString();
                double[] data = entry.getBufferWindow(dataBuffer.getInPoint(), bufferLength);
                dataToWrite[vars.indexOf((Object)variable)] = data;
            }
            for (i = 0; i < varnamesToWrite.length; ++i) {
                printStream.print(varnamesToWrite[i]);
                if (i < varnamesToWrite.length - 1) {
                    printStream.print(",");
                    continue;
                }
                printStream.println("");
            }
            for (int j = 0; j < bufferLength; ++j) {
                for (int i2 = 0; i2 < dataToWrite.length; ++i2) {
                    double[] data = dataToWrite[i2];
                    printStream.print(data[j]);
                    if (i2 < dataToWrite.length - 1) {
                        printStream.print(",");
                        continue;
                    }
                    printStream.println("");
                }
            }
            printStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeBinaryState(String model, double recordDT, List<YoVariable> variables, boolean compress) {
        try {
            YoVariable variable;
            int i;
            DataOutputStream dataStream = compress ? new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(this.outFile))))) : new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.outFile)));
            dataStream.writeBytes("$BEGIN_HEADER\n");
            dataStream.writeBytes("$WHEN " + ZonedDateTime.now().format(dateTimeFormatter) + "\n");
            dataStream.writeBytes("$MODEL " + model + "\n");
            dataStream.writeBytes("$INDIVIDUAL\n");
            dataStream.writeBytes("$SUN_DATA\n");
            dataStream.writeBytes("$BINARY\n");
            dataStream.writeBytes("$COLUMN\n");
            dataStream.writeBytes("$DT " + String.valueOf(recordDT) + "\n");
            dataStream.writeBytes("$NVAR " + String.valueOf(variables.size()) + "\n");
            for (i = 0; i < variables.size(); ++i) {
                variable = variables.get(i);
                dataStream.writeBytes("$VAR " + variable.getFullNameString() + " 1.0 1.0 \n");
            }
            dataStream.writeBytes("$N 1\n");
            dataStream.writeBytes("$END_HEADER\n");
            for (i = 0; i < variables.size(); ++i) {
                variable = variables.get(i);
                dataStream.writeFloat((float)variable.getValueAsDouble());
            }
            dataStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeASCIIState(String model, double recordDT, List<YoVariable> variables, boolean compress) {
        try {
            BufferedWriter out = compress ? new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(this.outFile)))))) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.outFile)));
            for (YoVariable variable : variables) {
                String namespaceName = variable.getRegistry().getNamespace().getName();
                String variableName = variable.getName();
                String variableValue = Double.toString(variable.getValueAsDouble());
                out.write(namespaceName + "." + variableName + " = " + variableValue + ";\n");
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeSpreadsheetFormattedState(YoBuffer dataBuffer, List<? extends YoVariable> vars) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.outFile)));
            for (YoVariable yoVariable : vars) {
                out.write(yoVariable.getFullNameString());
                boolean lastVariable = yoVariable == vars.get(vars.size() - 1);
                if (lastVariable) continue;
                out.write(",");
            }
            out.write("\n");
            for (YoVariable yoVariable : vars) {
                String variableValue = Double.toString(yoVariable.getValueAsDouble());
                out.write(variableValue);
                boolean lastVariable = yoVariable == vars.get(vars.size() - 1);
                if (lastVariable) continue;
                out.write(",");
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

