/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import java.util.Arrays;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class VaryingStairGroundProfile
extends GroundProfileFromHeightMap {
    private final BoundingBox3D boundingBox;
    private final double[] stepStartXValues;
    private final double[] groundHeights;

    public VaryingStairGroundProfile(double startX, double startZ, double[] stepTreads, double[] stepRises) {
        if (MathTools.min((double[])stepTreads) <= 0.0) {
            throw new RuntimeException("Step treads must be positive");
        }
        if (stepRises.length != stepTreads.length + 1) {
            throw new RuntimeException("stepHeights.length != stepTreads.length + 1");
        }
        double[] xCumulativeSum = MathTools.cumulativeSum((double[])stepTreads);
        this.stepStartXValues = new double[xCumulativeSum.length + 1];
        System.arraycopy(xCumulativeSum, 0, this.stepStartXValues, 1, xCumulativeSum.length);
        for (int i = 0; i < this.stepStartXValues.length; ++i) {
            this.stepStartXValues[i] = this.stepStartXValues[i] + startX;
        }
        double[] heightCumulativeSum = MathTools.cumulativeSum((double[])stepRises);
        this.groundHeights = new double[heightCumulativeSum.length + 1];
        System.arraycopy(heightCumulativeSum, 0, this.groundHeights, 1, heightCumulativeSum.length);
        for (int i = 0; i < this.groundHeights.length; ++i) {
            this.groundHeights[i] = this.groundHeights[i] + startZ;
        }
        double leadInX = 1.0;
        double leadOutX = 1.0;
        double xMin = startX - leadInX;
        double xMax = MathTools.max((double[])this.stepStartXValues) + leadOutX;
        double yMin = -1.0;
        double yMax = 1.0;
        double zMin = Double.NEGATIVE_INFINITY;
        double zMax = Double.POSITIVE_INFINITY;
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double height = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return height;
    }

    public double heightAt(double x, double y, double z) {
        int index = this.computeStepNumber(x);
        double height = this.computeGroundHeight(index);
        return height;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        normal.set(0.0, 0.0, 1.0);
    }

    public int computeStepNumber(double x) {
        int index = Arrays.binarySearch(this.stepStartXValues, x);
        if (index < 0) {
            index = -(index + 1);
        }
        return index;
    }

    public double computeStepStartX(int index) {
        MathTools.checkIntervalContains((long)index, (long)0L, (long)this.stepStartXValues.length);
        if (index == this.stepStartXValues.length) {
            return Double.POSITIVE_INFINITY;
        }
        return this.stepStartXValues[index];
    }

    public double computeGroundHeight(int index) {
        return this.groundHeights[index];
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

