/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.engine.featherstone;

import java.io.Serializable;
import org.ejml.data.DMatrix;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.SpatialVector;

public final class SpatialInertiaMatrix
implements Serializable {
    private static final long serialVersionUID = 1765931620079414651L;
    public Matrix3D A = new Matrix3D();
    public Matrix3D B = new Matrix3D();
    public Matrix3D C = new Matrix3D();
    public Matrix3D D = new Matrix3D();
    private Vector3D IA_s_top = new Vector3D();
    private Vector3D IB_s_bottom = new Vector3D();
    private Vector3D IC_s_top = new Vector3D();
    private Vector3D ID_s_bottom = new Vector3D();
    private final RotationMatrix ONE3d = new RotationMatrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    private Vector3D Atop = new Vector3D();
    private Vector3D Bbot = new Vector3D();
    private Vector3D Ctop = new Vector3D();
    private Vector3D Dbot = new Vector3D();
    private Vector3D botA = new Vector3D();
    private Vector3D botB = new Vector3D();
    private Vector3D topC = new Vector3D();
    private Vector3D topD = new Vector3D();
    private Vector3D v1 = new Vector3D();
    private Vector3D v2 = new Vector3D();
    private Vector3D v3 = new Vector3D();
    private Vector3D v4 = new Vector3D();
    private Matrix3D A_trans = new Matrix3D();
    private Matrix3D B_trans = new Matrix3D();
    private Matrix3D C_trans = new Matrix3D();
    private Matrix3D D_trans = new Matrix3D();

    public double sIs(SpatialVector s) {
        this.IA_s_top.set(s.top);
        this.A.transform((Tuple3DBasics)this.IA_s_top);
        this.IB_s_bottom.set(s.bottom);
        this.B.transform((Tuple3DBasics)this.IB_s_bottom);
        this.IC_s_top.set(s.top);
        this.C.transform((Tuple3DBasics)this.IC_s_top);
        this.ID_s_bottom.set(s.bottom);
        this.D.transform((Tuple3DBasics)this.ID_s_bottom);
        return s.bottom.dot((Vector3DReadOnly)this.IA_s_top) + s.bottom.dot((Vector3DReadOnly)this.IB_s_bottom) + s.top.dot((Vector3DReadOnly)this.IC_s_top) + s.top.dot((Vector3DReadOnly)this.ID_s_bottom);
    }

    public String toString() {
        return this.A.toString() + this.B.toString() + this.C.toString() + this.D.toString() + "\n";
    }

    public void multiply(SpatialVector sV) {
        this.Atop.set(sV.top);
        this.A.transform((Tuple3DBasics)this.Atop);
        this.Bbot.set(sV.bottom);
        this.B.transform((Tuple3DBasics)this.Bbot);
        this.Ctop.set(sV.top);
        this.C.transform((Tuple3DBasics)this.Ctop);
        this.Dbot.set(sV.bottom);
        this.D.transform((Tuple3DBasics)this.Dbot);
        sV.top.add((Tuple3DReadOnly)this.Atop, (Tuple3DReadOnly)this.Bbot);
        sV.bottom.add((Tuple3DReadOnly)this.Ctop, (Tuple3DReadOnly)this.Dbot);
    }

    public void sub(SpatialInertiaMatrix M2) {
        this.A.sub((Matrix3DReadOnly)M2.A);
        this.B.sub((Matrix3DReadOnly)M2.B);
        this.C.sub((Matrix3DReadOnly)M2.C);
        this.D.sub((Matrix3DReadOnly)M2.D);
    }

    public void add(SpatialInertiaMatrix M2) {
        this.A.add((Matrix3DReadOnly)M2.A);
        this.B.add((Matrix3DReadOnly)M2.B);
        this.C.add((Matrix3DReadOnly)M2.C);
        this.D.add((Matrix3DReadOnly)M2.D);
    }

    public void add(SpatialInertiaMatrix M1, SpatialInertiaMatrix M2) {
        this.A.add((Matrix3DReadOnly)M1.A, (Matrix3DReadOnly)M2.A);
        this.B.add((Matrix3DReadOnly)M1.B, (Matrix3DReadOnly)M2.B);
        this.C.add((Matrix3DReadOnly)M1.C, (Matrix3DReadOnly)M2.C);
        this.D.add((Matrix3DReadOnly)M1.D, (Matrix3DReadOnly)M2.D);
    }

    public void sub(SpatialInertiaMatrix M1, SpatialInertiaMatrix M2) {
        this.A.sub((Matrix3DReadOnly)M1.A, (Matrix3DReadOnly)M2.A);
        this.B.sub((Matrix3DReadOnly)M1.B, (Matrix3DReadOnly)M2.B);
        this.C.sub((Matrix3DReadOnly)M1.C, (Matrix3DReadOnly)M2.C);
        this.D.sub((Matrix3DReadOnly)M1.D, (Matrix3DReadOnly)M2.D);
    }

    public void getMatrix(DMatrix M) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                M.set(i, j, this.A.getElement(i, j));
                M.set(i, j + 3, this.B.getElement(i, j));
                M.set(i + 3, j, this.C.getElement(i, j));
                M.set(i + 3, j + 3, this.D.getElement(i, j));
            }
        }
    }

    public void getPlanarXYMatrix(DMatrix M) {
        M.set(0, 0, this.A.getElement(0, 2));
        M.set(0, 1, this.B.getElement(0, 0));
        M.set(0, 2, this.B.getElement(0, 1));
        M.set(1, 0, this.A.getElement(1, 2));
        M.set(1, 1, this.B.getElement(1, 0));
        M.set(1, 2, this.B.getElement(1, 1));
        M.set(2, 0, this.C.getElement(2, 2));
        M.set(2, 1, this.D.getElement(2, 0));
        M.set(2, 2, this.D.getElement(2, 1));
    }

    public void getPlanarXZMatrix(DMatrix M) {
        M.set(0, 0, this.A.getElement(0, 1));
        M.set(0, 1, this.B.getElement(0, 0));
        M.set(0, 2, this.B.getElement(0, 2));
        M.set(1, 0, this.A.getElement(2, 1));
        M.set(1, 1, this.B.getElement(2, 0));
        M.set(1, 2, this.B.getElement(2, 2));
        M.set(2, 0, this.C.getElement(1, 1));
        M.set(2, 1, this.D.getElement(1, 0));
        M.set(2, 2, this.D.getElement(1, 2));
    }

    public void getPlanarYZMatrix(DMatrix M) {
        M.set(0, 0, this.A.getElement(1, 0));
        M.set(0, 1, this.B.getElement(1, 1));
        M.set(0, 2, this.B.getElement(1, 2));
        M.set(1, 0, this.A.getElement(2, 0));
        M.set(1, 1, this.B.getElement(2, 1));
        M.set(1, 2, this.B.getElement(2, 2));
        M.set(2, 0, this.C.getElement(0, 0));
        M.set(2, 1, this.D.getElement(0, 1));
        M.set(2, 2, this.D.getElement(0, 2));
    }

    public void setInitArticulatedInertia(double mass, Matrix3D Inertia) {
        this.A.setM00(0.0);
        this.A.setM01(0.0);
        this.A.setM02(0.0);
        this.B.setM00(mass);
        this.B.setM01(0.0);
        this.B.setM02(0.0);
        this.A.setM10(0.0);
        this.A.setM11(0.0);
        this.A.setM12(0.0);
        this.B.setM10(0.0);
        this.B.setM11(mass);
        this.B.setM12(0.0);
        this.A.setM20(0.0);
        this.A.setM21(0.0);
        this.A.setM22(0.0);
        this.B.setM20(0.0);
        this.B.setM21(0.0);
        this.B.setM22(mass);
        this.C.set(Inertia);
        this.D.setM00(0.0);
        this.D.setM01(0.0);
        this.D.setM02(0.0);
        this.D.setM10(0.0);
        this.D.setM11(0.0);
        this.D.setM12(0.0);
        this.D.setM20(0.0);
        this.D.setM21(0.0);
        this.D.setM22(0.0);
    }

    public void set(SpatialInertiaMatrix spatialInertiaMatrix) {
        this.A.set(spatialInertiaMatrix.A);
        this.B.set(spatialInertiaMatrix.B);
        this.C.set(spatialInertiaMatrix.C);
        this.D.set(spatialInertiaMatrix.D);
    }

    public void oneMinus() {
        this.A.scale(-1.0);
        this.B.scale(-1.0);
        this.C.scale(-1.0);
        this.D.scale(-1.0);
        this.A.add((Matrix3DReadOnly)this.ONE3d);
        this.D.add((Matrix3DReadOnly)this.ONE3d);
    }

    public void Iss_sIs(SpatialInertiaMatrix I_hat_i, SpatialVector s_hat_i, double sIs) {
        this.Atop.set(s_hat_i.top);
        I_hat_i.A.transform((Tuple3DBasics)this.Atop);
        this.Bbot.set(s_hat_i.bottom);
        I_hat_i.B.transform((Tuple3DBasics)this.Bbot);
        this.Ctop.set(s_hat_i.top);
        I_hat_i.C.transform((Tuple3DBasics)this.Ctop);
        this.Dbot.set(s_hat_i.bottom);
        I_hat_i.D.transform((Tuple3DBasics)this.Dbot);
        this.v1.add((Tuple3DReadOnly)this.Atop, (Tuple3DReadOnly)this.Bbot);
        this.v1.scale(1.0 / sIs);
        this.v2.add((Tuple3DReadOnly)this.Ctop, (Tuple3DReadOnly)this.Dbot);
        this.v2.scale(1.0 / sIs);
        this.setInnerMul(this.A, this.v1, s_hat_i.bottom);
        this.setInnerMul(this.B, this.v1, s_hat_i.top);
        this.setInnerMul(this.C, this.v2, s_hat_i.bottom);
        this.setInnerMul(this.D, this.v2, s_hat_i.top);
    }

    public void IssI(SpatialInertiaMatrix I_hat_i, SpatialVector s_hat_i, double sIs) {
        this.Atop.set(s_hat_i.top);
        I_hat_i.A.transform((Tuple3DBasics)this.Atop);
        this.Bbot.set(s_hat_i.bottom);
        I_hat_i.B.transform((Tuple3DBasics)this.Bbot);
        this.Ctop.set(s_hat_i.top);
        I_hat_i.C.transform((Tuple3DBasics)this.Ctop);
        this.Dbot.set(s_hat_i.bottom);
        I_hat_i.D.transform((Tuple3DBasics)this.Dbot);
        this.v1.add((Tuple3DReadOnly)this.Atop, (Tuple3DReadOnly)this.Bbot);
        this.v1.scale(1.0 / sIs);
        this.v2.add((Tuple3DReadOnly)this.Ctop, (Tuple3DReadOnly)this.Dbot);
        this.v2.scale(1.0 / sIs);
        this.A_trans.set(I_hat_i.A);
        this.A_trans.transpose();
        this.B_trans.set(I_hat_i.B);
        this.B_trans.transpose();
        this.C_trans.set(I_hat_i.C);
        this.C_trans.transpose();
        this.D_trans.set(I_hat_i.D);
        this.D_trans.transpose();
        this.botA.set(s_hat_i.bottom);
        this.A_trans.transform((Tuple3DBasics)this.botA);
        this.botB.set(s_hat_i.bottom);
        this.B_trans.transform((Tuple3DBasics)this.botB);
        this.topC.set(s_hat_i.top);
        this.C_trans.transform((Tuple3DBasics)this.topC);
        this.topD.set(s_hat_i.top);
        this.D_trans.transform((Tuple3DBasics)this.topD);
        this.v3.add((Tuple3DReadOnly)this.botA, (Tuple3DReadOnly)this.topC);
        this.v4.add((Tuple3DReadOnly)this.botB, (Tuple3DReadOnly)this.topD);
        this.setInnerMul(this.A, this.v1, this.v3);
        this.setInnerMul(this.B, this.v1, this.v4);
        this.setInnerMul(this.C, this.v2, this.v3);
        this.setInnerMul(this.D, this.v2, this.v4);
    }

    public void setInnerMul(Matrix3D M, Vector3D v1, Vector3D v2) {
        M.setM00(v1.getX() * v2.getX());
        M.setM01(v1.getX() * v2.getY());
        M.setM02(v1.getX() * v2.getZ());
        M.setM10(v1.getY() * v2.getX());
        M.setM11(v1.getY() * v2.getY());
        M.setM12(v1.getY() * v2.getZ());
        M.setM20(v1.getZ() * v2.getX());
        M.setM21(v1.getZ() * v2.getY());
        M.setM22(v1.getZ() * v2.getZ());
    }
}

