/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.GUIConfigurationSaveAndLoad;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.LoadConfigurationDialogConstructor;
import us.ihmc.simulationconstructionset.util.XMLReaderUtility;
import us.ihmc.tools.gui.MyFileFilter;

public class LoadConfigurationDialogGenerator
implements LoadConfigurationDialogConstructor {
    private FileFilter dataFileFilter = new MyFileFilter(new String[]{".guiConf"}, "Gui Configuration (.guiConf)");
    private JFileChooser dataFileChooser;
    private JFrame frame;
    private StandardSimulationGUI myGUI;
    private SimulationConstructionSet sim;
    private boolean loadGraphGroups = true;
    private boolean loadEntryBoxes = true;
    private boolean loadViewPorts = false;
    private boolean loadGraphWindows = true;
    private boolean loadJPanels = false;
    private boolean loadMultiViews = false;

    public LoadConfigurationDialogGenerator(SimulationConstructionSet sim, JFrame frame, StandardSimulationGUI myGUI) {
        this.frame = frame;
        this.sim = sim;
        this.myGUI = myGUI;
        try {
            this.dataFileChooser = new JFileChooser();
            JPanel checkBoxes = new JPanel(new GridBagLayout());
            GridBagConstraints g = new GridBagConstraints();
            g.weightx = 1.0;
            g.weighty = 1.0;
            g.fill = 0;
            g.gridx = 0;
            g.gridy = 0;
            g.anchor = 18;
            g.insets = new Insets(0, 0, 0, 0);
            final JCheckBox graphGroups = new JCheckBox("Load Graph Groups", this.loadGraphGroups);
            graphGroups.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoadConfigurationDialogGenerator.this.loadGraphGroups = graphGroups.isSelected();
                }
            });
            checkBoxes.add((Component)graphGroups, g);
            ++g.gridy;
            final JCheckBox entryBoxes = new JCheckBox("Load Entry Boxes", this.loadEntryBoxes);
            entryBoxes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoadConfigurationDialogGenerator.this.loadEntryBoxes = entryBoxes.isSelected();
                }
            });
            checkBoxes.add((Component)entryBoxes, g);
            ++g.gridy;
            final JCheckBox viewPorts = new JCheckBox("Load Extra View Ports", this.loadViewPorts);
            viewPorts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoadConfigurationDialogGenerator.this.loadViewPorts = viewPorts.isSelected();
                }
            });
            checkBoxes.add((Component)viewPorts, g);
            ++g.gridy;
            final JCheckBox graphWindows = new JCheckBox("Load Graph Windows", this.loadGraphWindows);
            graphWindows.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoadConfigurationDialogGenerator.this.loadGraphWindows = graphWindows.isSelected();
                }
            });
            checkBoxes.add((Component)graphWindows, g);
            ++g.gridy;
            final JCheckBox loadjpanels = new JCheckBox("Load Extra JPanels", this.loadJPanels);
            loadjpanels.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoadConfigurationDialogGenerator.this.loadJPanels = loadjpanels.isSelected();
                }
            });
            checkBoxes.add((Component)loadjpanels, g);
            ++g.gridy;
            final JCheckBox multiviews = new JCheckBox("Load Multiple Views", this.loadMultiViews);
            multiviews.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoadConfigurationDialogGenerator.this.loadMultiViews = multiviews.isSelected();
                }
            });
            checkBoxes.add((Component)multiviews, g);
            ++g.gridy;
            this.dataFileChooser.setAccessory(checkBoxes);
            File Configs = new File("Configurations");
            if (!Configs.exists()) {
                Configs.mkdir();
            }
            String path = Configs.toURI().getPath();
            this.setCurrentDirectory(path);
            this.dataFileChooser.setAcceptAllFileFilterUsed(false);
            this.dataFileChooser.addChoosableFileFilter(this.dataFileFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.dataFileChooser.setCurrentDirectory(dir);
    }

    @Override
    public void setCurrentDirectory(String dir) {
        this.dataFileChooser.setCurrentDirectory(new File(dir));
    }

    @Override
    public void constructDialog() {
        this.load();
    }

    public void load() {
        this.sim.disableGUIComponents();
        if (this.dataFileChooser.showOpenDialog(this.frame) == 0) {
            File chosenFile = this.dataFileChooser.getSelectedFile();
            this.loadGUIConfigurationFile(chosenFile);
        }
        this.sim.enableGUIComponents();
    }

    @Override
    public synchronized void loadGUIConfigurationFile(File file) {
        String fileEnding = ".guiConf";
        try {
            String tempLine;
            String filename = file.getName();
            if (!filename.endsWith(fileEnding)) {
                filename = filename.concat(fileEnding);
                if (!file.getName().equals(filename)) {
                    File newChosenFile;
                    file = newChosenFile = new File(file.getParent(), filename);
                }
            }
            String name = file.getName().substring(0, file.getName().length() - fileEnding.length());
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String xmlRepresentation = "";
            while ((tempLine = reader.readLine()) != null) {
                xmlRepresentation = xmlRepresentation + tempLine;
            }
            if (this.loadGraphGroups) {
                GUIConfigurationSaveAndLoad.setupGraphGroups(this.myGUI, xmlRepresentation, name);
            }
            if (this.loadEntryBoxes) {
                this.loadEntryBoxArrayPanel(xmlRepresentation, file);
            }
            if (this.loadViewPorts) {
                this.setupMainViewport(xmlRepresentation);
                this.setupViewportWindows(xmlRepresentation);
            }
            if (this.loadGraphWindows) {
                GUIConfigurationSaveAndLoad.setupGraphWindows(this.myGUI, xmlRepresentation, "GraphWindows" + name);
                this.setupConfiguration(name);
            }
            if (this.loadMultiViews) {
                this.setupMultiViews(xmlRepresentation);
            }
            if (this.loadJPanels) {
                this.setupJPanels(xmlRepresentation, this.myGUI.canvas);
            }
            this.myGUI.makeCheckBoxesConsistentWithCamera();
            reader.close();
            System.out.println("Your file has been loaded.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setupMultiViews(String xmlRepresentation) {
        this.myGUI.addViewportPanelToMainPanel();
        String CurrentView = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)"<Current View>", (String)"</Current View>");
        this.myGUI.selectViewport(CurrentView);
        this.myGUI.setupMultiViews(xmlRepresentation, CurrentView);
    }

    public void setupJPanels(String xmlRepresentation, Component canvas) {
        int i;
        String extraPanel = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)"<Extra Panels>", (String)"</Extra Panels>");
        int numberOfViewports = Integer.parseInt(XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)"<Number of ViewPorts>", (String)"</Number of ViewPorts>"));
        String mainViewportPanels = XMLReaderUtility.getMiddleString((int)0, (String)extraPanel, (String)"<Main Viewport>", (String)"</Main Viewport>");
        StringTokenizer tok = new StringTokenizer(mainViewportPanels, ",");
        String jPanelName = "";
        int size = tok.countTokens();
        for (i = 0; i < size; ++i) {
            jPanelName = tok.nextToken();
            this.myGUI.addPanelToTempHolderMainViewport(jPanelName);
            this.myGUI.makeCheckMarksConsistentForExtraPanels(jPanelName, true);
        }
        for (i = 1; i < numberOfViewports; ++i) {
            String viewportStartName = "<Viewport" + i + ">";
            String viewportEndName = "</Viewport" + i + ">";
            String viewport = XMLReaderUtility.getMiddleString((int)0, (String)extraPanel, (String)viewportStartName, (String)viewportEndName);
            StringTokenizer viewportToken = new StringTokenizer(viewport, ",");
            jPanelName = "";
            size = viewportToken.countTokens();
            for (int j = 0; j < size; ++j) {
                jPanelName = viewportToken.nextToken();
                this.myGUI.addPanelToTempHolderViewport(jPanelName, i);
                this.myGUI.makeCheckMarksConsistentForExtraPanels(jPanelName, true);
            }
        }
    }

    public void setupMainViewport(String xmlRepresentation) {
        boolean visible = this.myGUI.setViewportFromXMLDescription(xmlRepresentation);
        if (!visible) {
            this.myGUI.hideViewport();
        }
    }

    public void setupViewportWindows(String xmlRepresentation) {
        int numberofviewports = Integer.parseInt(XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)"<Number of ViewPorts>", (String)"</Number of ViewPorts>"));
        for (int i = 1; i < numberofviewports; ++i) {
            String second;
            CameraConfiguration config = new CameraConfiguration("viewport" + i);
            boolean maximizeWindow = false;
            String first = "<Viewport" + i + ">";
            String textToLoad = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)first, (String)(second = "</Viewport" + i + ">"));
            String visible = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Visible>", (String)"</Visible>").trim();
            if (visible.equals("false")) {
                this.myGUI.createNewViewportWindow("viewport" + i, 1, maximizeWindow, config).hideViewport();
            } else {
                this.myGUI.createNewViewportWindow("viewport" + i, 1, maximizeWindow, config);
            }
            int canvasNumber = Integer.parseInt(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Canvas Number>", (String)"</Canvas Number>"));
            String currentView = "Normal View";
            if (canvasNumber == 2) {
                currentView = "Split Screen";
            }
            if (canvasNumber == 3) {
                currentView = "Three Views";
            }
            if (canvasNumber == 4) {
                currentView = "Four Views";
            }
            this.myGUI.selectViewport_ViewPorts(currentView);
            this.myGUI.setupMultiViewsMultipleViewports(textToLoad, canvasNumber);
        }
    }

    public void setupConfiguration(String configurationName) {
        this.myGUI.setupConfiguration(configurationName, configurationName, configurationName);
        this.myGUI.selectGraphConfiguration(configurationName);
    }

    public void loadEntryBoxArrayPanel(String XMLStyleRepresentation, File file) {
        String XMLData = XMLReaderUtility.getMiddleString((int)0, (String)XMLStyleRepresentation, (String)"<Entry Boxes>", (String)"</Entry Boxes>");
        int index = 0;
        int currentNumberOfVariables = 0;
        if (XMLData == null) {
            return;
        }
        while (XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",") <= XMLData.length() && XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",") > 0) {
            ++currentNumberOfVariables;
            ++index;
        }
        if (index < XMLData.length()) {
            ++currentNumberOfVariables;
        }
        String[] name = new String[currentNumberOfVariables];
        currentNumberOfVariables = 0;
        index = 0;
        while (XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",") <= XMLData.length() && XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",") > 0) {
            int endIndex = XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",");
            name[currentNumberOfVariables] = XMLData.substring(index, endIndex - 1);
            name[currentNumberOfVariables] = name[currentNumberOfVariables].trim();
            ++currentNumberOfVariables;
            index = endIndex;
        }
        if (index < XMLData.length()) {
            name[currentNumberOfVariables] = XMLData.substring(index, XMLData.length());
            name[currentNumberOfVariables] = name[currentNumberOfVariables].trim();
        }
        this.sim.setupEntryBoxGroup(file.getName(), name);
        this.myGUI.updateGUI();
        this.myGUI.selectEntryBoxGroup(file.getName());
    }

    public void closeAndDispose() {
        this.dataFileFilter = null;
        this.dataFileChooser = null;
        this.frame = null;
        this.myGUI = null;
        this.sim = null;
    }
}

