/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.actions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.AbstractActionTools;
import us.ihmc.yoVariables.buffer.interfaces.KeyPointsChangedListener;
import us.ihmc.yoVariables.buffer.interfaces.KeyPointsHolder;

public class ToggleKeyPointModeAction
extends AbstractAction
implements KeyPointsChangedListener {
    private static final long serialVersionUID = 1500047530568017379L;
    private final String iconFilename = "icons/ToggleKeyMode.png";
    private final String altFilename = "icons/ToggleKeyModePressed.png";
    private Image iconImage = AbstractActionTools.loadActionImageUsingInputStream(this, "icons/ToggleKeyMode.png");
    private Image altImage = AbstractActionTools.loadActionImageUsingInputStream(this, "icons/ToggleKeyModePressed.png");
    private ImageIcon icon = new ImageIcon(this.iconImage);
    private KeyPointsHolder executor;

    public ToggleKeyPointModeAction(KeyPointsHolder executor) {
        super("Toggle Key Mode");
        this.executor = executor;
        this.putValue("SmallIcon", this.icon);
        this.putValue("LongDescription", "Long Description");
        this.putValue("ShortDescription", "Short Description");
        executor.addListener((KeyPointsChangedListener)this);
    }

    public void changed(KeyPointsChangedListener.Change change) {
        if (change.wasToggled()) {
            if (this.executor.areKeyPointsEnabled()) {
                this.icon.setImage(this.iconImage);
            } else {
                this.icon.setImage(this.altImage);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.executor.toggleKeyPoints();
    }

    public void closeAndDispose() {
        this.iconImage = null;
        this.altImage = null;
        this.icon = null;
        this.executor = null;
    }
}

