/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.gui.EntryBoxArrayPanel;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;
import us.ihmc.simulationconstructionset.gui.ForcedRepaintPopupMenu;
import us.ihmc.simulationconstructionset.gui.YoEntryBoxTargetListener;
import us.ihmc.simulationconstructionset.gui.YoEntryBoxTransferHandler;
import us.ihmc.simulationconstructionset.gui.YoEnumEntryContainer;
import us.ihmc.simulationconstructionset.gui.YoGraph;
import us.ihmc.simulationconstructionset.gui.YoTextEntryContainer;
import us.ihmc.simulationconstructionset.gui.YoVariableEntryContainer;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoEntryBox
extends JPanel
implements MouseListener,
ActionListener,
FocusListener,
ChangeListener {
    private final boolean USE_NEW_DISPLAY_FOR_ENUMS = true;
    protected static final String DEFAULT_UNBOUND_ENTRY_BOX_LABEL = "UNUSED";
    private static final long serialVersionUID = -3598041913472018651L;
    protected static final int COMPONENT_HEIGHT = 26;
    protected static final int MAX_COMPONENT_LENGTH = 400;
    protected static final int MIN_COMPONENT_LENGTH = 50;
    private Color origionalColor = null;
    private static ArrayList<YoVariableChangedListener> variableChangedListeners = new ArrayList();
    private YoVariableEntryContainer activeEntryContainer = new YoTextEntryContainer();
    private EntryBoxArrayPanel entryBoxArrayPanel;
    private JPopupMenu popupMenu;
    private SelectedVariableHolder selectedVariableHolder;

    public YoEntryBox(EntryBoxArrayPanel entryBoxArrayPanel, SelectedVariableHolder holder) {
        this.setLayout(new BoxLayout(this, 0));
        this.selectedVariableHolder = holder;
        this.entryBoxArrayPanel = entryBoxArrayPanel;
        this.setOpaque(true);
        this.setName(DEFAULT_UNBOUND_ENTRY_BOX_LABEL);
        this.activeEntryContainer.setup(this);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.setDropTarget(new DropTarget(this, new YoEntryBoxTargetListener(this)));
        this.setTransferHandler(new YoEntryBoxTransferHandler());
        this.popupMenu = new ForcedRepaintPopupMenu();
        JMenuItem delete = new JMenuItem("Delete Entry Box");
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(e);
                YoVariable variable = YoEntryBox.this.activeEntryContainer.getVariable();
                if (variable != null) {
                    YoEntryBox.this.removeVariable(variable);
                }
            }
        });
        this.popupMenu.add(delete);
        this.setToolTipText("");
        this.setPreferredSize(new Dimension(200, 26));
        this.origionalColor = this.getBackground();
    }

    public static void attachVariableChangedListener(YoVariableChangedListener listener) {
        variableChangedListeners.add(listener);
    }

    protected static void informVariableChangedListeners(YoVariable variableChanged) {
        for (int i = 0; i < variableChangedListeners.size(); ++i) {
            YoVariableChangedListener listener = variableChangedListeners.get(i);
            listener.changed(variableChanged);
        }
    }

    public static void removeVariableChangedListener(YoVariableChangedListener listener) {
        variableChangedListeners.remove(listener);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.activeEntryContainer.actionPerformed(this, evt);
    }

    public void addVariable(YoVariable variable) {
        if (this.entryBoxArrayPanel != null && this.entryBoxArrayPanel.isHoldingVariable(variable)) {
            return;
        }
        this.setVariableInThisBox(variable);
        this.updateActiveContainer();
        if (this.entryBoxArrayPanel != null) {
            this.entryBoxArrayPanel.checkStatus();
        }
    }

    @Override
    public void focusGained(FocusEvent evt) {
        if (this.activeEntryContainer.getVariable() != null) {
            this.activeEntryContainer.focusGained(this);
        } else {
            this.passOnFocusRequest();
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        if (this.activeEntryContainer.isEventSource(this, evt)) {
            if (this.activeEntryContainer.getVariable() != null) {
                this.activeEntryContainer.focusLost(this);
            }
        } else if (evt.getSource().equals(this) && this.popupMenu.isVisible()) {
            this.popupMenu.setVisible(false);
        }
    }

    public int getNumVars() {
        if (this.activeEntryContainer.getVariable() != null) {
            return 1;
        }
        return 0;
    }

    public SelectedVariableHolder getSelectedVariableHolder() {
        return this.selectedVariableHolder;
    }

    public YoVariable getVariableInThisBox() {
        return this.activeEntryContainer.getVariable();
    }

    public boolean isHoldingVariable(YoVariable v) {
        return this.activeEntryContainer.getVariable() == v;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.requestFocus();
        if (evt.isMetaDown() && !evt.isAltDown()) {
            this.popupMenu.setLocation(evt.getXOnScreen(), evt.getYOnScreen());
            this.popupMenu.setVisible(true);
        } else if (this.activeEntryContainer.getVariable() == null) {
            YoVariable v = this.selectedVariableHolder.getSelectedVariable();
            if (v != null) {
                this.addVariable(v);
            }
        } else {
            this.selectedVariableHolder.setSelectedVariable(this.activeEntryContainer.getVariable());
            if (!evt.isControlDown()) {
                this.getTransferHandler().exportAsDrag(this, evt, 2);
                YoGraph.setActionPerformedByDragAndDrop(2);
            } else if (evt.isControlDown()) {
                this.getTransferHandler().exportAsDrag(this, evt, 1);
                YoGraph.setActionPerformedByDragAndDrop(1);
            }
            YoGraph.setSourceOfDrag(this);
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    protected void passOnFocusRequest() {
        if (this.entryBoxArrayPanel != null) {
            this.entryBoxArrayPanel.requestFocus();
        } else {
            this.getParent().requestFocus();
        }
    }

    public void removeVariable(YoVariable variable) {
        this.activeEntryContainer.removeVariable(variable);
        this.setToolTipText("");
        this.setName("");
        if (this.entryBoxArrayPanel != null) {
            this.entryBoxArrayPanel.checkStatus();
        }
        if (this.popupMenu.isVisible()) {
            this.popupMenu.setVisible(false);
        }
        this.updateUI();
    }

    private void setContainerType(YoVariable variable) {
        if (variable instanceof YoEnum) {
            YoEnum enumVariable = (YoEnum)variable;
            this.switchContainerType(new YoEnumEntryContainer(enumVariable.getEnumValuesAsString()));
        } else {
            this.switchContainerType(new YoTextEntryContainer());
        }
    }

    private void switchContainerType(YoVariableEntryContainer yoEntryContainer) {
        this.activeEntryContainer.shutdown(this);
        this.activeEntryContainer = yoEntryContainer;
        this.activeEntryContainer.setup(this);
    }

    public synchronized void setTextField() {
        this.updateActiveContainer();
    }

    public void setVariableInThisBox(YoVariable variableInThisBox) {
        this.setContainerType(variableInThisBox);
        this.activeEntryContainer.bindToVariable(this, variableInThisBox);
        this.updateToolTipText(variableInThisBox);
        this.setName(variableInThisBox.getName() + "_YoEntryBox");
    }

    public void updateActiveContainer() {
        final YoEntryBox thisEntryBox = this;
        EventDispatchThreadHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                YoEntryBox.this.activeEntryContainer.update(thisEntryBox);
            }
        });
    }

    protected void updateToolTipText(YoVariable variableInThisBox) {
        String toolTip = variableInThisBox.getDescription();
        if (toolTip == null || toolTip.equals("")) {
            toolTip = variableInThisBox.getFullNameString();
        }
        this.setToolTipText(toolTip);
    }

    public YoVariableEntryContainer getActiveYoVariableEntryContainer() {
        return this.activeEntryContainer;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        YoVariable tmp = ((SelectedVariableHolder)e.getSource()).getSelectedVariable();
        if (this.activeEntryContainer.getVariable() != null) {
            if (this.activeEntryContainer.getVariable().equals(tmp)) {
                this.setBackground(Color.GREEN);
            } else {
                this.setBackground(this.origionalColor);
            }
        }
    }
}

