/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.util.StringTokenizer;
import us.ihmc.simulationconstructionset.util.XMLReaderUtility;

public class GraphConfiguration {
    private final String name;
    private static int id = 1;
    public static final int INDIVIDUAL_SCALING = 0;
    public static final int AUTO_SCALING = 1;
    public static final int MANUAL_SCALING = 2;
    public static final int TIME_PLOT = 100;
    public static final int PHASE_PLOT = 101;
    private double manualMinScaling = 0.0;
    private double manualMaxScaling = 1.0;
    private double minPhaseXScaling = 0.0;
    private double maxPhaseXScaling = 1.0;
    private int scalingMethod = 1;
    private int plotType = 100;
    private boolean showBaseLines = true;
    private double[] baseLines = new double[]{0.0};
    private static final GraphConfiguration standardAutoScalingConfiguration = new GraphConfiguration("auto", 1);

    public static GraphConfiguration getStandardAutoScalingConfiguration() {
        return standardAutoScalingConfiguration;
    }

    public GraphConfiguration(String name) {
        this.name = name;
    }

    public GraphConfiguration(String name, int scalingMethod) {
        this.name = name;
        this.scalingMethod = scalingMethod;
    }

    public GraphConfiguration(String name, int scalingMethod, double minScaling, double maxScaling) {
        this.name = name;
        this.scalingMethod = scalingMethod;
        this.manualMinScaling = minScaling;
        this.manualMaxScaling = maxScaling;
    }

    public String getName() {
        return this.name;
    }

    public void setScalingMethod(int scalingMethod) {
        this.scalingMethod = scalingMethod;
    }

    public int getScalingMethod() {
        return this.scalingMethod;
    }

    public void setPlotType(int plotType) {
        this.plotType = plotType;
    }

    public int getPlotType() {
        return this.plotType;
    }

    public void setShowBaseLines(boolean showBaseLines) {
        this.showBaseLines = showBaseLines;
    }

    public void setBaseLine(double baseLine) {
        this.baseLines = new double[]{baseLine};
    }

    public void setBaseLines(double baseLine1, double baseLine2) {
        this.baseLines = new double[]{baseLine1, baseLine2};
    }

    public void setPositiveNegativeBaseLines(double baseLine) {
        this.baseLines = new double[]{-baseLine, baseLine};
    }

    public void setBaseLines(double[] baseLines) {
        this.baseLines = baseLines;
    }

    public void setBaseLine(int baseLineIndex, double value) {
        if (baseLineIndex >= this.baseLines.length) {
            return;
        }
        this.baseLines[baseLineIndex] = value;
    }

    public void incrementBaseLine(int baseLineIndex, double amountToIncrement) {
        if (baseLineIndex >= this.baseLines.length) {
            return;
        }
        int n = baseLineIndex;
        this.baseLines[n] = this.baseLines[n] + amountToIncrement;
    }

    public boolean getShowBaseLines() {
        return this.showBaseLines;
    }

    public double[] getBaseLines() {
        return this.baseLines;
    }

    public void setManualScalingMinMax(double minScaling, double maxScaling) {
        this.manualMinScaling = minScaling;
        this.manualMaxScaling = maxScaling;
    }

    public void setPhasePlotXScalingMinMax(double minPhaseXScaling, double maxPhaseXScaling) {
        this.minPhaseXScaling = minPhaseXScaling;
        this.maxPhaseXScaling = maxPhaseXScaling;
    }

    public double getManualScalingMin() {
        return this.manualMinScaling;
    }

    public double getManualScalingMax() {
        return this.manualMaxScaling;
    }

    public String getXMLStyleRepresentationOfClass() {
        String returnString = "\t\t<GraphConfiguration>\n";
        returnString = returnString + "\t\t\t<Name>";
        returnString = returnString + "config" + id;
        ++id;
        returnString = returnString + "</Name>\n";
        returnString = returnString + "\t\t\t<ScalingMethod>";
        returnString = returnString + this.scalingMethod;
        returnString = returnString + "</ScalingMethod>\n";
        returnString = returnString + "\t\t\t<PlotType>";
        returnString = returnString + this.plotType;
        returnString = returnString + "</PlotType>\n";
        returnString = returnString + "\t\t\t<ShowBaseLines>";
        returnString = returnString + this.showBaseLines;
        returnString = returnString + "</ShowBaseLines>\n";
        returnString = returnString + "\t\t\t<BaseLines>";
        if (this.baseLines != null) {
            for (double baseLine : this.baseLines) {
                returnString = returnString + baseLine + ",";
            }
        }
        returnString = returnString + "</BaseLines>\n";
        returnString = returnString + "\t\t\t<MaxScaling>";
        returnString = returnString + this.manualMaxScaling;
        returnString = returnString + "</MaxScaling>\n";
        returnString = returnString + "\t\t\t<MinScaling>";
        returnString = returnString + this.manualMinScaling;
        returnString = returnString + "</MinScaling>\n";
        returnString = returnString + "\t\t</GraphConfig>";
        return returnString;
    }

    public static GraphConfiguration createClassBasedOnXMLRepresentation(int start, String xmlRepresentation) {
        GraphConfiguration tmp = null;
        try {
            String graphConfigurationString = XMLReaderUtility.getMiddleString((int)start, (String)xmlRepresentation, (String)"<GraphConfiguration>", (String)"</GraphConfig>");
            String name = XMLReaderUtility.getMiddleString((int)0, (String)graphConfigurationString, (String)"<Name>", (String)"</Name>");
            int scalingMethod = XMLReaderUtility.parseIntegerBetweenTwoStrings((int)0, (String)graphConfigurationString, (String)"<ScalingMethod>", (String)"</ScalingMethod>");
            int plotType = XMLReaderUtility.parseIntegerBetweenTwoStrings((int)0, (String)graphConfigurationString, (String)"<PlotType>", (String)"</PlotType>");
            boolean showBaseLines = XMLReaderUtility.parseBooleanBetweenTwoStrings((int)0, (String)graphConfigurationString, (String)"<ShowBaseLines>", (String)"</ShowBaseLines>");
            String baseLinesString = XMLReaderUtility.getMiddleString((int)0, (String)graphConfigurationString, (String)"<BaseLines>", (String)"</BaseLines>");
            StringTokenizer tokenizer = new StringTokenizer(baseLinesString, " /t/n/r/f,");
            double[] baseLines = new double[tokenizer.countTokens()];
            int numberOfTokens = tokenizer.countTokens();
            for (int i = 0; i < numberOfTokens; ++i) {
                baseLines[i] = XMLReaderUtility.parseDouble((String)tokenizer.nextToken());
            }
            double manualMaxScaling = XMLReaderUtility.parseDoubleBetweenTwoStrings((int)0, (String)graphConfigurationString, (String)"<MaxScaling>", (String)"</MaxScaling>");
            double manualMinScaling = XMLReaderUtility.parseDoubleBetweenTwoStrings((int)0, (String)graphConfigurationString, (String)"<MinScaling>", (String)"</MinScaling>");
            tmp = new GraphConfiguration(name, scalingMethod, manualMinScaling, manualMaxScaling);
            tmp.setPlotType(plotType);
            tmp.setShowBaseLines(showBaseLines);
            tmp.setBaseLines(baseLines);
        }
        catch (Exception e) {
            e.printStackTrace();
            XMLReaderUtility.displayErrorMessage();
            return null;
        }
        return tmp;
    }

    static {
        standardAutoScalingConfiguration.setBaseLine(0.0);
        standardAutoScalingConfiguration.setShowBaseLines(true);
    }
}

