/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class AlternatingSlopesGroundProfile
extends GroundProfileFromHeightMap {
    private BoundingBox3D boundingBox;
    private static final double defaultXMin = -10.0;
    private static final double defaultXMax = 10.0;
    private static final double defaultYMin = -10.0;
    private static final double defaultYMax = 10.0;
    private final double[][] xSlopePairs;
    private final double[][] xzPairs;

    public AlternatingSlopesGroundProfile(double[][] xSlopePairs) {
        this(xSlopePairs, -10.0, 10.0, -10.0, 10.0);
    }

    public AlternatingSlopesGroundProfile(double[][] xSlopePairs, double xMin, double xMax, double yMin, double yMax) {
        this.xSlopePairs = xSlopePairs;
        this.boundingBox = new BoundingBox3D((Point3DReadOnly)new Point3D(xMin, yMin, Double.NEGATIVE_INFINITY), (Point3DReadOnly)new Point3D(xMax, yMax, Double.MAX_VALUE));
        this.modifyXMinMaxIfNecessary();
        this.xzPairs = this.createXZPairsFromXSlopePairs(xSlopePairs);
        this.verifyXOrdering();
    }

    private void modifyXMinMaxIfNecessary() {
        double xMin = this.boundingBox.getMinX();
        double xMax = this.boundingBox.getMaxX();
        boolean changed = false;
        if (xMin > this.xSlopePairs[0][0] - 1.0E-7) {
            xMin = this.xSlopePairs[0][0] - 1.0E-7;
            changed = true;
        }
        if (xMax < this.xSlopePairs[this.xSlopePairs.length - 1][0] + 1.0E-7) {
            xMax = this.xSlopePairs[this.xSlopePairs.length - 1][0] + 1.0E-7;
            changed = true;
        }
        if (changed) {
            this.boundingBox = new BoundingBox3D(xMin, this.boundingBox.getMinY(), this.boundingBox.getMinZ(), xMax, this.boundingBox.getMaxY(), this.boundingBox.getMaxZ());
        }
    }

    private void verifyXOrdering() {
        double x = this.boundingBox.getMinX();
        for (int i = 0; i < this.xSlopePairs.length; ++i) {
            if (x + 1.0E-7 > this.xSlopePairs[i][0]) {
                throw new RuntimeException("Bad x ordering of points in AlternatingSlopesGroundProfile. Each point must increase!");
            }
            x = this.xSlopePairs[i][0];
        }
        if (x > this.boundingBox.getMaxX()) {
            throw new RuntimeException("Bad x ordering of points in AlternatingSlopesGroundProfile. Last Point is greater than xMax!");
        }
    }

    public double[][] getXZPairs() {
        return this.xzPairs;
    }

    private double[][] createXZPairsFromXSlopePairs(double[][] xSlopePairs) {
        int numPairs = xSlopePairs.length + 2;
        double[][] ret = new double[numPairs][2];
        double x = 0.0;
        double z = 0.0;
        double previousX = this.boundingBox.getMinX();
        double previousSlope = 0.0;
        ret[0][0] = this.boundingBox.getMinX();
        ret[0][1] = 0.0;
        for (int i = 0; i < numPairs - 2; ++i) {
            x = xSlopePairs[i][0];
            double run = x - previousX;
            double rise = previousSlope * run;
            ret[i + 1][0] = x;
            ret[i + 1][1] = z += rise;
            previousSlope = xSlopePairs[i][1];
            previousX = x;
        }
        ret[numPairs - 1][0] = this.boundingBox.getMaxX();
        double run = this.boundingBox.getMaxX() - previousX;
        double rise = previousSlope * run;
        ret[numPairs - 1][1] = z += rise;
        return ret;
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double height = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return height;
    }

    public double heightAt(double x, double y, double z) {
        int indexOnLeft = AlternatingSlopesGroundProfile.findIndexOnLeft(this.xzPairs, x);
        if (indexOnLeft < 0) {
            return 0.0;
        }
        if (indexOnLeft == this.xzPairs.length - 1) {
            return this.xzPairs[indexOnLeft][1];
        }
        double[] xzOnLeft = this.xzPairs[indexOnLeft];
        double[] xzOnRight = this.xzPairs[indexOnLeft + 1];
        double xOnLeft = xzOnLeft[0];
        double xOnRight = xzOnRight[0];
        double zOnLeft = xzOnLeft[1];
        double zOnRight = xzOnRight[1];
        double ret = zOnLeft + (x - xOnLeft) / (xOnRight - xOnLeft) * (zOnRight - zOnLeft);
        return ret;
    }

    private static int findIndexOnLeft(double[][] pairs, double x) {
        for (int i = 0; i < pairs.length; ++i) {
            double[] xzPair = pairs[i];
            if (!(x < xzPair[0])) continue;
            return i - 1;
        }
        return pairs.length - 1;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        int indexOnLeft = AlternatingSlopesGroundProfile.findIndexOnLeft(this.xSlopePairs, x);
        if (indexOnLeft < 0) {
            normal.set(0.0, 0.0, 1.0);
        } else if (indexOnLeft == this.xzPairs.length - 1) {
            normal.set(0.0, 0.0, 1.0);
        } else {
            double slope = this.xSlopePairs[indexOnLeft][1];
            normal.setX(-slope);
            normal.setY(0.0);
            normal.setZ(1.0);
            normal.normalize();
        }
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

